<?php
$frm_3_display  = "";
if($frm==3)
{
    $frm_3_display  = "display:none";
}
?>
<ul class="clearfix form-ul material">
    <li class="col-sm-2">
        <?php echo $form->textField($model, 'file_id', array('class' => 'tooltipster', 'data-label' => 'File No', 'value' => $model->file->id)); ?>
        <?php echo $form->error($model, 'file_id'); ?>
        <input type="hidden" id="del_order_date" name="del_order_date" value="<?php echo $modelOrder->order_date; ?>" />
    </li>
    <!--<li class="col-sm-4">
        <?php echo $form->textField($model, 'file_title', array('class' => 'tooltipster', 'data-label' => 'File Title')); ?>
        <?php echo $form->error($model, 'file_title'); ?>
    </li>-->
    <li class="col-sm-3">
        <?php
        $customer = $model->customer->customer_name; ?>
        <?php echo $form->textField($model, 'customer_name', array(
            'class' => 'text-bold',
            'data-label' => "Customer",
            'title' => 'Please select customer',
            'value' => $customer,
            'readonly' => 'readonly'
        ));
        ?>
        <?php echo $form->hiddenField($model, 'lead_owner_id', array('value' => $model->lead_owner_id)); ?>
        <?php echo $form->hiddenField($model, 'quotes_id', array('value' => $model->quotes_id)); ?>
        <?php echo $form->hiddenField($model, 'customer_id', array('value' => $model->customer_id)); ?>
        <?php echo $form->hiddenField($model, 'sales_group', array('value' => $model->sales_group)); ?>
        <?php echo $form->hiddenField($model, 'terms_id', array('value' => $model->terms_id)); ?>
        <?php echo $form->error($model, 'customer_id'); ?>
    </li>
    <div id="div_contact">
        <li class="col-sm-2">
            <?php
            $customer_id = $model->customer_id;
            echo $form->dropDownList($model, 'contact_id', CustomerContact::getCustomerContacts($customer_id), array(
                'options' => array($model->contact_id => array('selected' => true)),
                'readonly' => true,
                'data-label' => 'Contact Person'
            ));

            ?>
        </li>
    </div>
    <?php
    if (empty($model->inco_term_id)) {
        $defaultTerm = MasIncoTerms::model()->findByAttributes(['isDefault' => 'Y', 'isActive' => 'Y']);
        if ($defaultTerm) {
            $model->inco_term_id = $defaultTerm->id;
        }
    }
    ?>
    <li class="col-sm-2" style="display:none">
        <?php echo $form->dropDownList(
            $model,
            'inco_term_id',
            MasIncoTerms::getIncoTerms(),
            array(
                'prompt' => '--Select--',
                'data-label' => 'Inco Terms <span style="color:red">*</span>'
            )
        ); ?>
    </li>
    <li class="col-sm-2">
        <?php $delivery_date = date("d/m/Y"); ?>
        <?php echo $form->textField($model, 'delivery_date', array('class' => 'datepicker', 'data-label' => 'Delivery Date <span style="color:red">*</span>', 'value' => $delivery_date, 'onkeypress' => 'return false;')); ?>
        <?php echo $form->error($model, 'delivery_date'); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'lpo', array('data-label' => 'PO Reference', 'value' => $model->lpo)); ?>
        <?php echo $form->error($model, 'lpo'); ?>
    </li>
    
    <li class="col-sm-4">
        <?php echo $form->dropDownList(
            $model,
            'city',
            CustomerShippingDetails::getCity($model->customer_id),
            array(
                'data-label' => 'City',
                'prompt' => 'Select',
                'onchange' => 'getshippingAddress(this)'
            )
        ); ?>

    </li>
    <li class="col-sm-4" style="<?php echo $frm_3_display; ?>">
        <?php echo $form->textArea($model, 'shipping_address', array('data-label' => 'Shipping Address', 'class' => 'en-text-area')); ?>
        <?php echo $form->error($model, 'shipping_address'); ?>
    </li>
    <li class="col-sm-4" style="<?php echo $frm_3_display; ?>">
        <?php echo $form->textArea($model, 'shipping_conditions', array('data-label' => 'Shipping Condition', 'class' => 'en-text-area')); ?>
        <?php echo $form->error($model, 'shipping_conditions'); ?>
    </li>
    
    
    <!--<li class="col-sm-3">
        <?php /*echo $form->textField($model, 'project_location', array('class' => 'tooltipster', 'data-label' => 'Project Location')); ?>
</li>
<li class="col-sm-3">
<?php echo $form->dropDownList($model, 'delivery_state',array(1=>'Diatech Delivered',2=>'Client Collected'), array('data-label'=>'Type','empty'=>'--Select--'));*/ ?>
        </li>-->

    <li class="col-sm-3" style="<?php echo $frm_3_display; ?>">
        <?php echo $form->textArea($model, 'billing_address', array('data-label' => 'Billing Address', 'class' => 'en-text-area')); ?>
        <?php echo $form->error($model, 'billing_address'); ?>
    </li>

    <li class="col-sm-3" style="<?php echo $frm_3_display; ?>">

        <?php echo $form->textArea($model, 'notes', array('data-label' => 'Notes', 'class' => 'en-text-area')); ?>

        <?php echo $form->error($model, 'notes'); ?>

    </li>

    <li class="col-sm-3" style="<?php echo $frm_3_display; ?>">

        <?php echo $form->textArea($model, 'remarks', array('data-label' => 'Remarks', 'class' => 'en-text-area')); ?>

        <?php echo $form->error($model, 'remarks'); ?>

    </li>
    <li class="col-sm-3" style="<?php echo $frm_3_display; ?>">

        <?php echo $form->hiddenField($model, 'terms_id', array('value' => $model->terms_id)); ?>
        <?php echo $form->textArea($model, 'terms_and_conditions', array('rows' => 7, 'cols' => 60, 'data-label' => 'Terms & Conditions', 'class' => 'en-text-area')); ?>


    </li>

</ul>


<!-- <ul class="clearfix form-ul material">
                   <fieldset class="the-fieldset">  
                   <legend class="the-legend">Terms & Conditions</legend> 
                    
    <li class="col-sm-4">
                    <?php //echo $form->dropDownList($model, 'terms_id', MasTermsAndConditions::getTerms(),array('data-label'=>'Terms','prompt'=>'select')); ?>
                    <?php //echo $form->error($model, 'terms_id'); ?>
                    <button type="button" class="btn btn-theme" onclick="getTerms()" >Publish</button>
                </li>
    
    <li class="col-sm-8">

        <?php //echo $form->textArea($model, 'terms_and_conditions', array('rows' => 7, 'cols' => 60, 'data-label' => 'Terms & Conditions', 'class' => 'en-text-area')); ?>

        <?php //echo $form->error($model, 'terms_and_conditions'); ?>

    </li>

 </fieldset>
</ul> -->




<?php
$cs = Yii::app()->getClientScript('jquery.ui');
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("loadDelivery", '
        $(document).ready(function() {
        var order_date=$("#del_order_date").val(); 
        $("#DeliveryNote_delivery_date").datetimepicker({minDate: order_date, format: "DD/MM/YYYY"});

});', CClientScript::POS_HEAD);
$cs->registerScript("getTerms", " function getTerms() {
    
        var terms_id = $('#DeliveryNote_terms_id').val();
        jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('termsandcondition/getTermsFromId') . "',
                'data': {'term_id':terms_id},
                'cache': false,
                'success': function(data) {
                
                data.replace('<br>', '');
                   $('#DeliveryNote_terms_and_conditions').addClass('filled');
                   $('#DeliveryNote_terms_and_conditions').text(data);
                }
        });

        }", CClientScript::POS_HEAD);
?>
<style>
    .the-legend {
        border-style: none;
        border-width: 0;
        font-size: 15px;
        line-height: 20px;
        margin-bottom: 0;
        width: auto;
        padding: 6px 17px;
        border: 1px solid #e0e0e0;
        background: #1f67b2;
        color: white;
        font-weight: 500;
        border-radius: 18px 2%;
    }

    .the-fieldset {
        border: 1px solid #e0e0e0;
        padding: 10px;
        background: #d2e8ffa3;
        border-radius: 5px;

    }
</style>