<?php

$directory = Yii::getPathOfAlias('webroot')."/dbbackup"; // Specify the directory path

// Get the list of files in the directory
$files = scandir($directory);

// Exclude . and .. from the file list
$files = array_diff($files, array('.', '..'));

// Loop through the files and retrieve their sizes

// Function to format file size for better readability
function formatFileSize($size) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    $i = 0;
    
    while ($size >= 1024 && $i < count($units) - 1) {
        $size /= 1024;
        $i++;
    }
    
    return round($size, 2) . ' ' . $units[$i];
}



$form = $this->beginWidget('CActiveForm', array(
    'id' => 'loan-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-money"></i> Database Backup List
      
        </header>


<div id ="div_document_item_details">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="document_item_table">
            <tr>
                <th>No</th> 
                <th>File Name</th>
                <th>Size</th>
                <th class="text-center">
                    <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRowDoc($('#document_item_table'));"><i class="fa fa-plus"></i></a></th>
            </tr>
            <?php   
            $i=0;
            foreach ($files as $file) {
                $filePath = $directory . '/' . $file;
                $fileSize = filesize($filePath);
                $path_info = pathinfo($file);
                $file_extension = $path_info['extension']; 
                if($file_extension=='zip' || $file_extension=='csv'){
                ?>
                 <tr>
                    <td><label><?php echo ($i+1); ?></label></td> 
                    <td><?php echo $file; ?></td>                  
                    <td><?php echo formatFileSize($fileSize); ?></td>
                     <td class="text-center nw" width="1%"><?php echo CHtml::link('<i class="fa fa-download"></i>',array('dbbackup/downloadfile&file_name='.$file),array('title'=>'Download'));?></td>
                </tr>
                <?php
                $i++;
                }
            }
            ?>

        </table>
    </div>
</div>

<div class="modal-footer">

</div>

<?php $this->endWidget(); ?> 
</section>


<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("addTableRowDoc", "
  function addTableRowDoc(jQtable) {
    var newrow= jQtable.find('tr:last').clone();
    var lastId = jQtable.find('tr:last td>input').attr('id');
    var thenum = lastId.match(/\d+/g);
    var newId = Number(thenum) + 1;
    var newrow= jQtable.find('tr:last').clone();
    newrow.find('label').html(newId+1);
    newrow.find('.hasDatepicker').removeClass('hasDatepicker');
    newrow.find('.datetimepicker').siblings().remove();
    newrow.find('.datetimepicker').datetimepicker( 'destroy' );
    newrow.find('a,input,textarea,label,checkbox,select,div,.errorMessage').each(function() { 
                    this.id= this.id.replace(/\d+/,newId); 
                   if(!$(this).is(':checkbox'))
                        this.value  = ''; 
                    else
                        $(this).prop('checked', false);
                    (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : '';
    });
    jQtable.append(newrow);
    var uploader = new qq.FileUploader({
        element: document.getElementById('EmployeeDocuments_'+newId+'_upload_document_name'),
        params: { field_id: 'EmployeeDocuments_'+newId+'_document_file' },
        action : '" . Yii::app()->createUrl(Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/documents/')) . "',
        allowedExtensions: ['csv', 'zip', 'png', 'txt', 'pdf', 'doc', 'docx', 'jpg', 'jpeg', 'gif'],
        sizeLimit : 8 * 1024 * 1024,
        multiple : true,
        onComplete: function(id, fileName, responseJSON){
            var field_name = responseJSON.field_id;
            var file_name=responseJSON.filename;
            var val_doc = $('#EmployeeDocuments_'+newId+'_document_file').val();
             if(val_doc!='')
             {
                    $('#EmployeeDocuments_'+newId+'_document_file').val(val_doc+','+responseJSON.filename); 
             }
             else
             {
                    $('#EmployeeDocuments_'+newId+'_document_file').val(responseJSON.filename); 
             }
        },
    }); 
        var date_val='';
        $('#EmployeeDocuments_'+newId+'_validate_till_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
             var expiry_day = $('#EmployeeDocuments_'+newId+'_renewal_day').val();  
             var valid_date=new Date(e.date);
             var day=valid_date.getDate();
             var month=valid_date.getMonth()+1;
             var year=valid_date.getFullYear();
             var validdate=  day+ '/' + month + '/' + year;
            var parts = validdate.split('/');     
            var date =  new Date(parseInt(parts[2], 10),parseInt(parts[1], 10) - 1,parseInt(parts[0], 10));
            date.setDate( date.getDate() - expiry_day ); 
            $('#EmployeeDocuments_'+newId+'_renew_on').datetimepicker({format: 'DD/MM/YYYY'}).datetimepicker().val((date.getDate() ) + '/' + (date.getMonth()+1) + '/' + (date.getFullYear()));                          
        });        
  }", CClientScript::POS_HEAD);
$cs->registerScript("disabledatepickerfield", "function disabledatepickerfield(field_id,doc_id) {
    var arr_fields= field_id.split('_');
    var model_name= arr_fields[0];
    var row_field= arr_fields[1];  
     jQuery.ajax({
        'dataType':'json',
         'data': {'id':doc_id}  ,
        'type':'post',
        'url': '" . Yii::app()->createUrl('employee/getdocumenttype') . "',
        'cache': false,
        'success': function(data) {        
        if(data.document==2){
            $('#divdatefrom_'+row_field+'').hide(); 
            $('#divdateto_'+row_field+'').hide(); 
        }else{
            $('#divdatefrom_'+row_field+'').show(); 
            $('#divdateto_'+row_field+'').show(); 
            $('#EmployeeDocuments_'+row_field+'_renewal_day').val(data.expiry); 
        }
           
      }
    });
};", CClientScript::POS_HEAD);
$cs->registerScript("addexpiry", "
    $('#EmployeeDocuments_0_validate_till_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
        var expiry_day = $('#EmployeeDocuments_0_renewal_day').val();  
             var valid_date=new Date(e.date);
             var day=valid_date.getDate();
             var month=valid_date.getMonth()+1;
             var year=valid_date.getFullYear();
             var validdate=  day+ '/' + month + '/' + year;
            var parts = validdate.split('/');     
            var date =  new Date(parseInt(parts[2], 10),parseInt(parts[1], 10) - 1,parseInt(parts[0], 10));
            date.setDate( date.getDate() - expiry_day ); 
            $('#EmployeeDocuments_0_renew_on').datetimepicker({format: 'DD/MM/YYYY'}).datetimepicker().val((date.getDate() ) + '/' + (date.getMonth()+1) + '/' + (date.getFullYear()));                          
    });", CClientScript::POS_HEAD);
?>