<?php
$todayStart = date('Y-m-d 00:00:00');
$todayEnd = date('Y-m-d 23:59:59');
$weekStart = date('Y-m-d 00:00:00', strtotime('monday this week'));
$weekEnd = date('Y-m-d 23:59:59', strtotime('sunday this week'));
$monthStart = date('Y-m-01 00:00:00');
$monthEnd = date('Y-m-t 23:59:59');
$yearStart = date('Y-01-01 00:00:00');
$yearEnd = date('Y-12-31 23:59:59');
$lastMonthStart = date('Y-m-01 00:00:00', strtotime('first day of last month'));
$lastMonthEnd = date('Y-m-t 23:59:59', strtotime('last day of last month'));

$currentYear = date("Y");
$lastYear = $currentYear - 1;
$lastYearStart = $lastYear . '-01-01 00:00:00';
$lastYearEnd = $lastYear . '-12-31 23:59:59';
?>       
       
       <div class="panel-body">

          <!-- Your Panel Content -->



           <?php

        $vendorModel = Vendor::model();

// Today
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('created_date_time', date('Y-m-d 00:00:00'), date('Y-m-d 23:59:59'));
$todayVendorCount = $vendorModel->count($criteria);

// This Week
$criteria = new CDbCriteria();
$criteria->addBetweenCondition(
    'created_date_time',
    date('Y-m-d 00:00:00', strtotime('monday this week')),
    date('Y-m-d 23:59:59', strtotime('sunday this week'))
);
$weekVendorCount = $vendorModel->count($criteria);

// This Month
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('created_date_time', date('Y-m-01 00:00:00'), date('Y-m-t 23:59:59'));
$monthVendorCount = $vendorModel->count($criteria);

// This Year
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('created_date_time', date('Y-01-01 00:00:00'), date('Y-12-31 23:59:59'));
$yearVendorCount = $vendorModel->count($criteria);

// Previous Month
$startPrevMonth = date('Y-m-01 00:00:00', strtotime('first day of last month'));
$endPrevMonth = date('Y-m-t 23:59:59', strtotime('last day of last month'));
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('created_date_time', $startPrevMonth, $endPrevMonth);
$prevMonthVendorCount = $vendorModel->count($criteria);

// Previous Year
$startPrevYear = date('Y-01-01 00:00:00', strtotime('first day of January last year'));
$endPrevYear = date('Y-12-31 23:59:59', strtotime('last day of December last year'));
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('created_date_time', $startPrevYear, $endPrevYear);
$prevYearVendorCount = $vendorModel->count($criteria);

          ?>
          <!-- Header Row -->
          <div class="card-row">
            <div class="label-box"></div>
            <div class="stats-boxnw">
              <div class="td-clr"><strong>Today</strong></div>
              <div class="thiswk-clr"><strong>This Week</strong></div>
               <div class="ths-mnth-clr "><strong>This Month</strong></div>
              <div class="prev-mnt-clr"><strong>Prev Month</strong></div>
              <div class="ths-yr-clr"><strong>This Year</strong></div>
                <div class="prev-yr-clr"><strong>Prev Year</strong></div>
            </div>
          </div>

          <!-- Customers -->
          <div class="card-row">
            <div class="label-box customers left-bg">Suppliers</div>
            <div class="stats-box">
              <div class="tdy"><?php echo ($todayVendorCount > 0) ? $todayVendorCount : '-';?></div>
              <div class="this-wek">
              <?php echo ( $weekVendorCount > 0) ?  $weekVendorCount : '-';?>
              </div>
             
              <div class="this-month">
                
                 <?php echo ( $monthVendorCount > 0) ?  $monthVendorCount : '-';?>

              </div>
               <div class="prev-mnth">
                 <?php echo ( $prevMonthVendorCount > 0) ?  $prevMonthVendorCount : '-';?>
              </div>
          
              <div class="ths-yer">
                  <?php echo ( $yearVendorCount > 0) ?  $yearVendorCount : '-';?>
              </div>
              <div class="prev-yer"><?php echo ( $prevYearVendorCount > 0) ?  $prevYearVendorCount : '-';?></div>
            </div>
          </div>

           <?php
         $purchasingRequsation = PurchasingRequisition::model();

// Today
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('requisition_date', date('Y-m-d 00:00:00'), date('Y-m-d 23:59:59'));
$todayRequsationCount = $purchasingRequsation->count($criteria);

// This Week
$criteria = new CDbCriteria();
$criteria->addBetweenCondition(
    'requisition_date',
    date('Y-m-d 00:00:00', strtotime('monday this week')),
    date('Y-m-d 23:59:59', strtotime('sunday this week'))
);
$weekRequsationCount = $purchasingRequsation->count($criteria);

// This Month
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('requisition_date', date('Y-m-01 00:00:00'), date('Y-m-t 23:59:59'));
$monthRequsationCount = $purchasingRequsation->count($criteria);

// This Year
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('requisition_date', date('Y-01-01 00:00:00'), date('Y-12-31 23:59:59'));
$yearRequsationCount = $purchasingRequsation->count($criteria);

// Previous Month
$startPrevMonth = date('Y-m-01 00:00:00', strtotime('first day of last month'));
$endPrevMonth = date('Y-m-t 23:59:59', strtotime('last day of last month'));
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('requisition_date', $startPrevMonth, $endPrevMonth);
$prevMonthRequsationCount = $purchasingRequsation->count($criteria);

// Previous Year
$startPrevYear = date('Y-01-01 00:00:00', strtotime('first day of January last year'));
$endPrevYear = date('Y-12-31 23:59:59', strtotime('last day of December last year'));
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('requisition_date', $startPrevYear, $endPrevYear);
$prevYearRequsationCount = $purchasingRequsation->count($criteria);

          
           ?>

          <!-- Leads -->
          <div class="card-row">
            <div class="label-box leads left-bg"> Requisitions</div>
            <div class="stats-box">
              <div class="tdy"><?php  echo      ( $todayRequsationCount > 0) ?  $todayRequsationCount : '-';?></div>
              <div  class="this-wek"><?php  echo  ($weekRequsationCount > 0) ?  $weekRequsationCount : '-';?></div>
              <div class="this-month"><?php  echo  ($monthRequsationCount > 0) ?  $monthRequsationCount : '-';?></div>
              <div class="prev-mnth"><?php  echo   ($prevMonthRequsationCount > 0) ?  $prevMonthRequsationCount : '-';?></div>
              <div class="ths-yer"><?php  echo     ($yearRequsationCount > 0) ?  $yearRequsationCount : '-';?></div>
               <div class="prev-yer"><?php echo    ($prevYearRequsationCount > 0) ?  $prevYearRequsationCount : '-';?></div>
            </div>
          </div>


             <?php
         $purchasingEnquiry = PurchasingEnquiry::model();

// Today
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('enquiry_date', date('Y-m-d 00:00:00'), date('Y-m-d 23:59:59'));
$todayEnquiryCount = $purchasingEnquiry->count($criteria);

// This Week
$criteria = new CDbCriteria();
$criteria->addBetweenCondition(
    'enquiry_date',
    date('Y-m-d 00:00:00', strtotime('monday this week')),
    date('Y-m-d 23:59:59', strtotime('sunday this week'))
);
$weekEnquiryCount = $purchasingEnquiry->count($criteria);

// This Month
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('enquiry_date', date('Y-m-01 00:00:00'), date('Y-m-t 23:59:59'));
$monthEnquiryCount = $purchasingEnquiry->count($criteria);

// This Year
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('enquiry_date', date('Y-01-01 00:00:00'), date('Y-12-31 23:59:59'));
$yearEnquiryCount = $purchasingEnquiry->count($criteria);

// Previous Month
$startPrevMonth = date('Y-m-01 00:00:00', strtotime('first day of last month'));
$endPrevMonth = date('Y-m-t 23:59:59', strtotime('last day of last month'));
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('enquiry_date', $startPrevMonth, $endPrevMonth);
$prevMonthEnquiryCount = $purchasingEnquiry->count($criteria);

// Previous Year
$startPrevYear = date('Y-01-01 00:00:00', strtotime('first day of January last year'));
$endPrevYear = date('Y-12-31 23:59:59', strtotime('last day of December last year'));
$criteria = new CDbCriteria();
$criteria->addBetweenCondition('enquiry_date', $startPrevYear, $endPrevYear);
$prevYearEnquiryCount = $purchasingEnquiry->count($criteria);
?>


          <!-- Quotes -->
          <div class="card-row">
            <div class="label-box quotes left-bg">Enquiries</div>
            <div class="stats-box">
              <div class="tdy"><?php echo ( $todayEnquiryCount > 0) ?  $todayEnquiryCount : '-';?></div>
              <div class="this-wek"><?php echo ( $weekEnquiryCount > 0) ?  $weekEnquiryCount : '-';?></div>
              <div class="this-month"><?php echo  ( $monthEnquiryCount > 0) ?  $monthEnquiryCount : '-';?></div>
              <div class="prev-mnth"><?php echo  ( $prevMonthEnquiryCount > 0) ?  $prevMonthEnquiryCount : '-';?></div>
               <div class="ths-yer"><?php echo ( $yearEnquiryCount  > 0) ?  $yearEnquiryCount  : '-';?></div>
              <div class="prev-yer"><?php echo  ( $prevYearEnquiryCount  > 0) ?  $prevYearEnquiryCount  : '-';?></div>
            </div>
          </div>

      <?php
      $todayOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(stock_grand_total * exchange_rate),0) as total")
    ->from(" erp_purchasing_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
    ->queryRow();

$weekOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(stock_grand_total * exchange_rate),0) as total")
    ->from("erp_purchasing_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
    ->queryRow();

$monthOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(stock_grand_total * exchange_rate),0) as total")
    ->from("erp_purchasing_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
    ->queryRow();

$yearOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(stock_grand_total * exchange_rate),0) as total")
    ->from("erp_purchasing_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
    ->queryRow();

$lastMonthOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(stock_grand_total * exchange_rate),0) as total")
    ->from("erp_purchasing_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
    ->queryRow();

$lastYearOrder = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(stock_grand_total * exchange_rate),0) as total")
    ->from("erp_purchasing_order")
    ->where("order_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
    ->queryRow();
      ?>


          <!-- Orders -->
          <div class="card-row">
            <div class="label-box orders left-bg">Orders</div>
            <div class="stats-box">
              <div class="tdy"> <span><?php echo ( $todayOrder['count'] > 0) ? $todayOrder['count'] : '-'; ?></span> <span class="spn-last"><?php echo ($todayOrder['total'] > 0) ? number_format($todayOrder['total'], 2) : '-';  ?></span></div>
               <div class="this-wek"><span><?php echo ( $weekOrder['count'] > 0) ? $weekOrder['count'] : '-'; ?></span><span class="spn-last"><?php echo ($weekOrder['total'] > 0) ? number_format($weekOrder['total'], 2) : '-'; ?></span></div>
              <div class="this-month"><span><?php echo ( $monthOrder['count'] > 0) ? $monthOrder['count'] : '-'; ?></span><span class="spn-last"><?php echo ($monthOrder['total'] > 0) ? number_format($monthOrder['total'], 2) : '-'; ?></span></div>
             <div class="prev-mnth"><span><?php echo ($lastMonthOrder['count'] > 0) ? $lastMonthOrder['count'] : '-';?></span><span class="spn-last"><?php echo ($lastMonthOrder['total'] > 0) ? number_format($lastMonthOrder['total'], 2) : '-'; ?></span></div>
              <div class="ths-yer"><span><?php echo ($yearOrder['count'] > 0) ? $yearOrder['count'] : '-';?></span><span class="spn-last"><?php echo ($yearOrder['total'] > 0) ? number_format($yearOrder['total'], 2) : '-'; ?></span></div>
               <div class="prev-yer"><span><?php echo ($lastYearOrder['count'] > 0) ? $lastYearOrder['count'] : '-';;?></span><span class="spn-last"><?php echo ($lastYearOrder['total'] > 0) ? number_format($lastYearOrder['total'], 2) : '-'; ?></span></div>
            </div>
          </div>
<?php

          $todayInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_purchasinginvoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
    ->queryRow();

$weekInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_purchasinginvoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
    ->queryRow();

$monthInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_purchasinginvoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
    ->queryRow();

$yearInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_purchasinginvoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
    ->queryRow();

$lastMonthInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_purchasinginvoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
    ->queryRow();

$lastYearInvoice = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
    ->from("erp_purchasinginvoice")
    ->where("invoice_date BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
    ->queryRow();
    ?>

          <!-- Invoices -->
          <div class="card-row">
    <div class="label-box invoices left-bg ">Invoices</div>
    <div class="stats-box">
        <div class="tdy">
            <span><?php echo ($todayInvoice['count'] > 0) ? $todayInvoice['count'] : '-';  ?></span>
            <span class="spn-last"><?php echo ($todayInvoice['total'] > 0) ? number_format($todayInvoice['total'], 2) : '-'; ?></span>
        </div>
        <div class="this-wek">
            <span><?php echo ($weekInvoice['count'] > 0) ? $weekInvoice['count'] : '-'; ?></span>
            <span class="spn-last"><?php echo ($weekInvoice['total'] > 0) ? number_format($weekInvoice['total'], 2) : '-'; ?></span>
        </div>
        <div class="this-month">
            <span><?php echo ($monthInvoice['count'] > 0) ? $monthInvoice['count'] : '-';  ?></span>
            <span class="spn-last"><?php echo ($monthInvoice['total'] > 0) ? number_format($monthInvoice['total'], 2) : '-'; ?></span>
        </div>
        <div class="prev-mnth">
            <span><?php echo ($lastMonthInvoice['count'] > 0) ? $lastMonthInvoice['count'] : '-'; ?></span>
            <span class="spn-last"><?php echo ($lastMonthInvoice['total'] > 0) ? number_format($lastMonthInvoice['total'], 2) : '-'; ?></span>
        </div>
        <div class="ths-yer">
            <span><?php echo ($yearInvoice['count'] > 0) ? $yearInvoice['count'] : '-';  ?></span>
            <span class="spn-last"><?php echo ($yearInvoice['total'] > 0) ? number_format($yearInvoice['total'], 2) : '-'; ?></span>
        </div>
        <div class="prev-yer">
            <span><?php echo ($lastYearInvoice['count'] > 0) ? $lastYearInvoice['count'] : '-'; ?></span>
            <span class="spn-last"><?php echo ($lastYearInvoice['total'] > 0) ? number_format($lastYearInvoice['total'], 2) : '-'; ?></span>
        </div>
    </div>
</div>


<?php

      $todaydebitnote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(exchange_rate * debited_amount ),0) as total")
    ->from("erp_purchasing_debit_note")
    ->where("debited_date  BETWEEN :start AND :end", [":start" => $todayStart, ":end" => $todayEnd])
    ->queryRow();

$weekdebitnote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(exchange_rate * debited_amount ),0) as total")
    ->from("erp_purchasing_debit_note")
    ->where("debited_date  BETWEEN :start AND :end", [":start" => $weekStart, ":end" => $weekEnd])
    ->queryRow();

$monthdebitnote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(exchange_rate * debited_amount ),0) as total")
    ->from("erp_purchasing_debit_note")
    ->where("debited_date  BETWEEN :start AND :end", [":start" => $monthStart, ":end" => $monthEnd])
    ->queryRow();

$yeardebitnote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(exchange_rate * debited_amount ),0) as total")
    ->from("erp_purchasing_debit_note")
    ->where("debited_date  BETWEEN :start AND :end", [":start" => $yearStart, ":end" => $yearEnd])
    ->queryRow();

$lastMonthdebitnote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(exchange_rate * debited_amount ),0) as total")
    ->from("erp_purchasing_debit_note")
    ->where("debited_date  BETWEEN :start AND :end", [":start" => $lastMonthStart, ":end" => $lastMonthEnd])
    ->queryRow();

$lastYeardebitnote = Yii::app()->db->createCommand()
    ->select("COUNT(*) as count, IFNULL(SUM(exchange_rate * debited_amount ),0) as total")
    ->from("erp_purchasing_debit_note")
    ->where("debited_date  BETWEEN :start AND :end", [":start" => $lastYearStart, ":end" => $lastYearEnd])
    ->queryRow();
    ?>




         <div class="card-row">
    <div class="label-box invoices left-bg ">Debit Note</div>
    <div class="stats-box">
        <div class="tdy">
            <span><?php echo ($todaydebitnote['count'] > 0) ?$todaydebitnote['count'] : '-'; ?></span>
            <span class="spn-last"><?php echo ($todaydebitnote['total'] > 0) ? number_format($todaydebitnote['total'], 2) : '-'; ?></span>
        </div>
        <div class="this-wek">
            <span><?php echo ($weekdebitnote['count'] > 0) ?$weekdebitnote['count'] : '-'; ?></span>
            <span class="spn-last"><?php echo ($weekdebitnote['total'] > 0) ? number_format($weekdebitnote['total'], 2) : '-'; ?></span>
        </div>
        <div class="this-month">
            <span><?php echo ( $monthdebitnote['count'] > 0) ? $monthdebitnote['count'] : '-';  ?></span>
            <span class="spn-last"><?php echo ($monthdebitnote['total'] > 0) ? number_format($monthdebitnote['total'], 2) : '-'; ?></span>
        </div>
        <div class="prev-mnth">
            <span><?php echo ( $lastMonthdebitnote['count'] > 0) ? $lastMonthdebitnote['count'] : '-';  ?></span>
            <span class="spn-last"><?php echo ($lastMonthdebitnote['total'] > 0) ? number_format($lastMonthdebitnote['total'], 2) : '-'; ?></span>
        </div>
        <div class="ths-yer">
            <span><?php echo ( $yeardebitnote['count'] > 0) ? $yeardebitnote['count'] : '-';  ?></span>
            <span class="spn-last"><?php echo ($yeardebitnote['total'] > 0) ? number_format($yeardebitnote['total'], 2) : '-'; ?></span>
        </div>
        <div class="prev-yer">
            <span><?php echo ( $lastYeardebitnote['count'] > 0) ? $lastYeardebitnote['count'] : '-';  ?></span>
            <span class="spn-last"><?php echo ($lastYeardebitnote['total'] > 0) ? number_format($lastYeardebitnote['total'], 2) : '-'; ?></span>
        </div>
    </div>
</div>



          <!-- End Panel -->


        </div>