<?php
$cs = Yii::app()->getClientScript();

// Register jQuery UI for autocomplete
// $cs->registerCssFile("//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css");
// $cs->registerScriptFile("//code.jquery.com/ui/1.12.1/jquery-ui.js");

// Autocomplete JS
$cs = Yii::app()->getClientScript();

$cs->registerScript("autoCompleteInvProduct", "
$(function() {
    var url = '" . Yii::app()->createUrl('dashboardmatrix/getProduct') . "'+'&frm=stock';

    $('#inventory_search').autocomplete({
        minLength: 1,
        source: function (request, response) {
            $.ajax({
                url: url,
                dataType: 'json',
                data: { term: request.term },
                success: function(data) {
                    response($.map(data, function(item) {
                        return {
                            label: item.part_number + ' - ' + item.description,
                            value: item.part_number,
                            product_id: item.id
                        };
                    }));
                }
            });
        },
        focus: function(event, ui) {
            $(this).val(ui.item.label);
            return false;
        },
        select: function(event, ui) {
            event.preventDefault();
            $('#inventory_part_no').val(ui.item.value);
            $('#inventory_product_id').val(ui.item.product_id);
            $(this).val(ui.item.label);

            $.ajax({
                url: '" . Yii::app()->createUrl('dashboardmatrix/getStockDetails') . "',
                type: 'GET',
                dataType: 'json',
                data: { product_id: ui.item.product_id },
                success: function(data) {
                    $('#sd-partno').text(data.part_number);
                    $('#sd-description').text(data.description);
                    $('#sd-brand').text(data.brand_name);
                    $('#sd-category').text(data.category_name);
                    $('#sd-qty').text(data.quantity);
                    $('#sd-rate').text(data.rate);
                    $('#sd-value').text(data.value);
                }
            });
        },
        change: function(event, ui) {
            // If the textbox is cleared manually
            if (!this.value) {
                $('#inventory_part_no').val('');
                $('#inventory_product_id').val('');
                $('#sd-partno, #sd-description, #sd-brand, #sd-category, #sd-qty, #sd-rate, #sd-value').text('-');
            }
        }
    });
});
", CClientScript::POS_END);
?>



<style type="text/css">
/* Search Form Styling */
.search-form {
  display: inline-block;
  max-width: 600px;
  width: 100%;
}

.search-group {
  width: 100%;
}

.search-input {
  border-radius: 25px 0 0 25px;
  padding: 10px 15px;
  font-size: 14px;
}

.search-btn {
  border-radius: 0 25px 25px 0;
  padding: 10px 20px;
  font-size: 14px;
}
</style>

<section class="panel">
    <div class="panel-body">
        <div class="text-center">

            <!-- Top Row -->
            <div class="row" style="margin-bottom:20px;">
                <!-- Left Card: Stock Details -->
                <div class="col-sm-4 text-center">
                    <div class="card bg-info" style="height:auto; min-height:120px; border-radius:27px; padding:15px;" id="stock-details-card">
                        <h4>Stock Details</h4>
                        <table class="table table-condensed table-borderless" style="margin-bottom:0;">
                            <tr><td><b>Part No:</b></td><td id="sd-partno">-</td></tr>
                            <tr><td><b>Description:</b></td><td id="sd-description">-</td></tr>
                            <tr><td><b>Brand:</b></td><td id="sd-brand">-</td></tr>
                            <tr><td><b>Category:</b></td><td id="sd-category">-</td></tr>
                            <tr><td><b>Quantity:</b></td><td id="sd-qty">-</td></tr>
                            <tr><td><b>Rate:</b></td><td id="sd-rate">-</td></tr>
                            <tr><td><b>Value:</b></td><td id="sd-value">-</td></tr>
                        </table>
                    </div>
                </div>

                <!-- Middle Card: Placeholder -->
                <div class="col-sm-4">
                    <div class="card bg-info" style="height:120px; border-radius: 27px;"></div>
                </div>

                <!-- Right Card: Placeholder -->
                <div class="col-sm-4">
                    <div class="card bg-info" style="height:120px; border-radius: 27px;"></div>
                </div>
            </div>

            <!-- Search Row -->
            <div class="row" style="margin-bottom:20px;">
                <div class="col-sm-4 text-right">
                    <div class="card bg-info" style="height:120px;border-radius: 27px;"></div>
                </div>

                <!-- Search Bar -->
                <div class="col-sm-4 text-center">
                    <form class="form-inline search-form">
                        <div class="input-group search-group">
                            <input type="text" 
                                   class="form-control search-input" 
                                   id="inventory_search"
                                   placeholder="Search Inventory...">
                            <span class="input-group-btn">
                                <button class="btn btn-primary search-btn" type="button">
                                    <i class="glyphicon glyphicon-search"></i> Search
                                </button>
                            </span>
                        </div>
                        <input type="hidden" id="inventory_part_no" name="part_no">
                        <input type="hidden" id="inventory_product_id" name="product_id">
                    </form>
                </div>

                <div class="col-sm-4 text-left">
                    <div class="card bg-info" style="height:120px;border-radius: 27px;"></div>
                </div>
            </div>

            <!-- Bottom Row -->
            <div class="row">
                <div class="col-sm-4">
                    <div class="card bg-info" style="height:120px;border-radius: 27px;"></div>
                </div>
                <div class="col-sm-4">
                    <div class="card bg-info" style="height:120px;border-radius: 27px;"></div>
                </div>
                <div class="col-sm-4">
                    <div class="card bg-info" style="height:120px;border-radius: 27px;"></div>
                </div>
            </div>

        </div>
    </div>
</section>
