<?php
$location = strtolower($oulet_location);
$sql = "SELECT loc.customer_id, cust.customer_name, COUNT(*) AS qty FROM `erp_customer_outlet_location` loc JOIN `erp_customer` cust ON (cust.id = loc.customer_id) WHERE LOWER(`outlet_location`) = '$location' GROUP BY cust.customer_name";
$dataArray = Yii::app()->db->createCommand($sql)->queryAll();
?>
<div class="row">
    <div class="col-6 col-lg-6 ">
        <h5>Location : <?= ucwords($location); ?></h5>
        <table class="table table-hover table-bordered personal-task dataTable no-footer">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Customer</th>
                    <th class="text-right">Location Count</th>
                </tr>
            </thead>
            <tbody>
                <?php
                foreach ($dataArray as $key => $dataRow) {
                    $condition = "outlet.customer_id =" . $dataRow["customer_id"] . " AND LOWER(outlet.outlet_location) = '" . strtolower($location) . "' ";
                    $count = ServiceCustomerLocation::model()->with('outlet')->count($condition);
                    ?>
                    <tr onclick="loadCustomerLocation('<?= $location ?>', '<?= $dataRow["customer_id"] ?>');">
                        <td>
                            <?php echo ($key + 1) ?>
                        </td>
                        <td>
                            <?php echo $dataRow["customer_name"] ?>
                        </td>
                        <td class="text-right">
                            <?php echo number_format(floatval($count), 0); ?>
                        </td>
                    </tr>
                    <?php
                }
                ?>
            </tbody>
        </table>
    </div>
    <div class="col-6 col-lg-6" id="location-of-customer-div">

    </div>
</div>
<script>
    function loadCustomerLocation(location, customerId) {
        jQuery.ajax({
            dataType: 'HTML',
            type: 'POST',
            url: 'index.php?r=dashboard2/locationofcustomer',
            cache: false,
            data: {
                location: location,
                customerId: customerId
            },
            success: function (data) {
                $("#location-of-customer-div").html(data);
            },
        });
    }
</script>