<?php
$sql = 'SELECT inv.sales_group_id, sales_group.group_name , COUNT(*) as qty,SUM(inv.grand_total*inv.exchange_rate) AS value
         FROM {{invoice}} AS inv
         INNER JOIN {{mas_sales_group}} AS sales_group ON inv.sales_group_id=sales_group.id
         WHERE YEAR(inv.invoice_date) = ' . $year . ' AND MONTH(inv.invoice_date) = ' . $month . '
         GROUP BY sales_group.id';
$graphdata2 = Yii::app()->db->createCommand($sql)->queryAll();
?>
<div class="col-lg-12">

    <table class="table table-hover table-bordered personal-task">
        <thead>
            <tr>
                <th>S.No</th>
                <th>Sales group</th>
                <th class="text-right">Invoice Count</th>
                <th class="text-right">Net Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($graphdata2 as $key => $row) {
                ?>
                <tr onclick="loadMonthYearInvoice(<?= $month ?>,<?= $year ?>,<?= $row["sales_group_id"] ?>)">
                    <td>
                        <?php echo ($key + 1) ?>
                    </td>
                    <td>
                        <?php echo $row["group_name"] ?>
                    </td>
                    <td class="text-right" >
                        <?php echo $row["qty"] ?>
                    </td>
                    <td class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($row["value"], " ") ?>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
</div>
<script>
    function loadMonthYearInvoice(month, year, group_id) {
        jQuery.ajax({
            "type": "post",
            "data": "month=" + month + "&year=" + year + '&group_id=' + group_id,
            "url": $("#liveSite").val() + "index.php?r=dashboard/InvoiceYear",
            "cache": false,
            "success": function (data) {
                $("#loader").hide();
                $("#lead_info").html(data);
            }
        });
    }
</script>
