<table class="table table-hover table-bordered personal-task">
    <thead>
        <tr>
            <th>#</th>
            <th>Sales Group</th>
            <th class="text-right">Count</th>
            <th class="text-right">Amount</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $sql = "SELECT Q.sales_group_id, SG.group_name, COUNT(*) as qty, SUM(grand_total * exchange_rate) AS value FROM {{quotes}} Q "
                . " LEFT JOIN {{mas_sales_group}} AS SG ON (SG.id = Q.sales_group_id ) "
                . " WHERE YEAR(Q.qtn_start_date) = $year  AND MONTH(Q.qtn_start_date) = " . $month
                . " GROUP BY SG.group_name";

        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        $total_amount = 0;
        foreach ($rawData as $key => $row) {
            $total_amount += floatval($row['value']);
            ?>
            <tr onclick="quotesyeardetails('<?= $month ?>', '<?= $year ?>', '<?= $row['sales_group_id'] ?>')">
                <td>
                    <?php echo $key + 1 ?>
                </td>
                <td>
                    <?php echo $row["group_name"] ?>
                </td>
                <td class="text-right">
                    <?php echo $row["qty"] ?>
                </td>
                <td class="text-right">
                    <?= Yii::app()->numberFormatter->formatCurrency($row['value'], ""); ?>
                </td>
            </tr>
            <?php
        }
        ?>
    </tbody>
    <tfoot>
        <tr>
            <th class="text-right" colspan="3">Total</th>
            <th class="text-right" >
                <?= Yii::app()->numberFormatter->formatCurrency($total_amount, ""); ?>
            </th>
        </tr>
    </tfoot>
</table>