
<?php
$color = ColorSettings::model()->find();
$colors = [
    ltrim($color->graph_color_one, '#'),
];
$total_amount = Yii::app()->db->createCommand('SELECT sum(ord.grand_total) FROM {{order}} AS ord
                                                        INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON ord.lead_owner_id=user.id
                                                        WHERE YEAR(ord.order_date)="' . $currentyear . '" AND MONTH(ord.order_date)="' . $currentmonth . '"')->queryScalar();

$graphdata4 = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name) AS lead_ownername,user.id AS leadowner_id FROM {{order}} AS ord
                                                        INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON ord.lead_owner_id=user.id
                                                        WHERE YEAR(ord.order_date)="' . $currentyear . '" AND MONTH(ord.order_date)="' . $currentmonth . '" GROUP BY user.id')->queryAll();
$chartData = '';
$percentage_amount = 0.00;
foreach ($graphdata4 as $eachdata) {
    $total = (int) Yii::app()->db->createCommand('SELECT sum(ord.grand_total) FROM {{order}} AS ord
                                                        INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON ord.lead_owner_id=user.id
                                                        WHERE YEAR(ord.order_date)="' . $currentyear . '" AND MONTH(ord.order_date)="' . $currentmonth . '" AND user.id="' . $eachdata['leadowner_id'] . '"')->queryScalar();
    $percentage_amount = number_format(($total / $total_amount) * 100, 2);

    $chartData .= '{"lead_owner": "' . $eachdata['lead_ownername'] . '","total_amount": "' . $total . '","percentage_amount": "' . $percentage_amount . '","color": "' . $colors[0] . '"},';
}
?>
<div class="col-sm-12">
    <section class="panel">
        <header class="panel-heading">
            Order MTD <?php
            $selected = $currentyear . '-' . $currentmonth;
            echo CHtml::dropDownList('order_month', '', Dashboard::getMonths1($currentyear, 1, 12), array(
                'options' => array($selected => array('selected' => true)),
                "onChange" => "loadOrderMtdGraph(this.value);"));
            ?>
        </header>
        <div class="panel-body">
            <div id="order_mtd_graph"></div>
        </div>
    </section>
</div>
<script type="text/javascript">

//Mileage Chart
    var chart_mileage = AmCharts.makeChart("order_mtd_graph", {
        "theme": "light",
        "type": "serial",
        "dataProvider": [<?php echo $chartData; ?>],
        "valueAxes": [{
                "stackType": "3d",
                "unit": " AED",
                "position": "left",
                "title": "Total in AED",
            }],
        "startDuration": 1,
        "graphs": [{
                "balloonText": "[[total_amount]] ([[percentage_amount]]%)",
                "fillAlphas": 0.9,
                "lineAlpha": 0.2,
                "title": "ThisYear",
                "type": "column",
                "valueField": "total_amount",
//                "fillColorsField": "color"
            }],
        "plotAreaFillAlphas": 0.1,
        "depth3D": 60,
        "angle": 30,
        "categoryField": "lead_owner",
        "categoryAxis": {
            "gridPosition": "start"
        },
        "export": {
            "enabled": true
        },
        "hideCredits": true,
    });
    jQuery('.chart-input').off().on('input change', function () {
        var property = jQuery(this).data('property');
        var target = chart_mileage;
        chart_mileage.startDuration = 0;

        if (property == 'topRadius') {
            target = chart_mileage.graphs[0];
            if (this.value == 0) {
                this.value = undefined;
            }
        }

        target[property] = this.value;
        chart_mileage.validateNow();
    });
</script>
<style>
    #order_mtd_graph {
        width: 100%;
        height: 500px;
    }
</style>
