<?php
$userTableName = User::model()->tableName();
$total_amount = Yii::app()->db->createCommand('SELECT  sum(inv.grand_total) FROM {{invoice}} AS inv
                                                           INNER JOIN {{master_file}} AS filedetail ON inv.file_id=filedetail.id
                                                        INNER JOIN ' . $userTableName . ' AS user ON filedetail.lead_owner_id=user.id
                                                        WHERE YEAR(inv.invoice_date)="' . $currentyear . '" AND MONTH(inv.invoice_date)="' . $currentmonth . '"')->queryScalar();

/* $graphdata4 = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS lead_ownername,user.id AS leadowner_id FROM {{invoice}} AS inv
  INNER JOIN {{master_file}} AS filedetail ON inv.file_id=filedetail.id
  INNER JOIN ' . $userTableName . ' AS user ON filedetail.lead_owner_id=user.id
  WHERE YEAR(inv.invoice_date)="'.$currentyear.'" AND MONTH(inv.invoice_date)="'.$currentmonth.'" GROUP BY user.id')->queryAll(); */

$graphdata4 = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name) AS lead_ownername,user.id AS leadowner_id FROM {{invoice}} AS inv
                                                           INNER JOIN {{master_file}} AS filedetail ON inv.file_id=filedetail.id
                                                        INNER JOIN ' . $userTableName . ' AS user ON filedetail.lead_owner_id=user.id
                                                        WHERE YEAR(inv.invoice_date)="' . $currentyear . '" AND MONTH(inv.invoice_date)="' . $currentmonth . '" GROUP BY user.id')->queryAll();

$percentage_amount = 0.00;
$chartData = '';
foreach ($graphdata4 as $k => $eachdata) {
    $total = Yii::app()->db->createCommand('SELECT  sum(inv.grand_total) FROM {{invoice}} AS inv
                                                           INNER JOIN {{master_file}} AS filedetail ON inv.file_id=filedetail.id
                                                        INNER JOIN ' . $userTableName . ' AS user ON filedetail.lead_owner_id=user.id
                                                        WHERE YEAR(inv.invoice_date)="' . $currentyear . '" AND MONTH(inv.invoice_date)="' . $currentmonth . '" AND user.id="' . $eachdata['leadowner_id'] . '"')->queryScalar();
    $percentage_amount = number_format(($total / $total_amount) * 100, 2);
    $chartData .= '{"lead_owner": "' . $eachdata['lead_ownername'] . '","total_amount": "' . (int) $total . '","percentage_amount": "' . $percentage_amount . '"},';
}
?>
<div class="col-sm-12">
    <section class="panel">
        <header class="panel-heading">
            Invoice MTD <?php
            $selected = $currentyear . '-' . $currentmonth;
            echo CHtml::dropDownList('invoice_month', '', Dashboard::getMonths1($currentyear, 1, 12), array(
                'options' => array($selected => array('selected' => true)),
                "onChange" => "loadInvoicesMtdGraph(this.value);"));
            ?>
        </header>
        <div class="panel-body">
            <div id="invoice_mtd_graph"></div>
        </div>
    </section>
</div>
<script type="text/javascript">

//Mileage Chart
    var chart_mileage = AmCharts.makeChart("invoice_mtd_graph", {
        "theme": "light",
        "type": "serial",
        "dataProvider": [<?php echo $chartData; ?>],
        "valueAxes": [{
                "stackType": "3d",
                "unit": " AED",
                "position": "left",
                "title": "Total in AED",
            }],
        "startDuration": 1,
        "graphs": [{
                "balloonText": "[[total_amount]] ([[percentage_amount]]%)",
                "fillAlphas": 0.9,
                "lineAlpha": 0.2,
                "title": "ThisYear",
                "type": "column",
                "valueField": "total_amount"
            }/*, {
             "balloonText": "Fuel Expense [[category]] Last Year: <b>[[value]]</b>",
             "fillAlphas": 0.9,
             "lineAlpha": 0.2,
             "title": "LastYear",
             "type": "column",
             "valueField": "last_year"
             }*/],
        "plotAreaFillAlphas": 0.1,
        "depth3D": 60,
        "angle": 30,
        "categoryField": "lead_owner",
        "categoryAxis": {
            "gridPosition": "start"
        },
        "export": {
            "enabled": true
        },
        "hideCredits": true,
    });
    jQuery('.chart-input').off().on('input change', function () {
        var property = jQuery(this).data('property');
        var target = chart_mileage;
        chart_mileage.startDuration = 0;

        if (property == 'topRadius') {
            target = chart_mileage.graphs[0];
            if (this.value == 0) {
                this.value = undefined;
            }
        }

        target[property] = this.value;
        chart_mileage.validateNow();
    });




</script>
<style>
    #invoice_mtd_graph {
        width: 100%;
        height: 500px;
    }
</style>
