<?php
$sql = "SELECT YEAR(invoice_date) as 'y', sum(`grand_total`) as 'total', count(*) as freq  FROM `erp_invoice` WHERE erp_invoice.customer_id = " . $id . " group by YEAR(invoice_date)";
$sql_all = "SELECT YEAR(invoice_date) as 'y', sum(`grand_total`)  as 'total' FROM `erp_invoice` group by YEAR(invoice_date)";
$data = Yii::app()->db->createCommand($sql)->queryAll();
$data_all = Yii::app()->db->createCommand($sql_all)->queryAll();
$year_list = [];
foreach ($data as $value) {
    $year_list[$value['y']]['customer'] = $value['total'];
    $year_list[$value['y']]['freq'] = $value['freq'];
}
foreach ($data_all as $value) {
    $year_list[$value['y']]['all'] = $value['total'];
}
?>


<div class="col-md-6">
    <table class="table">
        <thead>
            <tr>
                <th>#</th>
                <th>Year</th>
                <th class="text-right">Count</th>
                <th class="text-right">Customer Sales</th>
                <th class="text-right">Percentage</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 0;
            foreach ($year_list as $key => $value) {
                $i++;
                if (!isset($value['customer'])) {
                    $value['customer'] = 0;
                    $value['freq'] = 0;
                }
                $perc = ((float) $value['customer'] * 100) / ((float) $value['all']);
                ?>
                <tr>
                    <td><?= $i ?></td>
                    <td><?= $key ?></td>
                    <td class="text-right"><?= $value['freq'] ?></td>
                    <td  class="text-right"><?= number_format($value['customer'], 2) ?></td>
                    <td  class="text-right"><?= number_format($perc, 2) ?>%</td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</div>

<div class="col-md-6">

    <div id="general_info_graph" >
        
    </div>
</div>
<script>
    $(document).ready(function () {
        $.ajax({
            url: "index.php?r=customerinfo/info",
            type: 'POST',
            data: {
                id: '<?= $id ?>'
            },
            dataType: 'html',
            beforeSend: function (xhr) {

            },
            success: function (data, textStatus, jqXHR) {
                $("#general_info_graph").html(data);
            }
        });
    });
</script>


