<?php
$currentYear = date('Y');
$currentMonth = date('m');

$totalCustomers = Customer::model()->count();
$activeCustomers = Customer::model()->count('isActive = "Y"');
$inactiveCustomers = Customer::model()->count('isActive = "N"');
$addedThisYear = Customer::model()->count('YEAR(created_date_time) = :year', array(':year' => $currentYear));
$addedThisMonth = Customer::model()->count('YEAR(created_date_time) = :year AND MONTH(created_date_time) = :month', array(':year' => $currentYear, ':month' => $currentMonth));
if (!isset(Yii::app()->user->havePermissionOn["view_all_customer_activity"]) && Yii::app()->user->authorised_user != 1) {
    $userId = Yii::app()->user->id;

    $criteriaBase = 'FIND_IN_SET(:owner, t.lead_owner_id)';

    $totalCustomers = Customer::model()->count($criteriaBase, array(':owner' => $userId));

    $activeCustomers = Customer::model()->count(
        $criteriaBase . ' AND isActive = "Y"',
        array(':owner' => $userId)
    );

    $inactiveCustomers = Customer::model()->count(
        $criteriaBase . ' AND isActive = "N"',
        array(':owner' => $userId)
    );

    $addedThisYear = Customer::model()->count(
        $criteriaBase . ' AND YEAR(created_date_time) = :year',
        array(':owner' => $userId, ':year' => $currentYear)
    );

    $addedThisMonth = Customer::model()->count(
        $criteriaBase . ' AND YEAR(created_date_time) = :year AND MONTH(created_date_time) = :month',
        array(':owner' => $userId, ':year' => $currentYear, ':month' => $currentMonth)
    );
}

?>

<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
    .stats-inline li {
        margin-right: 12px;
        display: inline-block;
    }

    .icon-plus {
        width: 20px;
        height: 20px;
        color: white;
    }
</style>

<script>
    $(document).ready(function () {
        // Pass permissions from PHP to JS
        const permissions = {
            edit: <?php echo (isset(Yii::app()->user->havePermissionOn['customer_edit']) || Yii::app()->user->authorised_user == 1) ? 'true' : 'false'; ?>,
            view: <?php echo (isset(Yii::app()->user->havePermissionOn['customer_view']) || Yii::app()->user->authorised_user == 1) ? 'true' : 'false'; ?>,
            activity: <?php echo (isset(Yii::app()->user->havePermissionOn['customer_activity']) || Yii::app()->user->authorised_user == 1) ? 'true' : 'false'; ?>
        };

        const activeCustomers = <?php echo $activeCustomers; ?>;
        const inactiveCustomers = <?php echo $inactiveCustomers; ?>;

        var table = $("#tbl_customer_details").DataTable({
            scrollY: "645px",
            bAutoWidth: true,
            pageLength: 100,
            columns: [{}, {}, {}, {}, {}, {}, {}, {}, {} ,  {}],
            order: [[1, "asc"]],
            aoColumnDefs: [
                { bSortable: false, aTargets: [9, 7, 8] },
                { targets: [10, 7, 8, 9], visible: false },
            ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('customer/getcustomerlist'); ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            fnCreatedRow: function (nRow) {
                $(nRow).addClass("context-menu");
            },
            fnRowCallback: function (nRow, aData) {
                if (aData[9] == "N") $("td", nRow).addClass("bg-danger");
                else if (aData[10] == "B") $("td", nRow).css("background-color", "#E88D67");
                else if (aData[10] == "D") $("td", nRow).css("background-color", "#BB999C");
                if (aData[10] == "Y") $("td", nRow).css("background-color", "#ffe6ff");
                if (aData[12] == "1") $("td", nRow).css("background-color", "#ffcfcf");
            }
        });

        // Context menu with permission checks
        $('#tbl_customer_details tbody').on('click', 'tr', function () {
            var data = table.row(this).data();
            var id = data[0], customer_name = data[1], own_flag = data[11];

            $.contextMenu('destroy');
            $.contextMenu({
                selector: ".context-menu",
                callback: function (key) {
                    if (key === "edit" && permissions.edit) {
                        loadPopupModal("customer/create&id=" + id, "Edit Customer - " + id + " | " + customer_name, "xl");
                    }
                    else if (key === "activity" && permissions.edit) {
                        loadPopupModal("activity/activity/history&frm=CU&customer_id=" + id + '&header_id=' + id, "Customer", "xl");
                    }
                    else if (key === "info" && permissions.view) {
                        loadPopupModal("customer/info&frm=C&customer_id=" + id, customer_name, "xl");
                    }
                    else if (key === "view" && permissions.view) {
                        loadPopupModal("customer/create&id=" + id + "&type=view", "View Customer - " + customer_name, "xl");
                    }
                    else if (key === "soa" && permissions.edit) {
                        window.open($('#liveSite').val() + "/index.php?r=finance/reports/statement_sales_pdf&customer_id=" + id + "&layout=1&ledger_id=11&type=customer", "_blank");
                    }
                },
                items: {
                    "edit": { name: "Edit", icon: "edit", visible: permissions.edit },
                    "view": { name: "View", icon: "fa-eye", visible: permissions.view },
                    "activity": { name: "Activity", icon: "fa-certificate", visible: permissions.activity },
                    "info": { name: "Info", icon: "fa-info", visible: false }
                }
            });
        });

        $(".dataTables_scrollFoot").hide();
    });
</script>


<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <div class="row" style="align-items: center;">
            <div class="col-sm-2"><span>Customers</span></div>

            <div class="col-sm-10 text-right" style="display: flex; align-items: center; justify-content: flex-end;">
                <!-- <canvas id="smallBarChart" width="15" height="42" style="margin-left: 10px; cursor: pointer;" onclick="showDetailedBar()"></canvas> -->

                <ul class="list-inline stats-inline" style="margin: 0; font-size: 13px; display: inline-block;">
                    <li>Total: <?php echo $totalCustomers; ?></li>
                    <li>Active: <?php echo $activeCustomers; ?></li>
                    <li>Inactive: <?php echo $inactiveCustomers; ?></li>
                    <li>This Year: <?php echo $addedThisYear; ?></li>
                    <li>This Month: <?php echo $addedThisMonth; ?></li>
                </ul>

                <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_add"])) { ?>
                    <a class="ad-btn" id="add_popup" onclick="loadPopupModal('customer/create', 'Add New Customer', 'xl')"
                        title="Add">
                        <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                            class="pluss-ad">
                            <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                            <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                            <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        </svg>
                    </a>
                <?php } ?>
            </div>
        </div>
    </header>

    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_customer_details"
                style="font-size:13px;">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Customer</th>
                        <th>Location</th>
                        <th>Old A/c No</th>
                        <th>Phone#</th>
                        <th>TRN#</th>
                        <th>Payment Method</th>
                        <th>Last Order Date</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>

<!-- Modal for Bar Chart -->
<!-- <div class="modal fade" id="customerBarModal" tabindex="-1" role="dialog" aria-labelledby="barModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered" role="document">
    <div class="modal-content" style="border-radius: 8px;">
      <div class="modal-header" style="padding: 8px; background-color: #f8f9fa; border-bottom: 1px solid #dee2e6;display: flex">
        <h5 class="modal-title mb-0" style="font-size: 16px; width: 99%">Customer Breakdown</h5>
        <button type="button" class="X close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body text-center" style="padding: 20px;">
        <canvas id="detailedBarChart" width="400" height="300" style="max-width: 100%;"></canvas>
      </div>
    </div>
  </div>
</div> -->