<script>
    $(document).ready(function () {
        var table_id = "#tbl_customer_contact_details";
        var cust_id = $("#hid_cust_id").val();

        var table = $(table_id).DataTable({
            scrollY: "250px",
            paging: false,
            processing: true,
            serverSide: true,
            fixedColumns: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('customer/getcontactlist'); ?>",
                type: "POST",
                cache: false,
                data: {
                    "customer_id": cust_id
                }
            },
            rowCallback: function (row, data) {
                if (data[7] === "N") {
                    $("td", row).css("background-color", "red");
                }
                AddContactContextMenu(row, data);
            },
            columnDefs: [
                { "orderable": false, "targets": [0, 1, 2, 3, 4] }
            ]
        });

        // Hide DataTables footer scroll
        $(".dataTables_scrollFoot").hide();

        function AddContactContextMenu(row, data) {
            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_edit"])) { ?>
                $(row).contextMenu({
                    selector: "td",
                    items: {
                        "edit": {
                            name: "Edit",
                            icon: "edit",
                            callback: function () {
                                var contactId = data[7];
                                var title = "Edit Contact";
                                loadPopupModal("customer/customercontactcreate&id=" + contactId, title, "lg");
                            }
                        }
                    }
                });
            <?php } ?>
        }

    });
</script>



<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        Contacts
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_edit"]) || ((int) Yii::app()->user->havePermissionOn["customer_add"])) { ?>
            <div class="pull-right">
                <button class="btn btn-sm btn-theme"
                    onclick="loadPopupModal('customer/customercontactcreate&c_id=<?php echo $c_id; ?>','Add New Contact','lg');"
                    title="Add Contacts"><i class="fa fa-plus"></i></button>
            </div>
        <?php } ?>
    </header>
</section>
<div class="clearfix"></div>
<table class="table table-hover table-bordered personal-task" id="tbl_customer_contact_details">
    <thead>
        <tr>
            <th>Full Name</th>
            <th>Designation</th>
            <th>Phone No</th>
            <th>Mobile No</th>
            <th>Email</th>
            <th>Status</th>
            <?//} ?>
        </tr>
    </thead>

    <tfoot>
        <tr>
            <th>Full Name</th>
            <th>Designation</th>
            <th>Phone No</th>
            <th>Mobile No</th>
            <th>Email</th>
            <th>Status</th>
            <!-- <th>Actions</th> -->
        </tr>
    </tfoot>

</table>