<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("disableCurrency", "function disableCurrency(id){
    var r = confirm('Are you sure to disable/enable this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=currency/disableCurrency',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                    reloadTable('#tbl_currency_details');
                    t8.success('Currency Disabled/Enabled SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
?>

<script>
    $(document).ready(function () {
        var table_id = "#tbl_currency_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('currency/GetCurrencyList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                // console.log (aData);
                if (aData[4] == "Y") {
                    $("td", nRow).addClass("bg-payment");

                } else {
                    $("td", nRow).addClass("bg-test");
                }
                if (aData[6].isActive == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
                AddContextMenu(nRow, aData);
            }
        });
    });
    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;

        <?php if (isset(Yii::app()->user->havePermissionOn['currency_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_edit = 1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['currency_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_disable = 1;
        <?php } ?>

        // Build menu items dynamically
        var menuItems = {};

        <?php if (isset(Yii::app()->user->havePermissionOn['currency_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.edit = {
                name: "Edit",
                icon: "edit",
                accesskey: "e",
                callback: function () {
                    loadPopupModal("currency/create&id=" + datas[6].id, datas[6].code, "lg");
                }
            };
        <?php } ?>

        <?php if (isset(Yii::app()->user->havePermissionOn['currency_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.disable = {
                name: "Enable/Disable",
                icon: "fa-trash",
                accesskey: "e",
                callback: function () {
                    disableCurrency(datas[6].id);
                },
                disabled: function (key, opt) {
                    // disable when already enabled (Y)
                    if (String(datas[4]).trim().toUpperCase() === 'Y') {
                        return true;
                    }
                    return false;
                }
            };
        <?php } ?>

        // Attach menu only if at least one item exists
        if (Object.keys(menuItems).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: menuItems
            });
        }
    }

</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-users"></i> -->
        Currencies
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['currency_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <a class="ad-btn" onclick="loadPopupModal('currency/create','Add New Currency','lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                        class="pluss-ad">
                        <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                        <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                    </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_currency_details">
                <thead>
                    <tr>
                        <th>SI No</th>
                        <th>Currency</th>
                        <th>Currency Code</th>
                        <th>Exchange Rate</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>