<?php
$prefix = ($frm == 3) ? 'service_credit' : 'credit';
$prefix_return = ($frm == 3) ? 'service_return' : 'return';

$cs = Yii::app()->getClientScript();


$cs->registerScript("creditnoteposted", "function creditnoteposted(cn_id) {
    jConfirm('Confirm Posting  of Credit Note- '+cn_id+' ?', 'Confirmation Dialog', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    'data' :{'id':cn_id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/Posting/PostCreditnote') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Sales Return Posted!');  
                            reloadTable('#tble_tble_credit'); 
                        }else{
                            $.each(data, function(key, val) { 
                                t8.error(val); 
                            }); 
                        }
                    }, 
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }
        }); 
};", CClientScript::POS_HEAD);


?>
<script>
    $(document).ready(function () {
        loadCreditNoteList();
        loadCheckinList();
    });


    function loadCreditNoteList() {
        var table_id = "#tble_tble_credit";

        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            data.warehouse_id = $("#warehouse_id").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            columns: [{
                className: "nw sl col-max-1"
            },
            {
                className: "nw sl col-max-4"
            },
            {
                className: "nw sl col-max-3"
            },
            {
                className: "nw sl col-max-6"
            },
            {
                className: "nw sl col-max-1"
            },
            {
                className: "nw sl col-max-1"
            },
            {
                className: "nw sl col-max-3 text-right"
            },
            {
                className: "nw sl col-max-3 text-right"
            },
            {
                className: "nw sl col-max-1 text-right"
            },
            {
                className: "nw sl col-max-1"
            },
            {
                className: "nw sl col-max-1"
            },
            {
                className: "nw sl col-max-3"
            },
            {
                className: "nw sl col-max-3"
            },
            ],
            "columnDefs": [{
                "targets": [9, 10, 11, 13],
                "visible": false,
            },],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('creditnote/GetCreditNoteList') ?>",
                data: {
                    "frm": <?php echo $frm; ?>
                },
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            }
        });
        $('#tble_tble_credit tbody').on('mouseover', 'tr', function () {
            $.contextMenu('destroy');
        });
        $('#tble_tble_credit tbody').on('click', 'tr', function () {
            var data = table.row(this).data();
            var posted = data[11];
            $.contextMenu({
                selector: '.context-menu',
                callback: function (key, options) {
                    var action_id = key;
                    var id = data[0];
                    var file_id = data[1];
                    var customer_id = data[13];
                    var customer_name = data[3];
                    var check_hire = data[10];
                    if (action_id == "print") {
                        window.open($('#liveSite').val() + "/index.php?r=creditnote/printfile&file=" + file_id + "&id=" + id, "_blank")
                    }
                    if (action_id == "activity") {
                        loadPopupModal("activity/activity/history&file_id=" + file_id + "&customer_id=" + customer_id + "&id=" + id + "&header_id=" + id + "&frm=CN", "Credit Note", "xl");
                    }

                },
                items: {

                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_pdf"])) { ?> 
                                    "print": {
                            name: "Print",
                            icon: "fa-print"
                        },
                    <?php }
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix_return}_activity"])) { ?>
                            "activity": {
                            name: "Activity",
                            icon: "fa-certificate"
                        },
                    <?php }
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_post_to_finance"])) { ?> "post": {
                            name: "Post to Finance",
                            icon: "fa-arrow-right",

                            accesskey: "d",
                            callback: function () {
                                creditnoteposted(data[0]);
                                // posted(aData[10]);
                            },
                            disabled: function (key, opt) {
                                if (posted == 'Y') {
                                    return !this.data('postDisabled');
                                }
                            }
                        },
                    <?php } ?>
                }
            });
        });
    }
</script>



<!-- <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li id="li_sales_credit_note_index_1" class="active"><a href="#sales_credit_note_index_1" data-toggle="tab"><i class="fa fa-money"></i>
            <?php
            $theme_class = '';
            if ($_GET['frm'] == 1) {
                $theme_class = 'panel-theame-new';
                ?>
                Hiring Return
            <?php
            } else {
                $theme_class = 'panel-theame';
                ?>
                Sales Return
            <?php } ?>
        </a></li>
    <li onclick="reloadTable('#tble_tble_check_in');" id="li_sales_credit_note_index_2"><a href="#sales_credit_note_index_2" data-toggle="tab"> <i class="fa fa fa-area-chart"></i> Check In</a></li>
</ul> -->
<div class="tab-content">
    <div class="tab-pane active" id="sales_credit_note_index_1">
        <section class="panel" style="background-color:#F6F3EE;">
            <header class="panel-heading clearfix <?php echo $theme_class; ?>">Sales Returns
                <?php
                /*
            <div class="col-sm-2 pull-right">

                <?php
                /*if (Yii::app()->user->authorised_user  != 1) {
                    $barray = array('class' => 'form-control', 'data-label' => 'Warehouse', 'onChange' => 'reloadTable("#tble_tble_credit")');
                } else {
                    $barray = array('class' => 'form-control', 'data-label' => 'Warehouse', 'prompt' => 'All Warehouse', 'onChange' => 'reloadTable("#tble_tble_credit")');
                }
                echo CHtml::dropdownlist('warehouse_id', '', MasInventoryWarehouse::getUserWarehousees(), $barray);


            </div>*/


                ?>

                <div class="pull-right">
                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_add"])) { ?>
                        <a class="ad-btn" id="add_popup"
                            onclick="loadPopupModal('creditnote/create', 'Add New Sales Return', 'xl')" title="Add">
                            <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                                class="pluss-ad">
                                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2"
                                    stroke-linecap="round" />
                                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2"
                                    stroke-linecap="round" />
                            </svg>
                        </a>
                    <?php } ?>

                </div>




            </header>
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task" id="tble_tble_credit"
                        style="font-size:13px;">
                        <thead>
                            <tr>
                                <?php if ($_GET['frm'] == 1) { ?>
                                    <th>Return ID #</th>
                                    <th>File#</th>
                                    <th>Invoice No</th>
                                    <th>Customer</th>
                                    <th>Return Date</th>
                                    <th>Currency</th>
                                    <th>Invoice Amount</th>
                                    <th>VAT</th>
                                    <th>Amount</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th>Created By</th>
                                <?php } else { ?>
                                    <th>Return ID#</th>
                                    <th>File#</th>
                                    <th>Invoice No</th>
                                    <th>Customer</th>
                                    <th>Return Date</th>
                                    <th>Currency</th>
                                    <th>Invoice Amount</th>
                                    <th>VAT</th>
                                    <th>Credit Amount</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th>Created By</th>
                                <?php } ?>
                            </tr>
                        </thead>
                    </table>

                </div>
            </div>
        </section>
    </div>
    <div class="tab-pane" id="sales_credit_note_index_2">
        <?php $this->renderPartial("//checkin/index", array('frm' => 'CN', 'hire' => $frm)); ?>
    </div>
</div>