<style type="text/css"> .align-right{text-align:right;max-width:80px} </style>
<script>
    $(document).ready(function () {
        getList({'type': 'datatable', 'value':null}, function(){

        });

        function getList(obj, callback){
                var table_id = "#tbl_audit_log";
                var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                if (obj.type == 'load'){
                    data.performed_by = obj.performed_by;
                    data.from = obj.from;
                    data.to = obj.to;
                    data.fun = obj.fun;
                } 
            }).on('processing.dt', function ( e, settings, processing ) {
            if ( processing == true ){
                $("#loader").show();
            }else{
                $("#loader").hide();
            }
        }).DataTable({
                order:  [[ 0, "desc" ]],
                scrollY: "645px",
                pageLength: 50,
                processing: true,
                ajax: {
                    url: "<?php echo Yii::app()->createUrl('log/GetAuditLogs') ?>",
                    type: "POST",
                    cache: false,
                },
                serverSide: true,
                fixedColumns: true,
                processing: true,
                "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).addClass("context-menu");
                },
                "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                    AddContextMenu(nRow, aData);
                }

            });
            callback();
        }

        function  AddContextMenu(nRow, aData){

        }
    
        $("#user_name").autocomplete({
            source: function( request, response ) {
            $("#loader").show();
            $.ajax( {
                        url: '<?php echo Yii::app()->createUrl('log/GetUserInLog') ?>',
                        dataType: "JSON",
                        data: {
                                term: request.term
                        },
                        success: function( data ) {
                            $("#loader").hide();
                            response( data );
                        }
            });
            },
            minLength: 1,
            select: function( event, ui ) {
                $("#user_name_hidden").val(ui.item.id);
            }
        });

        $("#user_name").keyup(function(){
            if ($("#user_name").val() == ''){
                $("#user_name_hidden").val('');
            }
        });

        $("#load").click(function(){
            var dataobj = {
                                'type': 'load',
                                'fun': 'audit_filter',
                                'from': $("#from_date").val(),
                                'to': $("#to_date").val(),
                                'performed_by': $("#user_name_hidden").val()
                            };
            $('#tbl_audit_log').DataTable().destroy();
            getList(dataobj, function(){
                <?php
                    $from = new DateTime();
                    $to = new DateTime();
                    $from->modify("first day of previous month"); 
                    $to->modify("+1 day");   
                ?>
                if ($("#from_date").val() == ''){
                    var from = '<?php echo $from->format("d/m/Y") ?>'
                }else{
                    var from = ("#from_date").val();
                }

                if ($("#to_date").val() == ''){
                    var to = '<?php echo $to->format("d/m/Y") ?>'
                }else{
                    var to = $("#to_date").val();
                }
                
                $("#from_date").val(from);
                $("#to_date").val(to);
            });
        })
        
    });
</script>

    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-stack-exchange"></i> Audit Logs
            <div class="top_controls_select col-sm-8 pull-right">
                <div class="col-md-2 pull-right">
                    <button class="btn btn-sm btn-theme" id="load">LOAD</button>
                </div>
                <div class="col-md-4 pull-right">
                    <input type='text' id="user_name" class="form-control " placeholder='Type to select a user' />
                </div>
                <div class="col-md-3 pull-right">
                    <input type='text' id="to_date" class="form-control datepicker" placeholder='Select To Date' />
                </div>
                <div class="col-md-3 pull-right">
                    <input type='text' id="from_date" class="form-control datepicker" placeholder='Select From Date' />
                </div>
                <input type='hidden' id="user_name_hidden" value='' />
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_audit_log" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>Log ID</th>
                            <th>Functionality</th>
                            <th>Performed By</th>
                            <th>Changes</th>
                            <th>Performed At</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>

<script type='text/javascript'>
  
</script>




