<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadPercentage", '
    function filterDataTable(employee_id) {
        var table_id ="#tbl_brandsalary_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('brandsalary/GetList') . '",
                type: "POST",
				"data" : {
                    "employee_id" : employee_id,             
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	
        var employee_id       = $("#employee_id").val();	
        filterDataTable(employee_id);
    })
	
	', CClientScript::POS_HEAD);
	
    $cs->registerScript("percentagedetails",  "function percentagedetails(){  
        $('#tbl_brandsalary_details').DataTable().destroy();
        var employee_id       = $('#employee_id').val();
        filterDataTable(employee_id);
   
    };", CClientScript::POS_HEAD); 
    $cs->registerScript("deletepercent", "function deletepercent(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {	
            jQuery.ajax({
                'type'      : 'post',
                'data'      : 'id=' + id,
                'dataType'  : 'json',  
                'url'       : $('#liveSite').val()+'index.php?r=brandsalary/deletepercent',
                'cache'     : false,
                'success'   :function(data){
                    if(data.status=='success'){
                        t8.success('Deleted SuccessFully!');
                        reloadTable('#tbl_brandsalary_details');
                    }else {
                        t8.error('Error while Delete');
                    }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-percent"></i> Salary Percent
            <div class="pull-right">
            <?php echo CHtml::dropDownList("employee_id",'',Employee::getEmployee(), array( 'empty' => 'All Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'class'=>'col-sm-3 form-control_1','onchange'=>'percentagedetails();')); ?>  
           			
                <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_brandsalary_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('brandsalary/create','Add Salary Percentage','lg')"><i class="fa fa-plus"></i> ADD</button> 
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_brandsalary_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Salary %</th>  
                            <th>Actions</th>                                                    
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
