  <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'brand_salary-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
    ?>
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="brandsalary_item_table">
        <tr>
            <th>No</th> 
            <th>Employee Name</th>
            <th>Cost Centre</th>
            <th>%</th>
            <th class="text-center">
                <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#brandsalary_item_table'));"><i class="fa fa-plus"></i></a></th>
        </tr>
        <?php           
            foreach ($model as $i => $detail):                  
        ?>
        <tr>
            <td><label><?php echo ($i+1); ?></label></td> 
            <td>
                <?php echo CHtml::activeHiddenField($detail, "[" . $i . "]id"); ?>
                <?php  echo CHtml::activedropDownList($detail, "[" . $i . "]employee_id",EmployeeBrandSalaryPercent::getEmployeeName(), array('class'=>'tooltipster go','title' => 'Employee Name','empty'=>'Select','onchange'=>'checkbrandexist(this.id);')); ?>                           
            </td>                  
            <td>
                <?php  echo CHtml::activedropDownList($detail, "[" . $i . "]brand_id",MasSalesGroup::getSalesGroups(), array('class'=>'tooltipster go','title' => 'Brand','empty'=>'Select','onchange'=>'checkbrandexist(this.id);')); ?>                           
            </td>
           <td>
                <?php  echo CHtml::activeTextField($detail, "[" . $i . "]salary_percent", array('class'=>'go', 'placeholder' => '%', 'title' => '%','onkeypress' => 'return isNumberKey(event)','onkeyup' => 'checkpercentage(this.id);')); ?>                           
            </td>
            <td class="text-center nw" width="1%">
               <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','id'=>$i,'onclick' => 'removeTableRow($(\'#brandsalary_item_table\'),this)
                                   ', 'title' => 'Remove this item')); ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>

<div class="modal-footer">

    <button type="button" class="btn btn-danger" id="brand_close_1" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" onclick="savebrandsalary()">Save</button>
</div>
<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript('checkbrandexist', 'function checkbrandexist(field_id) { 
    var arr_fields= field_id.split("_");
    var row_field=arr_fields[1];
    var employee_id=$("#EmployeeBrandSalaryPercent_"+row_field+"_employee_id").val(); 
    var brand_id=$("#EmployeeBrandSalaryPercent_"+row_field+"_brand_id").val(); 
    var table_length=$("#brandsalary_item_table").find("tr:gt(0)").length;  
    for(i=0;i<table_length;i++){
        var emp_id = $("#EmployeeBrandSalaryPercent_"+i+"_employee_id").val();
        var brand = $("#EmployeeBrandSalaryPercent_"+i+"_brand_id").val();
        if(employee_id==emp_id && brand_id==brand && row_field!=i){
            t8.error("Duplicate Cost Centre in row "+parseInt(i+1));
            $("#EmployeeBrandSalaryPercent_"+row_field+"_brand_id").val("");
            $("#EmployeeBrandSalaryPercent_"+row_field+"_salary_percent").val("");
        }
    }
};', CClientScript::POS_HEAD);
$cs->registerScript('checkpercentage', 'function checkpercentage(field_id) { 
    var arr_fields= field_id.split("_");
    var row_field=arr_fields[1];
    var employee_id=$("#EmployeeBrandSalaryPercent_"+row_field+"_employee_id").val();
    var table_length=$("#brandsalary_item_table").find("tr:gt(0)").length;  
    var total=0.00;
    for(i=0;i<table_length;i++){
        var emp_id = $("#EmployeeBrandSalaryPercent_"+i+"_employee_id").val();
        var salary_percent = $("#EmployeeBrandSalaryPercent_"+i+"_salary_percent").val();
        if(employee_id==emp_id){
            if(parseFloat(salary_percent)>0){
                total+=parseFloat(salary_percent);
            }
        }
    }
    if(Number(total)>100){
        t8.error("Total Percentage cannot be greater than 100");
        $("#EmployeeBrandSalaryPercent_"+row_field+"_salary_percent").val("");
    }
};', CClientScript::POS_HEAD);
$cs->registerScript("savebrandsalary", "function savebrandsalary() {
   jQuery.ajax({
      'dataType':'json',
      'data' : $('#brand_salary-form').serialize(),
      'type':'post',
      'url': '" . Yii::app()->createUrl('brandsalary/SaveSalaryPercent') . "',
      'cache': false,
      'success': function(data) {
            if(data.status=='success'){
                t8.success('Saved Successfully!');
                $('#brand_close_1').click();
                reloadTable('#tbl_brandsalary_details');
            }
            else{
                $.each(data, function(key, val) {
                    t8.error(''+val+'');
                });
            }

        },
        'beforeSend':function(){
            $('.toast8-error').hide(); 
            var table_length=$('#brandsalary_item_table').find('tr:gt(0)').length;  
            var employee_array = [];
            for(i=0;i<table_length;i++){
                var emp_id = $('#EmployeeBrandSalaryPercent_'+i+'_employee_id').val();
                employee_array.push(emp_id);
            }
            var unique_emp = employee_array.filter(onlyUnique);
            for(i=0;i<unique_emp.length;i++){
                var master_id=unique_emp[i];
                var total=0.00;
                for(j=0;j<table_length;j++){
                    var emp_id = $('#EmployeeBrandSalaryPercent_'+j+'_employee_id').val();
                    var salary_percent = $('#EmployeeBrandSalaryPercent_'+j+'_salary_percent').val();
                    if(master_id==emp_id){
                        if(parseFloat(salary_percent)>0){
                            total+=parseFloat(salary_percent);
                        }
                    }
                }
                if(Number(total)<100){
                    t8.error('Total Percentage cannot be less than 100');
                    return false;
                }

            }
            $('#loader').show();                                                                
        },
        'complete':function(){
            $('#loader').hide();                                                                
        }
    });
};", CClientScript::POS_HEAD);
?>
<script>
    function onlyUnique(value, index, self) { 
    return self.indexOf(value) === index;
}
</script>









