<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("DisablePaymentterm", "function Disable(id){
    var r = confirm('Are you sure to enable/disable this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=bin/Disable',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Disable');
                }else {
                      reloadTable('#tbl_bin_details');
                    t8.success('Bin Disabled/Enabled SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

/*$cs->registerScript("loadBin", '
        $(document).ready(function() {

        var table_id ="#tbl_bin_details";
        var table = $(table_id).DataTable({
         "columnDefs": [ { 
                                "targets": [4],  
                                  "visible": false,
                                   }  ], 
          "rowCallback": function ( row, data ) {
                           if ( data[4] == "Y" )  {  
                                $("td", row).addClass("bg-payment");

                              }else{
                                  $("td", row).addClass("bg-test");
                              }    
                  },            
            scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('bin/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);*/
?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_bin_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            data.warehouse_type = $("#warehouse_id").val();
            data.rack_type = $("#rack_id").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('bin/GetList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                //console.log(aData);
                if (aData[4] == "Y") {
                    $("td", nRow).addClass("bg-payment");

                } else {
                    $("td", nRow).addClass("bg-test");
                }
                if (aData[4].status == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
                AddContextMenu(nRow, aData);
            }
        });


        $("#warehouse_id, #rack_id").change(function () {
            table.ajax.reload(); // This will reload the DataTable with updated filter values
        });
    });
    function AddContextMenu(row, datas) {
        var items = {};

        <?php if (isset(Yii::app()->user->havePermissionOn['mas_inv_bin_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            items["edit"] = {
                name: "Edit",
                icon: "edit",
                accesskey: "e",
                callback: function () {
                    loadPopupModal("bin/create&id=" + datas[5].id, datas[1].code, "lg");
                }
            };
        <?php } ?>

        <?php if (isset(Yii::app()->user->havePermissionOn['mas_inv_bin_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            if (String(datas[4]).trim().toUpperCase() !== 'Y') { // optional condition
                items["Disable_Enable"] = {
                    name: (datas[5].status == "Y") ? "Disable" : "Enable",
                    icon: "edit",
                    accesskey: "d",
                    callback: function () {
                        Disable(datas[5].id, datas[5].status);
                    }
                };
            }
        <?php } ?>

        // Only initialize context menu if there is at least one item
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }

</script>
<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true) {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=bin/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_bin_details').DataTable().ajax.reload()
                        t8.success(' Success!');
                    }
                }
            });
        }


    }
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="material-icons">delete</i> -->
        Bins
        <div class="pull-right">
            <div class="col-sm-12">
                <div class="row">
                    <div class="col-sm-5">
                        <?php
                        echo CHtml::dropDownList('warehouse_id', '', MasInventoryWarehouse::getUserWarehousees(), array('class' => 'form-control ', 'data-label' => 'Warehouse', 'empty' => '--Warehouse--'));
                        ?>
                    </div>
                    <div class="col-sm-4">
                        <?php
                        echo CHtml::dropDownList('rack_id', '', MasInvRack::getRacks(), array('class' => 'form-control ', 'data-label' => 'Rack ', 'empty' => '-- Rack--'));
                        ?>
                    </div>

                    <div class="col-sm-2">
                        <?php if ((isset(Yii::app()->user->havePermissionOn['mas_inv_bin_add']) || Yii::app()->user->authorised_user == 1)) { ?>

                            <a class="ad-btn" onclick="loadPopupModal('bin/create','Add New Bin','lg')" title="Add">
                                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                                    <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                                    <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2"
                                        stroke-linecap="round" />
                                    <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2"
                                        stroke-linecap="round" />
                                </svg>
                                <a>
                                <?php } ?>
                    </div>
                </div>
            </div>
        </div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_bin_details">
                <thead>
                    <tr>
                        <th>Sl.No</th>
                        <th>Warehouse</th>
                        <th>Rack</th>
                        <th>Bin</th>

                    </tr>
                </thead>
                <!-- <tfoot>
                        <tr>
                            <th>Sl.No</th>
                            <th>Bin</th>
                            <th>Rack</th>
                            
                        </tr>
                    </tfoot> -->
            </table>
        </div>
    </div>
</section>