

<!DOCTYPE html>
<html>

    <head>
        <title>Commission Invoice Report</title>
    </head>
    <style>
        .table {
            border-collapse: collapse !important;
            font-size: 10px;
            color: #101010;
            width: 100%;
        }
        .table thead th{
            background: #1f67b2;
            color: #Fff;
        }
        .table th,
        .table td {
            border: 1px solid #1f67b2 !important;
            text-align: left;
            padding: 3px 6px;
        }
        .table th.text-left,
        .table td.text-left{
            text-align: left;
            text-align: left !important;
        }
        .table th.text-right,
        .table td.text-right{
            text-align: right;
            text-align: right !important;
        }
        .table th.text-center,.table td.text-center{
            text-align: center;
            text-align: center !important;
        }
        .table tbody tr:nth-child(even){
            background: #f4fef3;
        }
        .table th.Table-Title,
        .table td.Table-Title{
            padding:7px 6px !important;
            font-size:1.15rem;
            color:green;
            font-weight:500;
            text-transform:uppercase;
        }
        .table th.total,
        .table td.total{
            background: #1f67b2;
            color: #Fff;
            font-size: 14px;
        }
    </style>
    <body>
        <div class="heading">
            <?php $this->renderPartial("//common/header",array('warehouse_id' => $warehouse_id));?>
            <div class="col-12 text-center" style="margin: 0 auto;">
                <h1><u>Commission Invoice Report</u></h1>
            </div>
            <div class="col-12">
                <div class="details-box">
                    <table class="table" style="width:100%">
                        <?php if ($from_date != '') { ?>
                            <tr>
                                <td style="width: 20%"><b>From </b></td>
                                <td>
                                    <?php echo date("d/m/Y", strtotime($from_date)); ?>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ($to_date != '') { ?>
                            <tr>
                                <td style="width: 20%"><b> To</b></td>
                                <td>
                                    <?php echo date("d/m/Y", strtotime($to_date)); ?>   
                                </td>
                            </tr>
                        <?php } ?>

                        <?php if ($leadowner_id > 0) { ?>
                            <tr>
                                <td style="width: 20%"><b>Lead Owner</b></td>
                                <td>
                                    <?php
                                    $l = User::model()->findByPK($leadowner_id);
                                    echo $l->first_name . " " . $l->last_name;
                                    ?>
                                </td>
                            </tr>
<?php } ?>

   <tr>
                            <td style="width: 20%"><b>Warehouse</b></td>
                            <td>
                                <?php if ($warehouse_id  > 0) { ?>
                                 
                                <?php $l = MasInventoryWarehouse::model()->findByPK($warehouse_id);
                                echo $l->warehouse_name; ?>
                          
                                <?php } ?>
                            </td>
                        </tr>
                        
                        

                        </tr>


                    </table>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="table-body">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                  <thead>
                    <tr>
                        <th class="text-center"> No</th>
                        <th class="text-center"> Branch</th>
                        <th class="text-center"> Inv No</th>
                        <th class="text-center">Sales Man</th>
                        <th class="text-center">Sub Total</th>
                        <th class="text-center">Discount</th>
                        <th class="text-center"> Net Total</th>
                        <th class="text-center">VAT</th>
                        <th class="text-center"> Amount w/o VAT</th>
                        <th class="text-center"> Commision</th>

                        <th class="text-center">Balance</th>
                        <th style="width:10%;">Received Card Amount</th>
                        <th style="width:15%;">Deposit to bank </th>

                    </tr>
                </thead>
                <tbody>
                    <?php
                    // $i=0;
                    if ($from_date != '') {
                        $from_date = str_replace('/', '-', $from_date);
                        $from_date = date('Y-m-d', strtotime($from_date));
                    }
                    if ($to_date != '') {
                        $to_date = str_replace('/', '-', $to_date);
                        $to_date = date('Y-m-d', strtotime($to_date));
                        //$condition .= ' AND t.invoice_date <="'.$to_date1.'"';
                    }
                    $condition = '';
                    $condition_cr = '';
                    if ($leadowner_id > 0) {
                        $condition .= ' AND (inv.created_by ="' . $leadowner_id . '"  )';
                        $condition_cr .= " AND C.created_by = " . $leadowner_id;
                    }

                   // $warehouse_id = isset($_REQUEST['warehouse_id']) ? $_REQUEST['warehouse_id'] : "";

                    if ((int)$warehouse_id > 0) {
                        $condition .= " AND I.warehouse_id = " . $warehouse_id;
                        $condition_cr .= " AND C.warehouse_id = " . $warehouse_id;
                    }
                    /*$SQL = "SELECT sum(amount) AS amount,creater.commission as commission_percent,invoice_no,sum(inv.deduction_amount)as deduction_amount,sum(inv.net_amount) AS net_amount,SUM(inv.tax_vat_amount) AS tax_vat_amount,I.received_card_amount as received_card_amount,I.warehouse_id,W.warehouse_name,creater.first_name as fname,
                       creater.last_name as lname FROM erp_invoice_item inv JOIN erp_invoice I ON inv.invoice_id=I.id   LEFT  JOIN   bluesky01_erp_dehnee_perfume_dtc_main.erp_user as creater 
                        ON I.created_by=creater.id 
                         JOIN erp_mas_inv_warehouse W ON I.warehouse_id=W.id
                        WHERE I.invoice_date >='".$from_date."' AND I.invoice_date <='".$to_date."'
                        $condition   GROUP BY inv.invoice_id";*/
                      // -------------------------invoice------------------------------------------------
                    //$company_db_name = Yii::app()->user->main_db_name;
                    $company_db_name=MasCompany::MainDB;
                    $SQL = "SELECT sum(amount) AS amount, 
                           I.commision_amount as commision_amount,
                           I.commision_percentage as commission_percent,
                           invoice_no,sum(inv.deduction_amount)as deduction_amount,
                           sum(inv.net_amount) AS net_amount,SUM(inv.tax_vat_amount) AS tax_vat_amount,
                           I.received_card_amount as received_card_amount,I.warehouse_id,
                           W.warehouse_name,CONCAT(creater.first_name, ' ', creater.last_name) AS user_name
                           FROM erp_invoice_item inv 
                           JOIN erp_invoice I ON inv.invoice_id=I.id  
                           LEFT  JOIN   {$company_db_name}.erp_user as creater 
                            ON I.created_by=creater.id 
                             JOIN erp_mas_inv_warehouse W ON I.warehouse_id=W.id
                            WHERE I.invoice_status!='C' AND I.invoice_date >='" . $from_date . "' AND I.invoice_date <='" . $to_date . "'
                             $condition   GROUP BY inv.invoice_id";
                    $model_invoice = Yii::app()->db->createCommand($SQL)->queryAll();
                    // ----------------------------creditnote--------------------------
                    $SQL_cr = "SELECT
                      sum(CI.net_amount+CI.tax_vat_amount) as net_amount,
                               C.credited_amount AS credited_amount, C.commision_amount AS commision_amount, C.commision_percentage AS commission_percent,
                                INV.invoice_no AS invoice_no,SUM(CI.tax_vat_amount) AS tax_vat_amount,
                                C.paid_card_amount AS paid_card_amount, C.warehouse_id,  W.warehouse_name,
                                CONCAT( creater.first_name,' ', creater.last_name  ) AS user_name
                            FROM
                                erp_creditnote_item CI
                            JOIN erp_creditnote C ON   CI.creditnote_id = C.id
                            LEFT JOIN erp_invoice INV ON C.invoice_id = INV.id
                            LEFT JOIN {$company_db_name}.erp_user AS creater  ON  C.created_by = creater.id
                            JOIN erp_mas_inv_warehouse W ON  C.warehouse_id = W.id
                            WHERE C.invoice_id > 0 AND C.isActive = 'Y' AND C.is_updated_store = 'Y' AND C.credited_date >= '" . $from_date . "' 
                            AND C.credited_date <= '" . $to_date . "' $condition_cr
                            GROUP BY  CI.creditnote_id";
                    $creditnote_list = Yii::app()->db->createCommand($SQL_cr)->queryAll();
                    // ------------------------------------------------------
 $i = 0;

                    foreach ($model_invoice as $i => $model) {
                    ?>
                        <tr title="Invoice">

                            <td> <?php echo $i + 1; ?> </td>
                            <td> <?php echo $model['warehouse_name']; ?></td>
                            <td> <?php echo $model['invoice_no']; ?></td>
                            <td><?php echo $model['user_name']; ?> </td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['amount'], ""); ?> </td>
                            <td class="text-right">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model['deduction_amount'], "");
                                $total_deduction_amount += $model['deduction_amount'];
                                ?>
                            </td>

                            <td class="text-right">
                                <?php
                                echo Yii::app()->numberFormatter->formatCurrency($model['amount'] - $model['deduction_amount'], " ");
                                $total_net_amount += $model['amount'] - $model['deduction_amount'];
                                $amount_without_vat = $model['amount'] - $model['deduction_amount'] - $model['tax_vat_amount'];
                                $total_vat_grand += $model['tax_vat_amount'];
                                ?>
                            </td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['tax_vat_amount'], "");

                                                    ?> </td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($amount_without_vat, " "); ?></td>
                            <td class="text-right">
                                <?php
                                $commission_amount =  $model['commision_amount'];
                                echo Yii::app()->numberFormatter->formatCurrency($commission_amount, "");
                                $total_percent += $commission_amount;
                                ?>
                            </td>

                            <td class="text-right">
                                <?php
                                $balance = (float) ($model['amount'] - $model['deduction_amount']) - (float)$commission_amount;
                                echo Yii::app()->numberFormatter->formatCurrency($balance, "");
                                $total_balance += $balance;
                                $total_amount += $model['amount'];
                                $total_grand += $amount_without_vat
                                ?>
                            </td>
                            <td class="text-right">
                                <?php
                                echo Yii::app()->numberFormatter->formatCurrency($model['received_card_amount'], "");
                                $total_received_card_amount += $model['received_card_amount'];
                                ?>
                            </td>
                            <td class="text-right">
                                <?php
                                $bank_depoist = ($balance - $model['received_card_amount']);
                                echo Yii::app()->numberFormatter->formatCurrency($bank_depoist, "");
                                $total_deposit += $bank_depoist;

                                ?>
                            </td>

                        </tr>
                    <?php } ?>

                    <?php
                     $i++;
                    foreach ($creditnote_list as  $credit) {
                    ?>
                        <tr style="background-color: #ffc05026;" title="Credit Note">
                            <td> <?php echo $i+1; ?> </td>
                            <td> <?php echo $credit['warehouse_name']; ?></td>
                            <td> <?php echo $credit['invoice_no']; ?></td>
                            <td><?php echo $credit['user_name']; ?> </td>
                            <td class="text-right">- </td>
                            <td class="text-right"> -</td>

                            <td class="text-right">
                                <?php
                                echo Yii::app()->numberFormatter->formatCurrency(-1 * ($credit['net_amount']), " ");
                                $total_net_amount_cr += -1 * ($credit['net_amount']);
                                ?>
                            </td>
                            <td class="text-right">
                                <?php echo Yii::app()->numberFormatter->formatCurrency(-1 * ($credit['tax_vat_amount']), "");
                                $total_vat_grand_cr += -1 * ($credit['tax_vat_amount']);
                                ?>
                            </td>
                            <td class="text-right">
                                <?php
                                $amount_without_vat = -1 * ($credit['net_amount']) - -1 * ($credit['tax_vat_amount']);
                                echo Yii::app()->numberFormatter->formatCurrency($amount_without_vat, " ");
                                $total_grand_cr += $amount_without_vat

                                ?>
                            </td>

                            <td class="text-right">
                                <?php
                                $commission_amount =  $credit['commision_amount'];
                                echo Yii::app()->numberFormatter->formatCurrency($commission_amount, "");
                                $total_percent_cr += $commission_amount;
                                ?>
                            </td>

                            <td class="text-right">
                                <?php
                                $balance = (float) (-1 * ($credit['net_amount'])) - (float)$commission_amount;
                                echo Yii::app()->numberFormatter->formatCurrency($balance, "");
                                $total_balance_cr += $balance;
                                ?>
                            </td>
                            <td class="text-right">
                                <?php
                                echo Yii::app()->numberFormatter->formatCurrency($credit['paid_card_amount'], "");
                                $total_received_card_amount_cr += $credit['paid_card_amount'];
                                ?>
                            </td>
                            <td class="text-right">
                                <?php
                                $bank_depoist = ($balance - $credit['paid_card_amount']);
                                echo Yii::app()->numberFormatter->formatCurrency($bank_depoist, "");
                                $total_deposit_cr += $bank_depoist;

                                ?>
                            </td>

                        </tr>
                    <?php  $i++; } ?>


                    <tr>
                        <td colspan="4"> </td>

                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_amount, " ");     ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_deduction_amount, " ");     ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_net_amount + $total_net_amount_cr, " ");     ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_vat_grand + $total_vat_grand_cr, " ");     ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_grand + $total_grand_cr, " ");     ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_percent + $total_percent_cr, " ");     ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_balance + $total_balance_cr, " ");     ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_received_card_amount + $total_received_card_amount_cr, " ");     ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_deposit + $total_deposit_cr, " ");     ?></b> </td>
                    </tr>
                </tbody>
            </table>

        </div>

<?php $this->renderPartial("//common/footer"); ?>
    </body>

</html>



