<!DOCTYPE html>
<html>

<head>
    <title>Settlement Report </title>
</head>

<style>
    @page {
        margin-top: 0.4cm;
        margin-bottom: 2.5cm;
        margin-left: 0.5cm;
        margin-right: 0.5cm;
        header: html_myHeader;
        header: html_otherpages;
        font-family: 'Times New Roman';
    }
</style>

<?php
$warehouse_outlet_name = '';
$address = '';
$branch_logo='';
if (!empty($warehouse_id)) {
    $model = new MasInventoryWarehouse();

    $model_det = $model->findByPk($warehouse_id);
    $branch_logo = $model_det->upload_image;
    $warehouse_outlet_name = $model->getWarehouseName($warehouse_id);
    $address = $model_det->address;
}
?>

<body>
    <div class="heading">

        <!---------------------------------->
        <div class="col-6 text-center">

            <?php if (!empty($branch_logo)) { ?>
                <img style="width:50px; height:50px; " src="<?php echo  'uploads/warehouse/thumbs/' . $branch_logo; ?>" />
            <?php }  ?>
        </div>
        <div class="col-6 text-center">
            <b style="font-size:9px" class="text-center"><?= $warehouse_outlet_name.'<br>'.$address; ?></b>
        </div>
        <div class="col-12 text-center">
            <h5><u>Settlement Report </u></h5>
        <div>
    </div>


    <!---------------------------------->

    <div>


        <div class="table-body">
            <?php
            $selected_date = str_replace('/', '-', $selected_date);
            $selected_date = date("Y-m-d", strtotime($selected_date));
            $condition = " t.opening_date = '$selected_date' ";


            $modelOpCash = new OpeningCash();
            $modelOpCash = $modelOpCash->find(['condition' => $condition]);
            $opening_cash = 0;
            if (!empty($modelOpCash)) {
                $opening_cash = $modelOpCash->opening_cash;
            }


            // -----------inv---added by indhu 22-03-2023-----------------------------

            $sql_inv = "SELECT 
                    sum(item_amount) as  amount,
                    sum(grand_total) as grand_total,
                    sum(item_tax_vat_amount) as  tax_vat_amount,
                    sum(item_deduction_amount) as deduction_amount ,
                    sum(item_net_amount) as net_amount ,
                    sum(item_cost_amount) as item_cost_amount,
                    sum(received_cash_amount) as received_cash_amount, 
                    sum(received_card_amount) as received_card_amount, 
                    sum(commission_amount) AS commission_amount ,
                    warehouse_id,warehouse_name,user_name,created_by,invoice_id,invoice_no
                    FROM view_commission_sales_report   
                    WHERE invoice_date = :selected_date AND warehouse_id = :warehouse_id
                    ";

            $command1 = Yii::app()->db->createCommand($sql_inv);
            $command1->bindParam(":selected_date", $selected_date);
            $command1->bindParam(":warehouse_id", $warehouse_id);
            $inv_details = $command1->queryAll();


            $inv_amount            = isset($inv_details[0]['amount']) ? $inv_details[0]['amount'] : 0;

            $deduction_amount      = isset($inv_details[0]['deduction_amount']) ? $inv_details[0]['deduction_amount'] : 0;

            $total_discount_inv    = !empty($inv_details) ? $inv_details[0]['deduction_amount'] : 0;

            $total_cash_amount_inv = !empty($inv_details) ? $inv_details[0]['received_cash_amount'] : 0;

            $total_card_amount_inv = !empty($inv_details) ? $inv_details[0]['received_card_amount'] : 0;

            $total_vat_inv         = !empty($inv_details) ? $inv_details[0]['tax_vat_amount'] : 0;

            $gross_total_inv       = $inv_amount;

            $net_total_inv         = $inv_amount - $deduction_amount;

            $drawer_amount_inv     = $total_cash_amount_inv + $opening_cash;

            // -----------credit-note----------------------------------


             $sql_cr = "SELECT 
                        SUM(item_net_amount) AS item_net_amount,
                        SUM(item_net_amount + item_tax_vat_amount) AS cr_total_amount,
                         sum(total_tax_amount) as total_tax_amount,
                        SUM(item_tax_vat_amount) AS item_tax_vat_amount,
                         sum(paid_card_amount) as paid_card_amount, 
                        warehouse_id,
                        credited_date
                    FROM view_commission_creditnote_report
                    WHERE credited_date = :selected_date AND warehouse_id = :warehouse_id
                    ";

            $command = Yii::app()->db->createCommand($sql_cr);
            $command->bindParam(":selected_date", $selected_date);
            $command->bindParam(":warehouse_id", $warehouse_id);
            $creditnote_list = $command->queryAll();

            $total_sales_return = !empty($creditnote_list) ? $creditnote_list[0]['cr_total_amount'] : 0;

            $drawer_amount_inv     = $total_cash_amount_inv + $opening_cash - $total_sales_return;

            $net_total_cr         = $total_sales_return;
            $total_vat_cr         = !empty($creditnote_list) ? $creditnote_list[0]['total_tax_amount'] : 0;


            //   ---  ------------------------------------

            ?>
 
            <table class="table  table-bordered table-primary dataTable" style="font-size:8px">
             
                <tr>
                    <th>Date</th>
                    <th class="text-right">
                        <?php echo   date("d/m/Y", strtotime($selected_date)); ?>

                    </th>
                </tr>

                <tr>
                    <th>Cash At Starting</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($opening_cash, " "); ?>
                    </th>
                </tr>
                <tr>
                    <th>Cash Sale</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($total_cash_amount_inv, " "); ?>
                    </th>
                </tr>
                <tr>
                    <th>Card Sale</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($total_card_amount_inv, " "); ?>
                    </th>
                </tr>

                <tr>
                    <th>Payback/Sales Return</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($total_sales_return, " "); ?>
                    </th>
                </tr>

                <tr>
                    <th>Expense</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency(0, " "); ?>
                    </th>
                </tr>
                <tr>
                    <th>Total VAT</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($total_vat_inv - $total_vat_cr, " "); ?>
                    </th>
                </tr>
                <tr>
                    <th>Amount in Cash Drawer</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($drawer_amount_inv, " "); ?>
                    </th>
                </tr>
                <tr>
                    <th>Gross Total</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($gross_total_inv, " "); ?>
                    </th>
                </tr>
                <tr>
                    <th>Discount</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($total_discount_inv, " "); ?>
                    </th>
                </tr>
                <tr>
                    <th>Net Total</th>
                    <th class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($net_total_inv - $net_total_cr, " "); ?>
                    </th>
                </tr>

            </table>

        </div>


        <htmlpagefooter name="myfooter">

            <p style="text-align:center;font-size:11px;padding-right:17px;margin-top:80px;">
                <?php echo $modelComapnyDetails->footer_autogenerated; ?>Printed On:&nbsp;
                <?php
                date_default_timezone_set("Asia/Dubai");
                echo date('d/m/Y') . " " . date("h:i:sa"); ?>
            </p>

        </htmlpagefooter>
        <sethtmlpagefooter name="myfooter" page="all" value="on" />
</body>

</html>