<script>
    $(document).ready(function () {
        var table_id = "#tbl_aidashboard";
        table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            //scrollY: "450px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('Aidashboard/GetList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }
        });
    });

    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;

        <?php if (isset(Yii::app()->user->havePermissionOn['ai_dashboard_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_edit = 1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['ai_dashboard_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_disable = 1;
        <?php } ?>

        // Build menu items dynamically
        var menuItems = {};

        <?php if (isset(Yii::app()->user->havePermissionOn['ai_dashboard_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.edit = {
                name: "Edit",
                icon: "edit",
                accesskey: "e",
                callback: function () {
                    loadPopupModal("Aidashboard/create&code=" + datas[2].code, datas[1], "lg");
                }
            };
        <?php } ?>

        <?php if (isset(Yii::app()->user->havePermissionOn['ai_dashboard_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            // menuItems.Disable_Enable = {
            //     name: (datas[3].status == "Y") ? "Disable" : "Enable",
            //     icon: "edit",
            //     accesskey: "d",
            //     callback: function () {
            //         Disable(datas[2].code, datas[3].status); // or datas[2].id if using ID
            //     },
            //     disabled: function (key, opt) {
            //         // Example business logic: disable if already active
            //         if (String(datas[3]).trim().toUpperCase() === 'Y') {
            //             return true;
            //         }
            //         return false;
            //     }
            // };
        <?php } ?>

        // Attach context menu only if at least one item exists
        if (Object.keys(menuItems).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: menuItems
            });
        }
    }

</script>

<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa-pie-chart"></i> -->
        Ai Dashboard
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['ai_dashboard_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <a class="ad-btn" onclick="loadPopupModal('Aidashboard/create','Add New Ai Dashboard','lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                        class="pluss-ad">
                        <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                        <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                    </svg>
                </a>

            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_aidashboard" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>SI No</th>
                        <th>AI Type</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>