
<?php

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("getAllLocations", "
    function getAllLocations(val){
    
        jQuery.ajax({
            'dataType': 'json',
            'data' : {'countryid':val},
            'type':'post',
            'url': '".Yii::app()->createUrl('meeting/getAllLocations')."',
            'cache': false,
            'success': function(data) {
                $('#meeting_location_li').html(data.location);
            }
        });
    }", CClientScript::POS_HEAD);
$cs->registerScript("getAllEmployee", "
    function getAllEmployee(val){
    
        jQuery.ajax({
            'dataType': 'json',
            'data' : {'location_id':val},
            'type':'post',
            'url': '".Yii::app()->createUrl('meeting/getAllEmployee')."',
            'cache': false,
            'success': function(data) {
                $('#meeting_conducted_by_li').html(data.conducted);
                $('#meeting_attendees_li').html(data.attendees);
            }
        });
    }", CClientScript::POS_HEAD);
$emp_details = array ();
 $location_details = array();
if( $model->id != ""){
    $location_list =  MasLocations::model()->findAll(array('condition'=> "t.isActive = 'Y' AND t.country_id = " . $model->country_id));  
    $location_details = CHtml::listData($location_list, 'id', 'location');

    $condition= " t.isActive = 'Y' and t.location = " . $model->location_id;
    $emp_model = new Employee;
    $model_emp = $emp_model->with('loc')->findAll(array('condition' => $condition));
    $emp_details  = CHtml::listData($model_emp, 'id', 'name');
    $conducted_by = $model->conducted_by;
    $conducted_by_arr = explode(",", $conducted_by);
    foreach ($conducted_by_arr as $eachValue)
        $selectedOptions[$eachValue] = array('selected' => 'selected');
    $attendees = $model->attendees;
    $$attendees_arr = explode(",", $attendees);
    foreach ($$attendees_arr as $eachValue){
        $selected_options[$eachValue] = array('selected' => 'selected');
    }
}
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'remarks-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
 ?>


    <div class="tab-content">
        <div class="tab-pane active">
             <ul class="clearfix form-ul material">
                <li class="col-sm-4">
                    <?php echo $form->hiddenField($model, 'id'); ?>

                    <?php echo $form->textField($model, 'type', array('class' => 'tooltipster','data-label'=>'Meeting Type <span style="color:red;">*</span>' )); ?>                    
                </li>
                <li class="col-sm-8">               
                    <?php echo $form->textField($model, 'meeting_title', array('class' => 'tooltipster','data-label'=>'Meeting Title <span style="color:red;">*</span>' )); ?>                 
          
                </li>
                <li class="col-sm-4">
                    <?php echo $form->dropDownList($model, 'country_id',MasCountry::getUserCountry(Yii::app()->user->user_country), array('onchange'=> 'getAllLocations(this.value);', 'class' => 'tooltipster','data-label'=>'Country <span style="color:red;">*</span>', "empty" => "Select" )); ?>
                </li>
                <li class="col-sm-4" id= "meeting_location_li">
                    <?php echo $form->dropDownList($model, 'location_id', $location_details, array('class' => 'tooltipster','data-label'=>'Location <span style="color:red;">*</span>')); ?>
                </li>
                <li  class="col-sm-4">
                    <?php echo $form->textField($model, 'meeting_date', array('class' => 'datepicker tooltipster','data-label'=>'Meeting date')); ?>
                </li>
                <li class="col-sm-4">               
                    <?php echo $form->textField($model, 'meeting_time', array('class' => 'clockpicker tooltipster','data-label'=>'Meeting Time <span style="color:red;">*</span>' )); ?>  
                </li>
                <li class="col-sm-4"  id= "meeting_conducted_by_li">
                    <?php  
                    echo CHtml::dropDownList('conducted_by',"", $emp_details, array( "name" =>"conducted_by" , 'class' => 'tooltipster','data-label'=>'Conducted by <span style="color:red;">*</span>','multiple'=>true, 'options' => $selectedOptions, 'data-search'=>true)); ?> 
                </li>
                       
                <li class="col-sm-4"  id= "meeting_attendees_li" >
                <?php echo CHtml::dropDownList('attendees',"", $emp_details, array('class' => 'tooltipster','data-label'=>'Attendees <span style="color:red;">*</span>','multiple'=>true, 'options' => $selected_options, 'data-search'=>true)); ?>
                </li>

            </ul>
        </div>        
    </div> 
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <?php
                $url = Yii::app()->createUrl('meeting/save');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                    if(data.status=="success"){  
                                        $(".x.close").click();
                                        $("#loader").hide();
                                        t8.success("Saved!!");
                                        reloadTable("#table_meeting_summary");
                                    } else { 
                                        $("#loader").hide();
                                        $.each(data, function(key, val) {
                                            t8.error(""+val+""); 
                                        }); 
                                    } 
                            }',
                            'beforeSend' => 'function(){
                                $("#loader").show();
                            }',
                            
                    ), array('id' => 'mybtn' . rand(), 'class' => 'customer1-save-btn btn btn-theme'));
           
    ?>
    </div>
    <?php $this->endWidget(); ?>
