<?php
 $condition = ' isActive =  "Y"  ';
$users = User::getUserModels();

function randomColor() {
    $result = array('rgb' => '', 'hex' => '');
    foreach (array('r', 'b', 'g') as $col) {
        $rand = mt_rand(0, 255);
        $result['rgb'][$col] = $rand;
        $dechex = dechex($rand);
        if (strlen($dechex) < 2) {
            $dechex = '0' . $dechex;
        }
        $result['hex'] .= $dechex;
    }
    return "#" . $result['hex'];
}

function random_color_part() {
    $dt = '';
    for ($o = 1; $o <= 3; $o++) {
        $dt .= str_pad(dechex(mt_rand(0, 127)), 2, '0', STR_PAD_LEFT);
    }
    return "#" . $dt;
}
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <div class="pull-left"> 
            <i class="fa fa-users"></i> Workspace
        </div>
        <div  ondrop="dropLead(event)"    ondragover="allowDrop(event)"  id ="lead_drop" class="pull-left" style="">Lead</div>
        <div  ondrop="dropQuotation(event)"    ondragover="allowDrop(event)"  id ="quotation_drop" class="pull-left" style="">Quotation</div>

        <div class="pull-right">
            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('workspace/space/create', 'Add New Workspace', 'lg')"><i class="fa fa-plus"></i> ADD</button>
        </div>
    </header>
    <div class="panel-body">
        <div class="panel-body">

            <?php foreach ($users as $value) {
                ?>
                <div draggable="true" ondragstart="dragUser(event)"   title="<?= $value->getFullname() ?>" style="background: <?= random_color_part() ?>" class="ws-avatar" id="wsavatar_<?= $value->id ?>" data-id="<?= $value->id ?>">
                    <?= $value->getAvatar() ?>
                </div>
            <?php }
            ?>
        </div>
        <?php
        $workspacelist = Workspace::model()->findAll(array('condition' => $condition, 'order' => 'id'));
        foreach ($workspacelist as $value) {
            ?>
            <style>
                .card<?= $value->id ?> .noDrop{
                    background-color:<?= $value->color_code ?> !important;
                }
            </style>
            <div class="workspace-card card"  style="" >
                <div class="card-header panel-theame"><?= $value->name ?></div>
                <div id="workspace_id_<?= $value->id ?>" class="card-body card<?= $value->id ?>"style="width: 100%;height: 100%"  ondrop="drop(event)" ondragover="allowDrop(event)" >


                </div>
            </div>
        <?php } ?>
    </div>
</section>
<style>
    .workspace-card{
        color:gray;
        width: 200px;
        float: left;
        min-height: 500px;
        margin: 5px;
        border: solid 1px #ebe3e3;
        padding-bottom: 30px;
        /*overflow: scroll;*/
    }
    .card-header{
        display: block;
        font-weight: 450;
        width: 100%;
        text-align: center;
        /*        background-color: gray;*/
        color: #828181;
    }
    .card-body{
        display: block;
        width: 100%;     
        height: 100%;
        min-height:470px;
        /*background-color: #666666;*/
        /*overflow: scroll;*/
    }
    .label{
        height: 150px;
        margin: 2px;
        font-size: 14px
    }
    .itemclose{
        text-decoration: none;
        text-shadow: 0 1px 0 gray;
        opacity: 0.75;
    }
    .itemclose:hover{
        text-decoration: none;
        color: whitesmoke;
        opacity: 1;
    }
    .inner-card{
        top:16px;
        position: relative;
    }
</style>
<script>
    function allowDrop(ev) {
        ev.preventDefault();
    }

    function drag(ev) {
        ev.dataTransfer.setData("text", ev.target.id);
    }
    function dragUser(ev) {
        ev.dataTransfer.setData("user", ev.target.id);
    }

    function drop(ev) {
        var _target = $("#" + ev.target.id);
        var data = ev.dataTransfer.getData("text");
        if (data == "") {
            var user = ev.dataTransfer.getData("user");
            if (user != "") {
                addUserto(user, ev.target.id)
            }
            ev.preventDefault();
            return false;
        } else {

        }
        console.log(data);
        console.log(ev.target.id);
        var workspace_id = ev.target.id.split('_')[2];
        var item_id = data.split('_')[2];

        if ($(_target).hasClass("noDrop")) {
            //debugger;
            console.log("no transfer");
            ev.preventDefault();
            var card_body = $(ev.target).parent('.card-body');
            console.log(card_body);
            $(card_body).append(document.getElementById(data));
            var workspace_id = $(ev.target).parent('.card-body').prop('id').split('_')[2];
            updateItem(workspace_id, item_id);
        } else {
            ev.preventDefault();
            ev.target.appendChild(document.getElementById(data));
            updateItem(workspace_id, item_id);
        }
        $("#" + data).tooltip('hide');
        // var workspace_id = ev.target.id.split('_')[2];

    }
    function dropOnCard(ev) {
        ev.preventDefault();
    }
    function updateItem(workspace_id, item_id) {
        $.ajax({
            url: "index.php?r=workspace/space/UpdateWorkspace",
            type: 'POST',
            dataType: 'json',
            data: {
                workspace_id: workspace_id, item_id: item_id
            },
            success: function (data, textStatus, jqXHR) {

            }
        });
    }
    function addItem(data) {
        if ($("#note_id_" + data.id).length == 0) {
            var closeBtn = '<a onclick="deleteItem( ' + data.id + ', this);" class="itemclose noDrop" href="#" style="margin-right: 0px;float: right;color: white;font-size: 10px;">x</a>';

            var share_html = getShareHtml(data.shared_to);
            // shred item 

            var html = '<div ondblclick=\'loadPopupModal("workspace/space/create&id=' + data.id + '","Add New Workspace", "lg")\'  class="label noDrop" style="display: block;" draggable="true" ondragstart="drag(event)" id="note_id_' + data.id + '" >' + closeBtn + '<div  ondrop="return false;" id="note_innerid_' + data.id + '" class="inner-card noDrop">' + data.title + "</div>" + share_html + ' </div>';
            $("#workspace_id_" + data.workspace_id).append(html);
        } else {
            $("#note_innerid_" + data.id).html(data.title);
            var workspace_id = $("#note_id_" + data.id).prop('workspace');
            if (data.workspace_id != workspace_id) {
                var note = $("#note_id_" + data.id).detach();
                $("#workspace_id_" + data.workspace_id).append(note);
            }
            var share_html = getShareHtml(data.shared_to);
            //debugger;
            $("#note_id_" + data.id + " .share-container ").replaceWith(share_html);


        }
        $("#note_id_" + data.id).prop('data-toggle', 'tooltip');
        $("#note_id_" + data.id).prop('title', data.tooltip);
        $("#note_id_" + data.id).prop('lead_id', data.lead_id);
        $("#note_id_" + data.id).prop('file_id', data.file_id);
        $("#note_id_" + data.id).prop('workspace', data.workspace_id);
        $("#note_id_" + data.id).prop('itemid', data.id);
        $("#note_id_" + data.id).prop('html', true);
        $("#note_id_" + data.id).tooltip({title: data.tooltip, html: true, placement: "bottom"});

    }
    function getShareHtml(shared_to) {
        var share_item_conatinter_div = document.createElement('div');
        $(share_item_conatinter_div).addClass('share-container')
        $(share_item_conatinter_div).css({'color': 'white', 'bottom': '0px', 'position': 'relative', 'top': '110px'});
        $(shared_to).each((index, el) => {
            var share_item_span = document.createElement('div');
            share_item_span.innerHTML = el.name;
            var avatar_id = "#wsavatar_"+ el.id;
            var bgcolor = $(avatar_id).css('background-color');
             var title = $(avatar_id).prop('title');
            console.log(avatar_id);
            $(share_item_span).css({
                'float': 'right',
                'border-radius': '50%',
                'border': 'solid 1px white',
                'font-size': '9px',
                'height': "20px",
                'padding': '6px',
                'width': '20px',
                'padding-left': '3px',
                'background':bgcolor,
                 opacity:' 0.8'
            }
            );
            $(shared_to).prop('ondragover', 'return false');
            $(shared_to).prop('title', title);
            share_item_conatinter_div.appendChild(share_item_span);
        });
        $(share_item_conatinter_div).prop('ondragover', 'return false');
        return share_item_conatinter_div.outerHTML;
    }
    $(document).ready(function () {
        $.ajax({
            url: "index.php?r=workspace/space/getlist",
            type: 'POST',
            dataType: 'json',
            beforeSend: function (xhr) {
                $("#loader").show();
            },
            success: function (data, textStatus, jqXHR) {

                $(data).each((i, el) => {
                    addItem(el);
                });
                $("#loader").hide();
            }
        });
    });
    function deleteItem(id, evt) {
        var msg = "Are you sure you want to delete this item?";
        var dr = confirm(msg);
        if (dr) {
            $.ajax({
                url: "index.php?r=workspace/space/deleteItem",
                type: 'POST',
                dataType: 'json',
                data: {id: id},
                beforeSend: function (xhr) {
                    //$("#loader").show();
                },
                success: function (data, textStatus, jqXHR) {
                    $(evt).parent().tooltip('hide');
                    $(evt).parent().remove();
                    //$("#loader").hide();
                }
            });
        }
    }
    function dropLead(ev) {
        var id = ev.dataTransfer.getData("text");
        console.log(ev.dataTransfer.getData("text"));
        var lead_id = $("#" + id).prop('lead_id');
        var note_id = id.split('_')[2];
        loadPopupModal("lead/create&id=" + lead_id + "&note_id=" + note_id, 'Lead', "lg");
        ev.preventDefault();
    }
    function dropQuotation(ev) {
        var id = ev.dataTransfer.getData("text");
        console.log(ev.dataTransfer.getData("text"));
        var lead_id = $("#" + id).prop('lead_id');
        var file_id = $("#" + id).prop('file_id');
        var note_id = id.split('_')[2];
        if (lead_id == 0) {
            loadPopupModal("quotation/create&note_id=" + note_id, "Quotation", "xl");
        } else {
            loadPopupModal("quotation/create&lead_id=" + lead_id + "&file_id=" + file_id + '&note_id=' + note_id, "Convert To Quotation", "xl");
        }
        ev.preventDefault();
    }
    function addUserto(user, target) {
        var item_id = target.split('_')[2];
        var user_id = user.split('_')[1];
      
            $.ajax({
                url: "index.php?r=workspace/space/shareItem",
                type: 'POST',
                dataType: 'json',
                data: {id: item_id, 'user_id': user_id},
                beforeSend: function (xhr) {
                    $("#loader").show();
                },
                success: function (data, textStatus, jqXHR) {
                    $("#loader").hide();
                    addItem(data.item);
                }
            });
        
    }
</script>
<style>
    #quotation_drop, #lead_drop{
        border: dashed 2px #6c8c96;
        padding: 8px;
        width: 300px;
        text-align: center;
        color: #4669ad;
        margin-left: 50px;
        background: #ecf5fd;
    }.ws-avatar{

        border-radius: 50%;
        font-size: 10px;
        opacity: 0.8;
        font-weight: 600;
        color:white;
        width: 30px;
        height: 30px;
        text-align: center;
        float: left;
        padding-top:  7px;
        margin: 2px;

    }
    .ws-avatar:hover{
        opacity: 1;
        padding-top:  8px;
        width: 34px;
        height: 34px;
        margin: 0px;
    }
</style>