<ul class="clearfix form-ul material">
    <li class="col-sm-4">
        <?php echo $form->hiddenField($model, 'id'); ?>
        <?php echo $form->hiddenField($model, 'lead_id'); ?>
        <?php echo $form->hiddenField($model, 'file_id'); ?>
        <?php echo $form->hiddenField($model, 'customer_id'); ?>
        <?php echo $form->textField($model, 'title', array('data-label' => 'Customer/Prospect', 'onKeyup' => 'js:autoCompleteCustomers(this.id,"lead");','data-search' => true)); ?>
    </li>
    <li class="col-sm-4">
        <?php echo $form->textField($model, 'start_date', array('class' => 'datepicker', 'data-label' => 'Start Date')); ?>
    </li>
    <li class="col-sm-4">
        <?php echo $form->textField($model, 'due_date', array('class' => 'datepicker', 'data-label' => 'Due Date')); ?>
    </li>
    <li class="col-sm-4">
        <?php echo $form->dropDownList($model, 'project_workspace_id', ProjectWorkspace::getActiveProjectWorkSpace(), array('data-label' => 'Workspace')); ?>
    </li>
    <li class="col-sm-4">
        <?php 
        if(isset(Yii::app()->user->id)&&(int)$model->through_id==0){
            $model->through_id=Yii::app()->user->id;
        }
        echo $form->dropDownList($model, 'through_id', User::getUser(), array('data-label' => 'Handled By'));
        ?>
    </li>
    <li class="col-sm-4">
        <?php echo $form->dropDownList($model, 'sales_group_id', MasSalesGroup::getSalesGroups(), array('data-label' => 'Sales Group')); ?>
    </li>
    <li class="col-sm-4" style= "display: none"> 
        <?php echo $form->textField($model, 'amount', array('class' => 'text-right', 'data-label' => 'Amount')); ?>
    </li>
    
    <li class="col-sm-12">
        <?php echo $form->textArea($model, 'description', array('data-label' => 'Description')); ?>
    </li>
</ul>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteCustomers", "function autoCompleteCustomers(field_id)
{
var url = '" . Yii::app()->createUrl('customer/Getcustomer') . "&frm=space';
$('#'+field_id).autocomplete({
        minLength   : 1,
         source      : function (request, response) { autoCompleteSource(request, response,url) },

                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                select          : function( event, ui ) {

        event.preventDefault();

        trigger_target_id   =   $(event.target).attr('id');
        var customer_id=ui.item.value;  
        $('#ProjectWorkspaceNote_customer_id').val(customer_id);
    }
    
    })

}", CClientScript::POS_HEAD); 
?>

