<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("DisablePaymentterm", "function Disable(id){
    var r = confirm('Are you sure to enable/disable this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=workspace/master/Disable',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Disable');
                }else {
                      reloadTable('#tbl_branch_details');
                    t8.success('Bin Disabled/Enabled SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_branch_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('workspace/master/GetList') ?>",
                type: "POST",
                cache: false,
                data: function (d) {
                    d.ai_type_id = $('#ai_type_id').val(); // Pass selected type
                }
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                // console.log(aData);
                if (aData[4] == "Y") {
                    $("td", nRow).addClass("bg-payment");

                } else {
                    $("td", nRow).addClass("bg-test");
                }
                if (aData[5].status == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
                AddContextMenu(nRow, aData);
            }
        });
    });
    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;

        <?php if (isset(Yii::app()->user->havePermissionOn['workspace_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_edit = 1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['workspace_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            mas_disable = 1;
        <?php } ?>

        // Build menu items dynamically
        var menuItems = {};

        <?php if (isset(Yii::app()->user->havePermissionOn['workspace_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.edit = {
                name: "Edit",
                icon: "edit",
                accesskey: "e",
                callback: function () {
                    loadPopupModal("workspace/master/create&id=" + datas[5].id, datas[5].code, "lg");
                }
            };
        <?php } ?>

        <?php if (isset(Yii::app()->user->havePermissionOn['workspace_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.Disable_Enable = {
                name: (datas[5].status == "Y") ? "Disable" : "Enable",
                icon: "edit",
                accesskey: "d",
                callback: function () {
                    Disable(datas[5].id, datas[5].status);
                },
                disabled: function (key, opt) {
                    // Business logic: e.g., if another field indicates it should be disabled
                    if (String(datas[4]).trim().toUpperCase() === 'Y') {
                        return true;
                    }
                    return false;
                }
            };
        <?php } ?>

        // Attach context menu only if there is at least one item
        if (Object.keys(menuItems).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: menuItems
            });
        }
    }

</script>
<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true) {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=workspace/master/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_branch_details').DataTable().ajax.reload()
                        t8.success(' Success!');
                    }
                }
            });
        }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-user"></i> -->
        Workspace
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['workspace_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn" id="add_popup"
                    onclick="loadPopupModal('workspace/master/create', 'Add New Workspace', 'lg')" title="Add">

                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                        class="pluss-ad">
                        <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                        <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                    </svg>
                </a>
            <?php } ?>
        </div>
        <div class="col-sm-1 pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['workspace_view']) || Yii::app()->user->authorised_user == 1) { ?>
                <?php echo CHtml::dropdownList(
                    'ai_type_id',
                    '0',
                    array('SA' => 'Sales', 'PR' => 'Purchase', 'PO' => 'Production', 'PL' => 'Pipeline', 'ST' => 'Inventory', 'FI' => 'Finance', 'IN' => 'Info'),
                    array('class' => 'form-control', 'onChange' => 'reloadTable("#tbl_branch_details")', 'prompt' => '-Types-')
                ); ?>
            </div>
        <?php } ?>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_branch_details"
                style="font-size:13px;">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Workspace Name</th>
                        <th>Type</th>
                        <th>Sort Order</th>
                    </tr>
                </thead>

            </table>

        </div>

    </div>

</section>
<script>
    function reloadTable(tableSelector) {
        $(tableSelector).DataTable().ajax.reload();
    }
</script>