<?php

/**
 * This is the model class for table "{{mas_project_module_details}}".
 *
 * The followings are the available columns in table '{{mas_project_module_details}}':
 * @property integer $id
 * @property string $module
 * @property string $submodule
 * @property string $default_weightage
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasProjectModuleDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public function tableName()
	{
		return '{{mas_project_module_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('module_details,weightage_percent', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('weightage_percent', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id,module_details,weightage_percent, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
	return array(
                    'proj_detail' => array(self::BELONGS_TO, 'MasWorkspaceProject', 'project_id'),
                    'module_detail' => array(self::BELONGS_TO, 'MasProjectModule', 'main_module_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'module_details'=>'Module Details',
			'weightage_percent' => 'Weightage',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('module_details',$this->module_details,true);
		$criteria->compare('weightage_percent',$this->weightage_percent,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasProjectModule the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
    public static function getMasSubModuleTypeData($id=0) {
        $model = MasProjectModule::model()->findAll(array('condition' =>'module="'.$id.'"','order'=>'submodule'));
        return CHtml::listData($model, 'id', 'submodule');
    }

    public static function getMasProjectModules($id=0) {
		$query =	Yii::app()->db->createCommand(
	        " SELECT wp.* FROM crm_mas_workspace_project AS wp  where (wp.id not in(select project_id from crm_mas_project_module_details)) and wp.isActive ='Y'"
	    )
	        ->queryAll();
	        return CHtml::listData($query, 'id', 'project');
    }
	public static function getSubmoduleList($project_id=0,$module_id=0) {
        $condition = '1=1' ;
        if($project_id>0){
            $condition .= ' AND project_id="'.$project_id.'"';
        }
        if($module_id>0){
            $condition .= ' AND main_module_id="'.$module_id.'"';
        }
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'module_details'));
        return CHtml::listData($model, 'id', 'module_details');
}


}
