<?php

class SpaceController extends Controller
{

    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'getlist', 'create', 'save',
                    'UpdateWorkspace', 'deleteItem', 'shareItem', 'prospectadd',
                    'deleteshareItem', 'viewall', 'GetSummary', 'GetSummaryDetails', 'Changeworkspace', 'GetWorkspaceQtns', 'CheckQtnexist', 'info', 'Infograph', 'CreateActivity', 'SaveActivity'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    public function actionCreate()
    {
        $model = new WorkspaceNote();
        $id = (int)Yii::app()->request->getParam('id');

        $frm = Yii::app()->request->getParam('frm');
        if (!empty($frm)) {
            $pass_from = Yii::app()->request->getParam('frm');
            $customer_id = (int)Yii::app()->request->getParam('customer_id');
        } else {
            $pass_from = '';
        }


        //$customer_id = (int) Yii::app()->request->getParam('customer_id');


        $lead_id = (int)Yii::app()->request->getParam('lead_id');


        if ($id > 0) {
            $model = $model->findByPk($id);
            if ($model->due_date != '0000-00-00') {
                echo $model->due_date;
               // $model->due_date = date('d/m/Y', strtotime($model->due_date));
            }
            $modelLead = Lead::model()->find(array('condition' => 'workspace_note_id=' . $model->id));
            if (!empty($modelLead)) {
                $model->file_id = $modelLead->file_id;
                $model->lead_id = $modelLead->id;
            }

        } else if ($lead_id > 0) {
            $model = $model->find(array('condition' => 't.lead_id = ' . $lead_id));
            if (empty($model)) {
                $lead = Lead::model()->findByPk($lead_id);
                $model = new WorkspaceNote();
                $model->lead_id = $lead_id;
                $model->due_date = date('d/m/yy', strtotime($lead->closing_date));
                $model->customer_id = $lead->customer_id;
                $model->title = $lead->customer->customer_name;
                $model->description = $lead->title;
                $model->file_id = $lead->file_id;
                $model->amount = $lead->value;
                $model->through_id = $lead->lead_owner_id;
                $model->sales_group_id = $lead->sales_group_id;
                $model->id = $lead->workspace_note_id;
                $pass_from = "lead_page";
            } else {
                if ($model->due_date != '0000-00-00') {
                    $model->due_date = date('d/m/yy', strtotime($model->due_date));
                }
            }

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);


        $this->render('create', array('model' => $model, 'pass_from' => $pass_from, 'customer_id' => $customer_id), false, false);
    }

// -------------------------------------
    public function actionSave08_08_2022()
    {

// if(empty($_POST['WorkspaceNote']['id'])){


        //     if (!empty($_POST['WorkspaceNote']['workspace_id'])) {
        //             if($_POST['WorkspaceNote']['workspace_id'] == "8"){
        //                 $model->workspace_id = '8';
        //             }else{
        //                 $model->workspace_id = $_POST['WorkspaceNote']['workspace_id'];
        //             }
        // }


// }else{

        $model = new WorkspaceNote();
        if (isset($_POST['WorkspaceNote'])) {
            if ((int)@$_POST['WorkspaceNote']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int)@$_POST['WorkspaceNote']['id'];
                $model = $model->findByPk($id);


            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $model->shared_to = Yii::app()->user->id;
            }

            // $model1 = $model->findByPk($_POST['WorkspaceNote']['id']);
            $model->attributes = $_POST['WorkspaceNote'];
            $model->status = $_POST['WorkspaceNote']['status'];
            //  $model->workspace_id = $_POST['WorkspaceNote']['workspace_id'];

            //           if (!empty($model1->workspace_id)) {
            //             if($model1->workspace_id == "8"){


            //                 $model->workspace_id = '8';
            //             }else{

            //                 $model->workspace_id = $_POST['WorkspaceNote']['workspace_id'];
            //             }
            // }


            $model->workspace_qtn_id = $_POST['WorkspaceNote']['workspace_qtn_id'];


            if (!empty($_POST['WorkspaceNote']['due_date'])) {

                $due_date_array = explode("/", $_POST['WorkspaceNote']['due_date']);
                $model->due_date = $due_date_array[2] . "-" . $due_date_array[1] . "-" . $due_date_array[0];
            }
//            /due_date
            if ($model->save()) {


                $jsonData['status'] = 'success';
                $jsonData['item'] = array(
                    'id' => $model->id,
                    'title' => $model->title,
                    'workspace_id' => $model->workspace_id,
                    'customer_id' => $model->customer_id,
                    'amount' => $model->amount,
                    'shared_to' => $model->shared_to,
                    'lead_id' => $model->lead_id,
                    'file_id' => $models->file_id,
                    'tooltip' => $model->getToolTip()
                );
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
            //}
        }
    }

    // ----------------------------------------------

    public function actionSave()
    {
        $validate = true;
        $valid1 = true;

        

        $passfrom = Yii::app()->request->getParam('passfrom');

       
        



        $model = new WorkspaceNote();
        if (isset($_POST['WorkspaceNote'])) {
            if ((int)@$_POST['WorkspaceNote']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int)@$_POST['WorkspaceNote']['id'];
                $model = $model->findByPk($id);

            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $model->shared_to = Yii::app()->user->id;
            }


            $model->attributes = $_POST['WorkspaceNote'];
            $model->status = $_POST['WorkspaceNote']['status'];
            $model->customer_id = $_POST['WorkspaceNote']['customer_id'];
            //$model->lead_id = $_POST['WorkspaceNote']['lead_id'];
            //   $model->isApproved = 'Y';
            $model->workspace_qtn_id = $_POST['WorkspaceNote']['workspace_qtn_id'];
            $validate = $model->validate();

            if ($model->save()) {
// -----------add-lead---------------

                if ($_POST['WorkspaceNote']['file_id'] != '') {
                    $model_MasterFile = MasterFile::model()->find(array('condition' => 'id=' . $_POST['WorkspaceNote']['file_id']));
                }
                $modelMaster = new MasterFile();


                if ((int)@$_POST['WorkspaceNote']['file_id'] > 0 && $model_MasterFile != '') {


                    $id = $_POST['WorkspaceNote']['file_id'];

                    if ($id != '') {

                        $modelMaster = $modelMaster->findByPk($id);
                    }
                    // if(!empty($modelMaster)){
                    //     $modelMaster = $modelMaster->findByPk($id);

                    // }else{
                    //     $valid1 = false;
                    //     $other[] = 'not';
                    // }
                } else {
                    $modelMaster->customer_id = $_POST['WorkspaceNote']['customer_id'];
                    $modelMaster->current_process_status = "L";
                    $modelMaster->crm_user_id = Yii::app()->user->id;
                    $modelMaster->file_title = $_POST['Lead']['title'];
                    $modelMaster->lead_owner_id = $_POST['Lead']['lead_owner_id'];
                }


                if ($modelMaster->save(false)) {
                    $modelLead = new Lead();


                    if ((int)@$_POST['WorkspaceNote']['lead_id'] > 0) {

                        $modelLead->id = (int)$_POST['WorkspaceNote']['lead_id'];
                        $modelLead->file_id = (int)$_POST['WorkspaceNote']['file_id'];
                        $modelLead->updated_by = Yii::app()->user->id;
                        $modelLead->updated_datetime = date('Y-m-d h:i:s');
                        $modelLead = $modelLead->findByPK($modelLead->id);
                    } else {
                        $modelLead->crm_user_id = Yii::app()->user->id;
                        $modelLead->created_by = Yii::app()->user->id;
                        $modelLead->created_datetime = date('Y-m-d h:i:s');
                        $modelLead->file_id = $modelMaster->id;
                    }

                    // $modelLead->crm_user_id = Yii::app()->user->id;
                    // $modelLead->created_by = Yii::app()->user->id;
                    // $modelLead->created_datetime = date('Y-m-d h:i:s');
                   
                    // if($passfrom == 'cust_page' && $passfrom!=''){
                    //     $modelLead->isApproved = 'N';
                    // }else{
                    //     $modelLead->isApproved = 'Y';
                    // }

                    $modelLead->workspace_note_id = $model->id;
                    $modelLead->customer_id = $model->customer_id;

                    $modelCustomerContact = new CustomerContact();

                    $conditioncont = 'isActive=  "Y"';
                    $conditioncont .= ' and customer_id=' . $model->customer_id;
                    $modelCustomerContact = $modelCustomerContact->findAll(array('condition' => $conditioncont));

                    if (!empty($modelCustomerContact[0])) {
                        // $modelLead->contact_id = $modelCustomerContact[0]->id;
                        // $modelLead->mobile1 = $modelCustomerContact[0]->contact_mobile_no;
                        // $modelLead->email1 = $modelCustomerContact[0]->contact_email_id;
                    }


                    $modelLead->value = $model->amount;
                    $modelLead->lead_owner_id = $model->through_id;
                    $modelLead->sales_group_id = $model->sales_group_id;
                    $modelLead->currency = '23'; //AED defult
                    $modelLead->status = 'O'; //open defult
                    $modelLead->remarks = $_POST['WorkspaceNote']['description'];
                    $modelLead->enq_date = date('Y-m-d');

                    if (!empty($_POST['WorkspaceNote']['due_date'])) {

                        $due_date_array = explode("/", $_POST['WorkspaceNote']['due_date']);
                        $modelLead->closing_date = $due_date_array[2] . "-" . $due_date_array[1] . "-" . $due_date_array[0];
                    }


                    if (!empty($_POST['WorkspaceNote']['file_id'])) {
                        $modelLead->file_id = $_POST['WorkspaceNote']['file_id'];
                    }
                    $modelLead->save(false);
                }


// --------------------------------
                $jsonData['status'] = 'success';
                $jsonData['item'] = array(
                    'id' => $model->id,
                    'title' => $model->title,
                    'workspace_id' => $model->workspace_id,
                    'customer_id' => $model->customer_id,
                    'amount' => $model->amount,
                    'shared_to' => $model->shared_to,
                    'lead_id' => $model->lead_id,
                    'file_id' => $models->file_id,
                    'tooltip' => $model->getToolTip()
                );
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;


                // $error1 = json_decode(CActiveForm::validate($model, '', false), true);

                // $error = CJSON::encode(array_merge_recursive($error1, $other));
                // if ($error != '[]') {
                //     echo $error;
                // }
            }

        }
    }

    // ------------------------------------------------


    public function actiongetlist1()
    {
        $condition = " 1 = 1";
        $user_id = Yii::app()->user->id;
        if ((Yii::app()->user->authorised_user != 1) && (Yii::app()->user->havePermissionOn['workspace_view_all'] != 1)) {
            //    $condition .= " AND FIND_IN_SET( {$user_id}, shared_to)";
            //$condition.=" AND created_by=".Yii::app()->user->id;
            $condition .= " AND (t.created_by=" . Yii::app()->user->id . " OR t.through_id=" . Yii::app()->user->id . ")";
        }
        if (isset($_REQUEST['through_id']) && !empty($_REQUEST['through_id'])) {
            $condition .= " AND t.through_id =" . $_REQUEST['through_id'];
        }
        if (isset($_REQUEST['group_id']) && !empty($_REQUEST['group_id'])) {
            $condition .= " AND t.sales_group_id =" . $_REQUEST['group_id'];
        }
        if (isset($_REQUEST['from_date']) && !empty($_REQUEST['from_date'])) {
            $date = explode("/", $_REQUEST['from_date']);
            $from_date = $date[2] . "-" . $date[1] . '-' . $date[0];
            // $condition .= " and date(created_date_time) >= '{$from_date}'  ";
        }
        if (isset($_REQUEST['to_date']) && !empty($_REQUEST['to_date'])) {
            $date = explode("/", $_REQUEST['to_date']);
            $to_date = $date[2] . "-" . $date[1] . '-' . $date[0];
            // $condition .= " and date(created_date_time) <= '{$to_date}'  ";
        }
        if (isset($_REQUEST['search_word']) && !empty($_REQUEST['search_word'])) {
            $searchString = $_REQUEST['search_word'];
            $condition .= " AND (customer.customer_name LIKE '%" . $searchString . "%')";
        }
        $models = WorkspaceNote::model()->with('customer')->findAll(array(
            'condition' => $condition, 'order' => 't.created_date_time DESC'
        ));
        $user_list = $this->getUser();

        $data = array();
        foreach ($models as $value) {
            $shared_to = [];
            $_temp_arr = explode(",", $value->shared_to);
            foreach ($_temp_arr as $each_user) {
                if (!empty($each_user)) {
                    $shared_to[] = array(
                        'id' => $each_user,
                        'name' => $user_list[$each_user]
                    );
                }
            }
            $tit_name = substr($value->title, 0, 17);
            if (strlen($value->title) > 17) {
                $tit_name .= '..';
            }
            $title = "<ul class='label-list'><li>" . $tit_name . "</li>";


            if (!empty($value->group)) {
                $title .= "<li style='font-weight:400'>" . substr($value->group->group_name, 0, 30) . "</li>";
            }
            $title .= "<li style='text-align:end'>" . number_format($value->amount, 2) . "</li>";
            if (!empty($value->through)) {
                $title .= "<li style='font-weight:400' >" . $value->through->fullname . "</li>";
            }

            if (!empty($value->created_date_time)) {

                $title .= "<li style='font-weight:400;font-size:12px' >" . date("d/m/Y", strtotime($value->created_date_time)) . "</li>";
            }

            //color added by nisha
            $modelColor = Workspace::model()->findByPk($value->workspace_id);
            $modelCustomer = Customer::model()->findByPk($value->customer_id);
            $modelLead = Lead::model()->find(array('condition' => 'workspace_note_id=' . $value->id));
            if (!empty($modelLead->file_id)) {
                $model_Quotes = Quotes::model()->find(array('condition' => 'file_id=' . $modelLead->file_id));
            }


            if (!empty($value->created_date_time)) {
                $created_date = date("d/m/Y", strtotime($value->created_date_time));
            } else {
                $created_date = '00/0/0000';

            }


            $title .= "</ul>";
            $data[] = array(
                'workspace_created_date' => $created_date,
                'workspace_id' => $value->workspace_id,
                'quotes_id' => $model_Quotes->id,
                'title' => $title,
                'status' => $value->status,
                'customer_id' => $value->customer_id,
                'customer_name' => $modelCustomer->customer_name,
                'lead_id' => $modelLead->file_id,
                'file_id' => $models->file_id,
                'amount' => $value->amount,
                'id' => $value->id,
                'bgcolor' => $modelColor->bg_color_code,
                // 'tooltip' => $value->getToolTip(),
                'shared_to' => $shared_to
            );
        }
        echo json_encode($data);
    }
public function actiongetlist()
    {
        $condition = " 1 = 1";
        $condition .= ' AND  t.isActive= "Y" AND (file.current_process_status="L")  AND t.lead_type="sale"';
        $user_id = Yii::app()->user->id;
        // if ((Yii::app()->user->authorised_user != 1) && (Yii::app()->user->havePermissionOn['workspace_view_all'] != 1)) {
        //     //    $condition .= " AND FIND_IN_SET( {$user_id}, shared_to)";
        //     //$condition.=" AND created_by=".Yii::app()->user->id;
        //     $condition .= " AND (t.created_by=" . Yii::app()->user->id . " OR t.through_id=" . Yii::app()->user->id . ")";
        // }
        // if (isset($_REQUEST['through_id']) && !empty($_REQUEST['through_id'])) {
        //     $condition .= " AND t.through_id =" . $_REQUEST['through_id'];
        // }
        // if (isset($_REQUEST['group_id']) && !empty($_REQUEST['group_id'])) {
        //     $condition .= " AND t.sales_group_id =" . $_REQUEST['group_id'];
        // }
        // if (isset($_REQUEST['from_date']) && !empty($_REQUEST['from_date'])) {
        //     $date = explode("/", $_REQUEST['from_date']);
        //     $from_date = $date[2] . "-" . $date[1] . '-' . $date[0];
        //     // $condition .= " and date(created_date_time) >= '{$from_date}'  ";
        // }
        // if (isset($_REQUEST['to_date']) && !empty($_REQUEST['to_date'])) {
        //     $date = explode("/", $_REQUEST['to_date']);
        //     $to_date = $date[2] . "-" . $date[1] . '-' . $date[0];
        //     // $condition .= " and date(created_date_time) <= '{$to_date}'  ";
        // }
        // if (isset($_REQUEST['search_word']) && !empty($_REQUEST['search_word'])) {
        //     $searchString = $_REQUEST['search_word'];
        //     $condition .= " AND (customer.customer_name LIKE '%" . $searchString . "%')";
        // }
        $models = Lead::model()->with('customer','file')->findAll(array(
            'condition' => $condition, 'order' => 't.created_datetime DESC'
        ));
        $user_list = $this->getUser();

        $data = array();
        foreach ($models as $value) {
            $shared_to = [];
            $_temp_arr = explode(",", $value->created_by);
            foreach ($_temp_arr as $each_user) {
                if (!empty($each_user)) {
                    $shared_to[] = array(
                        'id' => $each_user,
                        'name' => $user_list[$each_user]
                    );
                }
            }
            $tit_name = substr($value->customer->customer_name, 0, 17);
            if (strlen($value->customer->customer_name) > 100) {
                $tit_name .= '..';
            }
            $title = "<ul class='label-list'><li>" . $tit_name . "</li>";


            if (!empty($value->salesgroup)) {
                $title .= "<li style='font-weight:400'>" . substr($value->salesgroup->group_name, 0, 30) . "</li>";
            }
            $title .= "<li style='text-align:end'>" . number_format($value->value, 2) . "</li>";
            if (!empty($value->lead_owner_id)) {
                $title .= "<li style='font-weight:400' >" . $value->leadowner->fullname . "</li>";
            }

            if (!empty($value->created_datetime)) {

                $title .= "<li style='font-weight:400;font-size:12px' >" . date("d/m/Y", strtotime($value->created_datetime)) . "</li>";
            }

             $modelSpaceNote =  WorkspaceNote::model()->find(array('condition' => 'lead_id=' . $value->id));
            $note_id = 0;
            $space_id = 1;
            if(!empty($modelSpaceNote))
            {
            $note_id= $modelSpaceNote->id;
            $modelColor =  Workspace::model()->findByPk($modelSpaceNote->workspace_id);
            }
            
            $modelCustomer = Customer::model()->findByPk($value->customer_id);
           
           // $modelLead = Lead::model()->find(array('condition' => 'workspace_note_id=' . $value->id));
            if (!empty($value->file_id)) {
                $model_Quotes = Quotes::model()->find(array('condition' => 'file_id=' . $value->file_id));
            }


            if (!empty($value->created_datetime)) {
                $created_date = date("d/m/Y", strtotime($value->created_datetime));
            } else {
                $created_date = '00/0/0000';

            }


            $title .= "</ul>";
            $data[] = array(
                'workspace_created_date' => $created_date,
                'workspace_id' => 1,// '',//$value->workspace_id,
                'quotes_id' => $model_Quotes->id,
                'title' => $title,
                'status' => "N",//$value->status,
                'customer_id' => $value->customer_id,
                'customer_name' => $value->customer->customer_name,
                'lead_id' => $value->id,
                'file_id' => $value->file_id,
                'amount' => $value->value,
                'id' => $note_id,
                'bgcolor' => $modelColor->bg_color_code,
                // 'tooltip' => $value->getToolTip(),
                'shared_to' => $shared_to
            );
        }
        echo json_encode($data);
    }

    public function actionUpdateWorkspace()
    {

        $workspace_id = (int)Yii::app()->request->getParam('workspace_id');


        $workspace_qtn_id = $_POST['WorkspaceQtns']['details'];


        $previousWorkSpace_id = 0;
        if ($workspace_id > 0) {
            $item_id = (int)Yii::app()->request->getParam('item_id');
            $model = WorkspaceNote::model()->findByPk($item_id);
            $previousWorkSpace_id = $model->workspace_id;
            $model->workspace_id = $workspace_id;
            $model->workspace_qtn_id = $workspace_qtn_id;
            $model->save();
            echo json_encode(array('status' => 'success', 'prev' => $previousWorkSpace_id));
        } else {
            echo json_encode(array('status' => 'failed'));
        }
    }

    public function actiondeleteItem()
    {

        $item_id = (int)Yii::app()->request->getParam('id');
        WorkspaceNote::model()->deleteByPk($item_id);
        echo json_encode(array('status' => 'success', 'id' => $item_id));
    }

    public function actionshareItem()
    {
        $item_id = (int)Yii::app()->request->getParam('id');
        $user_id = (int)Yii::app()->request->getParam('user_id');
        $model = WorkspaceNote::model()->findByPk($item_id);
        $user_list = $this->getUser();

        $_temp_arr = explode(",", $model->shared_to);
        $_temp_arr[] = $user_id;
        $_temp_arr = array_unique($_temp_arr);

        $model->shared_to = implode(",", $_temp_arr);
        $model->save();
        $_temp_arr = explode(",", $model->shared_to);
        foreach ($_temp_arr as $each_user) {
            if (!empty($each_user)) {
                $shared_to[] = array(
                    'id' => $each_user,
                    'name' => $user_list[$each_user]
                );
            }
        }
        $data = array(
            'workspace_id' => $model->workspace_id,

            'title' => $model->title,
            'lead_id' => $model->lead_id,
            'file_id' => $models->file_id,
            'id' => $model->id,
            'tooltip' => $model->getToolTip(),
            'shared_to' => $shared_to
        );
        echo json_encode(array('status' => 'success', 'item' => $data));
    }

    function getUser()
    {

        $model = User::getUserModels();
        $array = [];
        foreach ($model as $value) {
            $array[$value->id] = $value->getAvatar();
        }
        return $array;
    }

    public function actiondeleteshareItem()
    {
        $item_id = (int)Yii::app()->request->getParam('id');
        $user_id = (int)Yii::app()->request->getParam('user_id');
        $model = WorkspaceNote::model()->findByPk($item_id);

        $share_to = $model->shared_to;
        $share_to = str_replace($user_id, "", $share_to);
        $_temp_arr = explode(",", $share_to);

        $_temp_arr = array_unique($_temp_arr);

        $model->shared_to = implode(",", $_temp_arr);
        $model->save();

        echo json_encode(array('status' => 'success',));
    }

    public function actionViewall()
    {
        $ws_id = (int)Yii::app()->request->getParam('ws_id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('view_all', array('ws_id' => $ws_id), false, false);
    }

    /* code updated by nisha 06-07-2022*/
    public function actionProspectadd()
    {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $status = array();
        $drop = '';
        if ($name != '') {
            $model = new Customer();
            $model->customer_name = $name;
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->lead_owner_id = Yii::app()->user->id;;
            $model->isProspect = 'Y';
            $model->customer_phone_no = 0;
            $model->customer_payment_term = 0;
            $model->customer_currency_id = 0;
            $model->customer_country = 0;
            if ($model->save()) {
                $status['status'] = "success";
                $field_name = 'title';
                $data = Customer::getCustomers();
                $modelwork = new WorkspaceNote;
                $modelwork->$field_name = $model->customer_name;
                // $drop=CHtml::activedropDownList($modelwork,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Customer'));
                $drop = CHtml::activeTextField($modelwork, 'title', array('data-label' => 'Customer/Prospect', 'onKeyup' => 'js:autoCompleteCustomers(this.id,"lead");', 'data-search' => true));
                $status['drop'] = $drop;
                $status['customer_id'] = $model->id;
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGetSummary()
    {
        $ws_id = (int)Yii::app()->request->getParam('ws_id');
        $customer_id = (int)Yii::app()->request->getParam('customer_id');
        $modelWorkSpace = WorkspaceNote::model()->findByPk($ws_id);


        $this->render('summary_details', array('ws_id' => $ws_id, 'customer_id' => $customer_id, 'model' => $modelWorkSpace), false, false);
    }

    public function actionGetSummaryDetails()
    {
        $ws_id = (int)Yii::app()->request->getParam('ws_id');
        $customer_id = (int)Yii::app()->request->getParam('customer_id');
        $start_date = Yii::app()->request->getParam('start_date');
        $start_date = str_replace('/', '-', $start_date);
        $start_date = date("Y-m-d", strtotime($start_date));
        $this->render('activity_summary_details', array('ws_id' => $ws_id, 'customer_id' => $customer_id, 'start_date' => $start_date), false, false);
    }

    public function actionChangeworkspace()
    {

        $model = new WorkspaceQtns();
        $workspace_id = Yii::app()->request->getParam('workspace_id');
        $item_id = Yii::app()->request->getParam('item_id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        //    $this->render('changeworkspace', array('model'=>$model,'workspace_id ' => $workspace_id,'item_id'=>$item_id), false, false);

        //    Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);


        $this->render('changeworkspace', array('workspace_id' => $workspace_id, 'item_id' => $item_id, 'model' => $model), false, false);


    }


    public
    function actionGetWorkspaceQtns()
    {
        $Workspace_id = Yii::app()->request->getparam("Workspace_id");
        $models = WorkspaceQtns::getAllWorkspaceQtns($Workspace_id);
        $model = new WorkspaceQtns;
        $drop = CHtml::activedropDownList($model, 'details', $models, array('empty' => 'Select', 'class' => 'tooltipster', 'title' => 'Workspace Qtn', 'data-label' => 'Workspace Qtn <span style="color:red">*</span>', 'data-search' => true, 'empty' => '-select-'));
        $status = array("dt" => $drop);
        echo CJSON::encode($status);
    }

    public
    function actionCheckQtnexist()
    {

        $item_id = Yii::app()->request->getParam('item_id');


        $id = (int)Yii::app()->request->getParam('id');
        $lead_id = (int)Yii::app()->request->getParam('lead_id');
        if ($item_id > 0) {


            $modelWorkspaceNote = new WorkspaceNote();
            $modelWorkspaceNote = $modelWorkspaceNote->findByPk($item_id);


            if ($modelWorkspaceNote->workspace_id == '8') {

                echo json_encode('3');
            } else {

                $workspace_id = Yii::app()->request->getParam('workspace_id');

                $models = WorkspaceQtns::getAllWorkspaceQtns($workspace_id);


                if (!empty($models)) {

                    echo json_encode('1');

                } else {

                    echo json_encode('2');

                }

            }


        }


    }

    //indhu 10 08 2022
    public function actioninfo()
    {
//indhu 16_08_2022
        $frm = Yii::app()->request->getParam('frm');

        $ws_id = (int)Yii::app()->request->getParam('ws_id');
        $customer_id = (int)Yii::app()->request->getParam('customer_id');
        $modelWorkSpace = WorkspaceNote::model()->findByPk($ws_id);
        $this->render('info', array('frm' => $frm, 'ws_id' => $ws_id, 'customer_id' => $customer_id, 'model' => $modelWorkSpace), false, false);
    }

    

    public function actionInfograph()
    {
        //indhu 
        $this->renderPartial('info_graph', $_POST);
    }

    public function actionCreateActivity()
    {


        $model = new Activity();
        date_default_timezone_set("Asia/Dubai");
        $id = (int)Yii::app()->request->getParam('id');
        $added_from = Yii::app()->request->getParam('frm');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $header_id = (int)Yii::app()->request->getParam('header_id');
        $file_id = (int)Yii::app()->request->getParam('file_id');
        $edit_from = Yii::app()->request->getParam('edit_from');
        $mode = Yii::app()->request->getParam('mode');
        $type = Yii::app()->request->getParam('type');

        $model->header_id = (int)$header_id;
        $model->file_id = (int)$file_id;
        $model->customer_id = $customer_id;
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model->customer_name = $model->customer_name;
        }
        $model->added_from = $added_from;


        /* if($added_from=='TA'){
             $type_of_activity ="T";
         }
         if(!empty($type_of_activity)){
             $model->type_of_activity = $type_of_activity;
         }*/

        if (!empty($added_from)) {
            $header_added_from = ActivityMasAddedFrom::getActivityFromByCode($added_from);
        }


        if ($added_from == 'LE' || $edit_from == 'LE') {
            $modelLead = Lead::model()->findByPk($header_id);

            $model->customer_name = $modelLead->customer_name;
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_activity', array('model' => $model, 'header_added_from' => $header_added_from, 'edit_from' => $edit_from, 'mode' => $mode, 'type' => $type, 'file_id' => $file_id));
    }

    public function actionSaveActivity16_08_2022()
    {


        $modelActivity = new Activity();
        date_default_timezone_set("Asia/Dubai");
        $id = $_POST['Activity']['id'];
        $flag = 0;
        if ($id > 0) {
            $modelActivity = $modelActivity->findByPk($id);

            if ($modelActivity->notes == $_POST['Activity']['notes']) {
                $flag = 1;
            }

            $audit_type = 'UPDATED';
        } else {
            $audit_type = 'CREATED';
        }
        $modelActivity->attributes = $_POST['Activity'];
        $modelActivity->task_status = '1';


        if ($modelActivity->validate()) {

            $customer_name = $_POST['Activity']['customer_name'];
            if (empty($customer_name) && (int)$_POST['Activity']['customer_id'] > 0) {
                $modelCustomer = new Customer();
                $arr_customer = $modelCustomer->findByPk((int)$_POST['Activity']['customer_id']);
                $customer_name = $arr_customer->customer_name;
            }

            if (!empty($_POST['Activity']['task_date_time'])) {
                $modelActivity->task_date_time = str_replace('/', '-', $_POST['Activity']['task_date_time']);
                $modelActivity->task_date_time = date("Y-m-d H:i:s", strtotime($modelActivity->task_date_time));
            } else {
                $modelActivity->task_date_time = date("Y-m-d H:i:s");
            }

            if (!empty($_POST['Activity']['deadline_date_time'])) {
                $modelActivity->deadline_date_time = str_replace('/', '-', $_POST['Activity']['deadline_date_time']);
                $modelActivity->deadline_date_time = date("Y-m-d H:i:s", strtotime($modelActivity->deadline_date_time));
            } else {
                $modelActivity->deadline_date_time = "0000-00-00 00:00:00";
            }

            $modelActivity->customer_id = $_POST['Activity']['customer_id'];
            $modelActivity->customer_name = $customer_name;
            $modelActivity->header_id = $_POST['Activity']['header_id'];
            $modelActivity->file_id = $_POST['Activity']['file_id'];
            $modelActivity->task_type = $_POST['Activity']['task_type'];
            // $modelActivity->task_status                 = $_POST['Activity']['task_status'];
            $modelActivity->task_status = '1';


            $modelActivity->assigned_from = $_POST['Activity']['assigned_from'];
            $modelActivity->assigned_to = $_POST['Activity']['assigned_to'];
            $modelActivity->task_sub_type = $_POST['Activity']['task_sub_type'];
            $modelActivity->isActive = "Y";
            $modelActivity->created_by = Yii::app()->user->id;
            $modelActivity->updated_by = 0;
            $modelActivity->created_date_time = date("Y-m-d H:i:s");
            $modelActivity->updated_date_time = "0000-00-00 00:00:00";
            $modelActivity->added_from = $_POST['Activity']['added_from'];
            $modelActivity->header_id = (int)$_POST['Activity']['header_id'];
            $modelActivity->save(false);


            if ($_POST['Activity']['notes'] != "" && $flag == 0) {

                $modelActivityNotesHistory = new ActivityNotesHistory();
                $modelActivityNotesHistory->activity_id = $modelActivity->id;
                $modelActivityNotesHistory->activity_notes = $_POST['Activity']['notes'];
                $modelActivityNotesHistory->created_by = Yii::app()->user->id;
                $modelActivityNotesHistory->created_date_time = date("Y-m-d H:i:s");
                $modelActivityNotesHistory->task_date_time = $modelActivity->task_date_time;
                $modelActivityNotesHistory->deadline_date_time = $modelActivity->deadline_date_time;
                $modelActivityNotesHistory->save(false);
            }
            //  echo "success";


            echo CJSON::encode(array('status' => 'success'));

        } else {

            //   echo CJSON::encode( array('status' => 'false') );


            $error = CActiveForm::validate($modelActivity, '', false);
            if ($error != '[]') {
                echo $error;
            }
        }
    }


    public function actionSaveActivity()
    {


        $modelActivity = new Activity();
        date_default_timezone_set("Asia/Dubai");
        $id = $_POST['Activity']['id'];
        $flag = 0;
        if ($id > 0) {
            $modelActivity = $modelActivity->findByPk($id);

            if ($modelActivity->notes == $_POST['Activity']['notes']) {
                $flag = 1;
            }

            $audit_type = 'UPDATED';
        } else {
            $audit_type = 'CREATED';
        }
        $modelActivity->attributes = $_POST['Activity'];
        $modelActivity->task_status = '1';


        if ($modelActivity->validate()) {

            $customer_name = $_POST['Activity']['customer_name'];
            if (empty($customer_name) && (int)$_POST['Activity']['customer_id'] > 0) {
                $modelCustomer = new Customer();
                $arr_customer = $modelCustomer->findByPk((int)$_POST['Activity']['customer_id']);
                $customer_name = $arr_customer->customer_name;
            }

            if (!empty($_POST['Activity']['task_date_time'])) {
                $modelActivity->task_date_time = str_replace('/', '-', $_POST['Activity']['task_date_time']);
                $modelActivity->task_date_time = date("Y-m-d H:i:s", strtotime($modelActivity->task_date_time));
            } else {
                $modelActivity->task_date_time = date("Y-m-d H:i:s");
            }

            if (!empty($_POST['Activity']['deadline_date_time'])) {
                $modelActivity->deadline_date_time = str_replace('/', '-', $_POST['Activity']['deadline_date_time']);
                $modelActivity->deadline_date_time = date("Y-m-d H:i:s", strtotime($modelActivity->deadline_date_time));
            } else {
                $modelActivity->deadline_date_time = "0000-00-00 00:00:00";
            }

            $modelActivity->customer_id = $_POST['Activity']['customer_id'];
            $modelActivity->customer_name = $customer_name;
            $modelActivity->header_id = $_POST['Activity']['header_id'];
            $modelActivity->file_id = $_POST['Activity']['file_id'];
            $modelActivity->task_type = $_POST['Activity']['task_type'];
            // $modelActivity->task_status                 = $_POST['Activity']['task_status'];
            $modelActivity->task_status = '1';


            $modelActivity->assigned_from = $_POST['Activity']['assigned_from'];
            $modelActivity->assigned_to = $_POST['Activity']['assigned_to'];
            $modelActivity->task_sub_type = $_POST['Activity']['task_sub_type'];
            $modelActivity->isActive = "Y";
            $modelActivity->created_by = Yii::app()->user->id;
            $modelActivity->updated_by = 0;
            $modelActivity->created_date_time = date("Y-m-d H:i:s");
            $modelActivity->updated_date_time = "0000-00-00 00:00:00";
            $modelActivity->added_from = $_POST['Activity']['added_from'];
            $modelActivity->header_id = (int)$_POST['Activity']['header_id'];
            $modelActivity->save(false);


            if ($_POST['Activity']['notes'] != "" && $flag == 0) {

               

                $modelActivityNotesHistory = new ActivityNotesHistory();
                $modelActivityNotesHistory->activity_id = $modelActivity->id;
                $modelActivityNotesHistory->activity_notes = $_POST['Activity']['notes'];
                $modelActivityNotesHistory->created_by = Yii::app()->user->id;
                $modelActivityNotesHistory->created_date_time = date("Y-m-d H:i:s");
                $modelActivityNotesHistory->task_date_time = $modelActivity->task_date_time;
                $modelActivityNotesHistory->deadline_date_time = $modelActivity->deadline_date_time;

             
                $modelActivityNotesHistory->save(false);
            }

        //indhu 16_08_2022
            //  --------table1-----------------------

            $types = '<table class="alert alert-success table table-hover table-bordered personal-task" id="tbl_customer_contact"  style="font-size:13px;">
                                    <thead>
                                        <tr>
                                        <th>No</th>
                                        <th>Ref#</th>
                                        <th>Type</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th>Assigned To</th>
                                        <th>Deadline Date</th>
                                        <th>Notes</th>
                                        </tr>
                                    </thead>';
            if (!empty($_POST['Activity']['customer_id'])) {

                $model = new Activity();
                //$condition = 't.isActive="Y"  AND  customer.id = ' . $id;
                $condition = 't.isActive="Y"';

                if ($_POST['Activity']['customer_id'] > 0) {
                    $condition .= ' AND t.customer_id=' . $_POST['Activity']['customer_id'];
                }
                $activity_list = $model->with('taskstatus', 'tasktype', 'customer')->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
                if (!empty($activity_list)) {
                    foreach ($activity_list as $key => $activity) {
                        $display_added_from = ActivityMasAddedFrom::getActivityFromByCode($activity['added_from']);
                        $i++;
                        $added_from = 'WS';
                        $mode = '';
                        $types .= '<tr>
                          
                            <td>' . $i . '</td>
                            <td>' . $activity['header_id'] . '</td>
                             <td>' .$activity['tasktype']['type'] . '</td>
                             <td>' . $activity['taskstatus']['status'] . '</td>
                             <td>' . date('d/m/Y h:i a', strtotime($activity['task_date_time'])) . '</td>
                             <td>' .$activity['assignedTo']['fullName'] . '</td>
                             <td>' . date('d/m/Y h:i a', strtotime($activity['deadline_date_time'])). '</td>
                             <td>' . $activity['notes']. '</td>
                        </tr>';
                    }
                } else {
                    $types .= '<tr><td colspan="12">No Records Found</td></tr>';
                }
            } else {
                $types.= '<tr><td colspan="12">No Records Found</td></tr>';
            }

            $types .= '</table>';


//            --------------table2----------------
    $array_table2= array();
            $customer_id = $_POST['Activity']['customer_id'];

            $SQL = "SELECT COUNT(*) AS activity_count,task_type,activity_type,activity_id,activity_type_icon,MAX(task_date_time) AS last_date FROM `view_activity_details`
WHERE  `customer_id` = $customer_id GROUP BY task_type     ";
            $modelarrayactivity_type = Yii::app()->db->createCommand($SQL)->queryAll();

        
       
            foreach ($modelarrayactivity_type as $key => $count_details) {
                $modelActivityHistory = new ActivityNotesHistory();
                $modelActivityHistory = $modelActivityHistory->findAll(array('condition' => 'activity_id=' . (int)$modelarrayactivity_type[$key]['activity_id'], 'order' => 'id DESC'));

                $types1 ='<div class="col-lg-6 col-sm-6 ">              
                 <table class="alert alert-success table table-hover table-bordered personal-task" id="tbl_customer_contact"  style="font-size:13px;">
                                  
                                  	<thead>
				<tr>
					<th colspan="5"><span
								style="background-color: orange;color:white;width:250px;text-align:center;border-radius:5px;"><b>'. $modelarrayactivity_type[$key]['activity_type'] .'  List</b></span>
					</th>
				</tr>
				<tr>
					<th width="5%">No</th>
					<th width="30%">Notes</th>
					<th width="10%">Created By</th>
					<th width="13%">Task Date/Time</th>
					<th width="13%">Deadline Date/Time</th>
				</tr>
				</thead>
				';
                    foreach ($modelActivityHistory as $i => $eachActivityHistory) {
                        $i++;
                          $types1 .= '<tr>
                            <td>' . $i . '</td>
                            <td>' . $eachActivityHistory['activity_notes'] . '</td>
                            <td>' .  $eachActivityHistory->createdby->fullName . '</td>
                            <td>' . date("d/m/Y h:i a", strtotime($eachActivityHistory->task_date_time)) . '</td>
                            <td>' . date("d/m/Y h:i a", strtotime($eachActivityHistory->deadline_date_time)) . '</td>
                        </tr>';
                    }

                
                $types1 .= '</table>';
                $types1 .= '</div>';
                array_push($array_table2 , $types1);
            }
          
            

           
            //  -------------------------------

            $data = array(
                'types' => $types,
                'types1' => $array_table2,
                'status' => 'success'
            );
            echo json_encode($data);
            
        }


//            $jsonData['status'] = 'success';
//            echo CJSON::encode($jsonData);

            //  echo CJSON::encode(array('status' => 'success'));


        else {

                //   echo CJSON::encode( array('status' => 'false') );


                $error = CActiveForm::validate($modelActivity, '', false);
                if ($error != '[]') {
                    echo $error;
                }
            }


        }


    }
