<?php

class PurchaseSpaceController extends Controller
{
	public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetRequisitionList'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

	public function actionIndex()
	{
		$this->render('index');
	}

	public function actionGetRequisitionList()
    {
		$workspaceIdRequisition = 9;
		$workspaceIdPurchaseEnquiry = 11;
		$workspaceIdPurchaseOrder = 14;
		$workspaceIdMaterialReceipt = 16;
		$workspaceIdQualityCheck = 17;
		$workspaceIdPurchaseInvoice = 18;
		$workspaceIdPurchaseReturn = 19;
        $model = new PurchasingRequisition();
        $condition = 't.isActive="Y" AND t.convert_status!="0"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "t.isActive='Y' AND  (t.file_title LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%' OR t.requisition_date LIKE '%" . $searchString . "%' OR t.required_date LIKE '%" . $searchString . "%')";
        }
        $model = $model->findAll(array('condition' => $condition, 'order' => 'id DESC'));
		$user_list = $this->getUser();
        $rowData = array();
        foreach ($model as $x => $row) {
            $req_date = date("d/m/Y", strtotime($row->requisition_date));
            $required_date = date("d/m/Y", strtotime($row->required_date));
            // $chk = '';

            // if ($row['convert_status'] != "0") {
            //     $state = "Active";
            // } else {
            //     $state = "Closed";
            // }
            
            // $is_approved = MasterFile::model()->findByPk($row['file_id'])->is_approved;
            // $rowData[] = array('<div class="text-center">' . $chk . '</div>', $row['id'], $req_date, $required_date, $row['reference'], $state, $row['convert_status'], $row['status'], $is_approved, $row['file_id']);

			// $data['data'] = $rowData;

			/*$shared_to = [];
            $_temp_arr = explode(",", $value->created_by);
            foreach ($_temp_arr as $each_user) {
                if (!empty($each_user)) {
                    $shared_to[] = array(
                        'id' => $each_user,
                        'name' => $user_list[$each_user]
                    );
                }
            }
            $tit_name = substr($value->customer->customer_name, 0, 17);
            if (strlen($value->customer->customer_name) > 100) {
                $tit_name .= '..';
            }
            $title = "<ul class='label-list'><li>" . $tit_name . "</li>";


            if (!empty($value->salesgroup)) {
                $title .= "<li style='font-weight:400'>" . substr($value->salesgroup->group_name, 0, 30) . "</li>";
            }
            $title .= "<li style='text-align:end'>" . number_format($value->value, 2) . "</li>";
            if (!empty($value->lead_owner_id)) {
                $title .= "<li style='font-weight:400' >" . $value->leadowner->fullname . "</li>";
            }

            if (!empty($value->created_datetime)) {

                $title .= "<li style='font-weight:400;font-size:12px' >" . date("d/m/Y", strtotime($value->created_datetime)) . "</li>";
            }

            $modelSpaceNote = WorkspaceNote::model()->find(array('condition' => 'lead_id=' . $value->id));
            $note_id = 0;
            $space_id = 1;
            if (!empty($modelSpaceNote)) {
                $note_id = $modelSpaceNote->id;
                $space_id = $modelSpaceNote->workspace_id;
                $modelColor = Workspace::model()->findByPk($modelSpaceNote->workspace_id);
            }

            $modelCustomer = Customer::model()->findByPk($value->customer_id);

            // $modelLead = Lead::model()->find(array('condition' => 'workspace_note_id=' . $value->id));
            if (!empty($value->file_id)) {
                $model_Quotes = Quotes::model()->find(array('condition' => 'file_id=' . $value->file_id));
            }


            if (!empty($value->created_datetime)) {
                $created_date = date("d/m/Y", strtotime($value->created_datetime));
            } else {
                $created_date = '00/0/0000';

            }


            $title .= "</ul>";
            $data[] = array(
                'workspace_created_date' => $created_date,
                'workspace_id' => $space_id,
                'quotes_id' => $model_Quotes->id,
                'title' => $title,
                'status' => "N",//$value->status,
                'customer_id' => $value->customer_id,
                'customer_name' => $value->customer->customer_name,
                'lead_id' => $value->id,
                'file_id' => $value->file_id,
                'amount' => $value->value,
                'id' => $note_id,
                'bgcolor' => $modelColor->bg_color_code,
                'shared_to' => $shared_to
            );*/

			
			if (!empty($row->requisition_date)) {
                $created_date = date("d/m/Y", strtotime($row->requisition_date));
            } else {
                $created_date = '00/0/0000';
            }
			if (!empty($row->file_id)) {
                $modelQuotes = Quotes::model()->find(array('condition' => 'file_id=' . $row->file_id));
            }
			$modelColor = Workspace::model()->findByPk($workspaceIdRequisition);
			$reqModeColor = $modelColor->bg_color_code;
			$title = "<ul class='label-list'><li></li>";
			$title .= "<li style='text-align:right;font-weight:400;font-size:12px;color:$reqModeColor' ><strong>" . $row['id'] . "</strong></li>";
			if (!empty($req_date)) {
                $title .= "<li style='font-weight:400;font-size:12px' >Date : " . $req_date . "</li>";
            }
			if (!empty($required_date)) {
                $title .= "<li style='font-weight:400;font-size:12px' >Required Date : " . $required_date . "</li>";
            }
			if (!empty($row->reference)) {
                $title .= "<li style='font-weight:400;font-size:12px' >Reference :" . $row->reference . "</li>";
            }
			if (!empty($row->convert_status)) {
				if ($row->convert_status != "0") {
					$state = "Active";
				} else {
					$state = "Closed";
				}
				$title .= "<li style='font-weight:400;font-size:12px' >Status : " . $state . "</li>";
            }
			$title .= "</ul>";
			
			$shared_to = [];
            $_temp_arr = explode(",", $row->created_by);
            foreach ($_temp_arr as $each_user) {
                if (!empty($each_user)) {
                    $shared_to[] = array(
                        'id' => $each_user,
                        'name' => $user_list[$each_user]
                    );
                }
            }
			$is_approved = MasterFile::model()->findByPk($row->file_id)->is_approved;

			$data[] = array(
                'workspace_created_date' => $created_date,
                'workspace_id' => $workspaceIdRequisition,//$space_id,
                'quotes_id' => $modelQuotes->id,
                'title' => $title,
                'status' => $row->status,
                'customer_id' => $row->crm_user_id,
                'customer_name' => $row->id,
                'lead_id' => $row->id,
                'file_id' => $row->file_id,
                'id' => $row->id,
                'bgcolor' => $modelColor->bg_color_code,
                'shared_to' => $shared_to,
				'request_date' => $req_date,
				'required_date' => $required_date,
				'is_approved' => $is_approved
            );
        }

		$model = new PurchasingEnquiry();
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND ( t.id LIKE '%" . $searchString . "%' OR t.title LIKE '%" . $searchString . "%'  OR t.required_date LIKE '%" . $searchString . "%'  OR t.enquiry_date LIKE '%" . $searchString . "%')";
        } else {
            $condition .= " AND t.convert_status='Y'";
        }
        $sql = "SELECT t.id,t.vendor_id,t.title,t.enquiry_date,t.required_date,t.convert_status,t.isActive,IFNULL(A.nonlocal_qty,0) AS nonlocal_qty, requisition_id, t.reference  
                FROM `erp_purchasing_enquiry` t 
                LEFT JOIN 
                (SELECT purchasing_enquiry_id,IFNULL(COUNT(S.id),0) AS nonlocal_qty FROM erp_purchasing_enquiry_stock_item PEI 
                LEFT JOIN erp_store S ON (PEI.stock_item_id =S.id) GROUP BY purchasing_enquiry_id)A 
                ON t.id = A.purchasing_enquiry_id WHERE A.purchasing_enquiry_id=t.id";
        $SQL1 = $sql . " AND ($condition) ";
        $model = Yii::app()->db->createCommand($SQL1)->queryAll();
		$reqModeColor = $modelColor->bg_color_code;
        foreach ($model as $keyindex => $row) {
            $req_date = date("d/m/Y", strtotime($row['enquiry_date']));
            $required_date = date("d/m/Y", strtotime($row['required_date']));

            $drop = CHtml::dropDownList('vendor_id_' . $row['id'], '', Vendor::getVendorsEnquiry($row['id']));

            
            $vendors = Vendor::getVendorsEnquiry($row['id']);
			
			
			if (!empty($row['enquiry_date'])) {
				$created_date = date("d/m/Y", strtotime($row['enquiry_date']));
			} else {
				$created_date = '00/0/0000';
			}
			if (!empty($row['file_id'])) {
				$modelQuotes = Quotes::model()->find(array('condition' => 'file_id=' . $row['file_id']));
			}
			$shared_to = $vendorName = [];
			$_temp_arr = explode(",", $row['vendor_id']);
			foreach ($_temp_arr as $each_user) {
				if (!empty($each_user)) {
					$shared_to[] = array(
						'id' => $each_user,
						'name' => $user_list[$each_user]
					);
					$vendorName[] = $user_list[$each_user];
				}
			}
			$modelColor = Workspace::model()->findByPk($workspaceIdPurchaseEnquiry);
			$title = "<ul class='label-list'><li></li>";
			$title .= "<li style='text-align:right;font-weight:400;font-size:12px;color:$modelColor->bg_color_code' ><strong>" . $row['id'] . "</strong></li>";
			if (!empty($row['requisition_id'])) {
				$title .= "<li style='font-weight:400;font-size:12px;color:$reqModeColor' ><strong>" . $row['requisition_id'] . "</strong></li>";
			}
			if (!empty($req_date)) {
				$title .= "<li style='font-weight:400;font-size:12px' >Enquiry Date : " . $req_date . "</li>";
			}
			if (!empty($required_date)) {
				$title .= "<li style='font-weight:400;font-size:12px' >Required Date : " . $required_date . "</li>";
			}
			if (!empty($row['reference'])) {
				$title .= "<li style='font-weight:400;font-size:12px' >Reference : " . $row['reference'] . "</li>";
			}
			if (!empty($vendors)) {
				//$title .= "<li style='font-weight:400;font-size:12px' >" . implode(',', $vendors) . "</li>";
			}
			$title .= "</ul>";
			
			
			$is_approved = MasterFile::model()->findByPk($row['file_id'])->is_approved;
		
			$data[] = array(
				'workspace_created_date' => $created_date,
				'workspace_id' => $workspaceIdPurchaseEnquiry,//$space_id,
				'quotes_id' => $modelQuotes->id,
				'title' => $title,
				'status' => $row['isActive'],
				'customer_id' => $row['crm_user_id'],
				'customer_name' => $row['id'],
				'lead_id' => $row['id'],
				'file_id' => $row['file_id'],
				'id' => $row['id'],
				'bgcolor' => $modelColor->bg_color_code,
				'shared_to' => $shared_to,
				'request_date' => $req_date,
				'required_date' => $required_date,
				'is_approved' => $is_approved
			);
		}


		$model = new PurchasingOrder();
        $condition = "((file.current_process_status = 'P_O' OR t.convert_status = 'Y')  AND completed!='C')";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (t.id LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.title LIKE '%" . $searchString . "%' OR t.required_date LIKE '%" . $searchString . "%' OR t.order_date LIKE '%" . $searchString . "%' OR t.stock_grand_total LIKE '%" . $searchString . "%' OR vendor_details.vendor_name LIKE '%" . $searchString . "%')";
        }
        $sql = "SELECT t.id,t.project_ids,t.project_classification_id,t.ticket_id,t.file_id,t.title,t.order_date,t.required_date,t.expected_delivery_date,t.completed,t.stock_grand_total,t.nonstock_grandtotal,t.exchange_rate,t.convert_status,
                t.vendor_id,t.service_invoice,t.vendor_contact_id,t.created_by,currencyname.currency_code,vendor_details.vendor_name,t.approved_level,
                file.current_process_status,file.is_approved,IFNULL(A.nonlocal_qty,0) AS nonlocal_qty, t.enquiry_id 
                FROM `erp_purchasing_order` t
                LEFT JOIN
                (SELECT purchasing_order_id,IFNULL(COUNT(S.id),0) AS nonlocal_qty FROM erp_purchasing_order_stock_item PEI
                LEFT JOIN erp_store S ON (PEI.stock_item_id =S.id) GROUP BY purchasing_order_id)A
                ON t.id = A.purchasing_order_id
                LEFT JOIN {{master_file}} file ON file.id=t.file_id
                LEFT JOIN {{vendor}} vendor_details ON vendor_details.id=t.vendor_id
                LEFT JOIN {{mas_currency}} currencyname ON currencyname.id=t.currency
                WHERE A.purchasing_order_id=t.id";
        $SQL1 = $sql . " AND ($condition) ";
        $model = Yii::app()->db->createCommand($SQL1)->queryAll();
       

        $i = 1;
		$reqModeColor = $modelColor->bg_color_code;
        foreach ($model as $row) {
            $order_date = date("d/m/Y", strtotime($row['order_date']));
            $required_date = date("d/m/Y", strtotime($row['expected_delivery_date']));
            if ($row['nonlocal_qty'] == 0) {
                $ptype = 'L';
            } else {
                $ptype = 'I';
            }
            if ($row['current_process_status'] == 'P_O') {
                $status = 'Order';
            } else if ($row['current_process_status'] == 'M_R') {
                $status = 'Material Reciept';
            } else if ($row['current_process_status'] == 'Q_C') {
                $status = 'Quality Checked';
            } else if ($row['current_process_status'] == 'P_I') {
                $status = 'Invoice';
            } else {
                $status = '';
            }
            if ($row['completed'] == 'P') {
                $status = 'Material Reciept (Partial)';
            }
            if ($row['completed'] == 'C') {
                $status = 'Short Closure';
            }

            $state = 0;
            if (strtotime($row['required_date']) < strtotime(date('Y-m-d'))) {
                $state = 1;
            } elseif ($row['is_approved'] == 'N') {
                $state = 2;
            }
            $created_user = User::model()->findByPK($row['created_by'])->fullname;
            $grand_total = $row['stock_grand_total'] + $row['nonstock_grandtotal'];
            $grand_total_bc = ($grand_total * $row['exchange_rate']);
            $project_details = WsProject::model()->findByPK($row['project_ids'])->project_name;
            $rowData[] = array($row['file_id'],//0
                $row['id'], //1
                $project_details.' - '.$row['project_ids'],//2
                $row['vendor_name'], //3
                $order_date, //4
                $required_date, //5
                $row['currency_code'], //6
                Yii::app()->numberFormatter->formatCurrency($grand_total, ""),//7
                Yii::app()->numberFormatter->formatCurrency($grand_total_bc, ""),//8
                $status, //9
                $state, //10
                $row['is_approved'], //11
                //$row['approved_level'], //11
                $row['convert_status'], //12
                $row['completed'], //13
                $row['vendor_id'], //14
                $row['service_invoice'], //15
                $row['vendor_contact_id'], //16
                $created_user, //17
                $ptype,//18
                $row['approved_level'],//19
                $row['current_process_status']//20
            );
            $i++;


			if (!empty($row['order_date'])) {
				$created_date = date("d/m/Y", strtotime($row['order_date']));
			} else {
				$created_date = '00/0/0000';
			}
			if (!empty($row['file_id'])) {
				$modelQuotes = Quotes::model()->find(array('condition' => 'file_id=' . $row['file_id']));
			}
			$grand_total = $row['stock_grand_total'] + $row['nonstock_grandtotal'];
            $grand_total_bc = ($grand_total * $row['exchange_rate']);
			$project_details = WsProject::model()->findByPK($row['project_ids'])->project_name;
			$modelColor = Workspace::model()->findByPk($workspaceIdPurchaseOrder);
			$title = "<ul class='label-list'><li></li>";
			$title .= "<li style='text-align:right;font-weight:400;font-size:12px;color:$modelColor->bg_color_code' ><strong>" . $row['id'] . "</strong></li>";
			if (!empty($row['enquiry_id'])) {
				$title .= "<li style='font-weight:400;font-size:12px;color:$reqModeColor' ><strong>" . $row['enquiry_id'] . "</strong></li>";
			}
			if (!empty($row['file_id'])) {
				$title .= "<li style='font-weight:400;font-size:12px' >File : " . $row['file_id'] . "</li>";
			}
			if (!empty($project_details)) {
				//$title .= "<li style='font-weight:400;font-size:12px' >Project Id : " . $project_details.' - '.$row['project_ids'] . "</li>";
			}
			if (!empty($row['vendor_name'])) {
				//$title .= "<li style='font-weight:400;font-size:12px' >Supplier : " . $row['vendor_name'] . "</li>";
			}
			if (!empty($order_date)) {
				$title .= "<li style='font-weight:400;font-size:12px' >Order Date : " . $order_date . "</li>";
			}
			if (!empty($required_date)) {
				$title .= "<li style='font-weight:400;font-size:12px' >Exp Dly Dt : " . $required_date . "</li>";
			}
			if (!empty($row['currency_code'])) {
				//$title .= "<li style='font-weight:400;font-size:12px' >" . $row['currency_code'] . "</li>";
			}
			if (!empty($grand_total)) {
				$title .= "<li style='font-weight:400;font-size:12px' >Total Value : " . $grand_total . " " .$row['currency_code']."</li>";
			}
			if (!empty($grand_total_bc)) {
				//$title .= "<li style='font-weight:400;font-size:12px' >" . $grand_total_bc . "</li>";
			}
			$title .= "</ul>";
			
			$shared_to = [];
			$_temp_arr = explode(",", $row['vendor_id']);
			foreach ($_temp_arr as $each_user) {
				if (!empty($each_user)) {
					$shared_to[] = array(
						'id' => $each_user,
						'name' => $user_list[$each_user]
					);
				}
			}
			$is_approved = MasterFile::model()->findByPk($row['file_id'])->is_approved;
		
			$data[] = array(
				'workspace_created_date' => $created_date,
				'workspace_id' => $workspaceIdPurchaseOrder,//$space_id,
				'quotes_id' => $modelQuotes->id,
				'title' => $title,
				'status' => $row['isActive'],
				'customer_id' => $row['crm_user_id'],
				'customer_name' => $row['id'],
				'lead_id' => $row['id'],
				'file_id' => $row['file_id'],
				'id' => $row['id'],
				'bgcolor' => $modelColor->bg_color_code,
				'shared_to' => $shared_to,
				'request_date' => $req_date,
				'required_date' => $required_date,
				'is_approved' => $is_approved
			);
        }

		$model   = new PurchasingMaterialreceipt();
        $condition = "file.current_process_status = 'M_R' ";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "t.po_id LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR vendor_details.vendor_name LIKE '%" . $searchString . "%' ";
        }
        $model = $model->with('file','vendor_details')->findAll(array('condition' => $condition));
        $reqModeColor = $modelColor->bg_color_code;
        foreach ($model as $row) {
            $req_date=date("d/m/Y", strtotime($row->mrv_receipt_date));
			$delivery_date = date("d/m/Y", strtotime($row['dly_date']));
            if($row['qcchecked'] == 'N'){
                $quality_control_status  = "Not Done";
            }
            else{
            $quality_control_status  = "Completed";
            }
            $edit = '';
            // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_material_view"])){
            //     $edit = ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'materialreceipt/create&id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\'Material Receipt - ' . $row['file_id'] . '\',\'xl\')" title="View"><i class="fa fa-eye" aria-hidden="true"></i></i></button>';
            // }
            if(Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn["purchase_material_print"]))
                $edit .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=materialreceipt/Print&id='.$row['id'].'"><i class="fa fa-file-pdf-o"></i></a>';
            if($row['file']['current_process_status'] == 'P_O'){
                $status  = 'Order';
            }else if($row['file']['current_process_status'] == 'M_R'){
                $status  = 'Material Reciept';
            }else if($row['file']['current_process_status'] == 'Q_C'){
                $status  = 'Quality Checked';
            }else if($row['file']['current_process_status'] == 'P_I'){
                $status  = 'Purchase Invoice';
            }
            $rowData[] = array($i,$row['file_id'],$row['po_id'],$row['id'],$row['vendor_details']['vendor_name'],$quality_control_status,$req_date,$status);
            

			if (!empty($row['dly_date'])) {
				$created_date = date("d/m/Y", strtotime($row['dly_date']));
			} else {
				$created_date = '00/0/0000';
			}
			if (!empty($row['file_id'])) {
				$modelQuotes = Quotes::model()->find(array('condition' => 'file_id=' . $row['file_id']));
			}
			$modelColor = Workspace::model()->findByPk($workspaceIdMaterialReceipt);
			$title = "<ul class='label-list'><li></li>";
			$title .= "<li style='text-align:right;font-weight:400;font-size:12px;color:$modelColor->bg_color_code' ><strong>" . $row['id'] . "</strong></li>";
			if (!empty($row['po_id'])) {
				$title .= "<li style='font-weight:400;font-size:12px;color:$reqModeColor' ><strong>" . $row['po_id'] . "</strong></li>";
			}
			if (!empty($row['file_id'])) {
				$title .= "<li style='font-weight:400;font-size:12px' >File : " . $row['file_id'] . "</li>";
			}
			if (!empty($row['vendor_details']['vendor_name'])) {
				//$title .= "<li style='font-weight:400;font-size:12px' >Supplier : " . $row['vendor_details']['vendor_name'] . "</li>";
			}
			if (!empty($delivery_date)) {
				$title .= "<li style='font-weight:400;font-size:12px' >Delivery Date : " . $delivery_date . "</li>";
			}
			if (!empty($quality_control_status)) {
				$title .= "<li style='font-weight:400;font-size:12px' >QC : " . $quality_control_status . "</li>";
			}
			$title .= "</ul>";
			
			$shared_to = [];
			$_temp_arr = explode(",", $row['vendor_id']);
			foreach ($_temp_arr as $each_user) {
				if (!empty($each_user)) {
					$shared_to[] = array(
						'id' => $each_user,
						'name' => $user_list[$each_user]
					);
				}
			}
			$is_approved = MasterFile::model()->findByPk($row['file_id'])->is_approved;
		
			$data[] = array(
				'workspace_created_date' => $created_date,
				'workspace_id' => $workspaceIdMaterialReceipt,//$space_id,
				'quotes_id' => $modelQuotes->id,
				'title' => $title,
				'status' => $row['invoiced'],
				'customer_id' => $row['crm_user_id'],
				'customer_name' => $row['id'],
				'lead_id' => $row['id'],
				'file_id' => $row['file_id'],
				'id' => $row['id'],
				'bgcolor' => $modelColor->bg_color_code,
				'shared_to' => $shared_to,
				'request_date' => $req_date,
				'required_date' => $required_date,
				'is_approved' => $is_approved
			);

        }


		$model = new PurchasingMaterialreceipt();
        $condition = "(qcchecked='N' OR is_convertable='Y') and purchaseorder.service_invoice!='Y'";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "purchaseorder.service_invoice!='Y' AND (t.po_id LIKE '%" . $searchString . "%' OR  t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR vendor_details.vendor_name LIKE '%" . $searchString . "%')";
        }
        $model = $model->with('file', 'vendor_details', 'purchaseorder')->findAll(array('condition' => $condition));
        $reqModeColor = $modelColor->bg_color_code;
        foreach ($model as $row) {
            $req_date = date("d/m/Y", strtotime($row->mrv_receipt_date));
            if ($row['qcchecked'] == 'N') {
                $quality_control_status = "Not Done";
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_qc_edit"])) {
                    $edit = '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'qualitycheck/create&id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\' Material Receipt No - ' . $row['id'] . '\',\'xl\')" title="Quality Check/Receive items"><i class="fa fa-pencil" aria-hidden="true"></i></i></button>';
                }
            } else {
                $quality_control_status = "Completed";
                $edit = '';

                if ($row['is_convertable'] == 'Y') {
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_qc_convert"])) {
                        $edit .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'purchaseinvoice/create&mr_id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\' File No - ' . $row['file_id'] . '\',\'xl\');" title="Convert to Invoice" class="btn btn-primary btn-xs" ><i class="fa fa-retweet" aria-hidden="true"></i></i></button>';
                    }
                }
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_material_print"]))
                $edit .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=materialreceipt/Print&id=' . $row['id'] . '&type=qc"><i class="fa fa-file-pdf-o"></i></a>';
            //  if($row['file']['current_process_status'] == 'P_O'){
            //   $status  = 'Purchase Order';
            //   }else if($row['file']['current_process_status'] == 'M_R'){
            //   $status  = 'Material Reciept';
            //   }else if($row['file']['current_process_status'] == 'Q_C'){
            //   $status  = 'Quality Checked';
            //   }else if($row['file']['current_process_status'] == 'P_I' && $row['is_convertable'] == 'N'){
            //   $status  = 'Purchase Invoice';
            //   }else if($row['file']['current_process_status'] == 'P_I' && $row['is_convertable'] == 'Y'){
            //   $status  = 'Purchase Invoice (Partial)';
            //   }
            if ($row['qcchecked'] == 'N') {
                $status = 'Material Reciept';
            } else if ($row['qcchecked'] == 'Y' && $row['is_convertable'] == 'Y') {
                $status = 'Quality Checked';
            } else if ($row['qcchecked'] == 'Y' && $row['is_convertable'] == 'N') {
                $status = 'Purchase Invoice';
            }
            $rowData[] = array($i, $row['file_id'], $row['po_id'], $row['id'], $row['vendor_details']['vendor_name'], $quality_control_status, $req_date, $status, $row['qcchecked'], $row['is_convertable'], $row['posted']);
            $i++;


			if (!empty($row['dly_date'])) {
				$created_date = date("d/m/Y", strtotime($row['dly_date']));
			} else {
				$created_date = '00/0/0000';
			}
			if (!empty($row['file_id'])) {
				$modelQuotes = Quotes::model()->find(array('condition' => 'file_id=' . $row['file_id']));
			}
			$modelColor = Workspace::model()->findByPk($workspaceIdQualityCheck);
			$title = "<ul class='label-list'><li></li>";
			$title .= "<li style='text-align:right;font-weight:400;font-size:12px;color:$modelColor->bg_color_code' ><strong>" . $row['id'] . "</strong></li>";
			if (!empty($row['po_id'])) {
				$title .= "<li style='font-weight:400;font-size:12px;color:$reqModeColor' ><strong>" . $row['po_id'] . "</strong></li>";
			}
			if (!empty($row['file_id'])) {
				$title .= "<li style='font-weight:400;font-size:12px' >File : " . $row['file_id'] . "</li>";
			}
			if (!empty($row['vendor_details']['vendor_name'])) {
				//$title .= "<li style='font-weight:400;font-size:12px' >Supplier : " . $row['vendor_details']['vendor_name'] . "</li>";
			}
			if (!empty($req_date)) {
				$title .= "<li style='font-weight:400;font-size:12px' >Receipt Date : " . $req_date . "</li>";
			}
			if (!empty($quality_control_status)) {
				$title .= "<li style='font-weight:400;font-size:12px' >QC : " . $quality_control_status . "</li>";
			}
			if (!empty($status)) {
				$title .= "<li style='font-weight:400;font-size:12px' >Status : " . $status . "</li>";
			}
			
			
			
			
			$title .= "</ul>";
			
			$shared_to = [];
			$_temp_arr = explode(",", $row['vendor_id']);
			foreach ($_temp_arr as $each_user) {
				if (!empty($each_user)) {
					$shared_to[] = array(
						'id' => $each_user,
						'name' => $user_list[$each_user]
					);
				}
			}
			$is_approved = MasterFile::model()->findByPk($row['file_id'])->is_approved;
		
			$data[] = array(
				'workspace_created_date' => $created_date,
				'workspace_id' => $workspaceIdQualityCheck,//$space_id,
				'quotes_id' => $modelQuotes->id,
				'title' => $title,
				'status' => $row['invoiced'],
				'customer_id' => $row['crm_user_id'],
				'customer_name' => $row['vendor_details']['vendor_name'],
				'lead_id' => $row['id'],
				'file_id' => $row['file_id'],
				'id' => $row['id'],
				'bgcolor' => $modelColor->bg_color_code,
				'shared_to' => $shared_to,
				'request_date' => $req_date,
				'required_date' => $required_date,
				'is_approved' => $row['qcchecked']
			);

        }


		$model = new PurchasingInvoice();
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND ( t.invoice_no LIKE '%" . $searchString . "%' OR vendor_details.vendor_name LIKE '%" . $searchString . "%' OR  t.materialreceived LIKE '%" . $searchString . "%' OR  t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR awb_no LIKE '%" . $searchString . "%' OR t.po_id LIKE '%" . $searchString . "%')";
        }
        $model = $model->with('file', 'vendor_details')->findAll(array('condition' => $condition));
        
        $status = '';
		$reqModeColor = $modelColor->bg_color_code;
        foreach ($model as $row) {
            switch ($row['file']['current_process_status']) {
                case 'P_I':
                    $status = 'PI';
                    break;
                case 'M_R':
                    $status = 'MR';
                    break;
                case 'Q_C':
                    $status = 'QC';
                    break;
            }
            if ($row['is_direct_invoice'] == 'Y') {
                //Code commented by mereena on 28/02/2020
                //$row['file_id'] = '##DP';
                $row['po_id'] = '##DP';
                //$row['invoice_no'] = '##DP';
                //end
                $row['materialreceived'] = '##DP';
            }

//            $div = '';
//            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_invoice_pdf"])) {
//                $div .= '<a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=purchaseinvoice/PrintInvoiceReportPDF&id=' . $row['id'] . '&c_id=' . $row['crm_user_id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
//            }
            $debitnote = Purchasingdebitnote::model()->find(array('condition' => 'purchasing_invoice_id =' . $row['id']));
            ($debitnote->id > 0) ? $dn_status = 'Yes' : $dn_status = 'No';
            $service_invoice = 'N';
            if ($row['purchase_invoice'] == 'LC' && !empty($row['purchase_invoice_id'])) {
                $service_invoice = 'Y';
            }
            $have_landing_cost = 'N';
            $check_landing_cost = PurchasingInvoice::model()->find(array('condition' => 'purchase_invoice_id like "' . $row['id'] . '" OR purchase_invoice_id like "' . $row['id'] . ',%" OR purchase_invoice_id like "%,' . $row['id'] . ',%" OR purchase_invoice_id like "%,' . $row['id'] . '"'));
            if (!empty($check_landing_cost)) {
                $have_landing_cost = 'Y';
            }
            $rowData[] = array(
                $row['po_id'],//0
                $row['id'],//1
                $row['materialreceived'],//2
                $row['vendor_details']['vendor_name'],//3
                date("d/m/Y", strtotime($row['invoice_date'])),//4
                $row->currencyname->currency_code,//5
                '<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($row['grand_total'], "") . '</div>',//6
                
                $row->file_id,//7
                $status,//8
                $dn_status,//9
                $row['crmUser']['first_name'] . ' ' . $row['crmUser']['last_name'],//10
                $row['is_direct_invoice'],//11
                $row['crm_user_id'],//12
                 $row['posted'],//13
                 $row['invoice_no'],//14
                );

				$req_date = date("d/m/Y", strtotime($row['invoice_date']));
				$payment_date = date("d/m/Y", strtotime($row['payment_date']));
				if (!empty($row['invoice_date'])) {
					$created_date = date("d/m/Y", strtotime($row['invoice_date']));
				} else {
					$created_date = '00/0/0000';
				}
				if (!empty($row['file_id'])) {
					$modelQuotes = Quotes::model()->find(array('condition' => 'file_id=' . $row['file_id']));
				}
				$modelColor = Workspace::model()->findByPk($workspaceIdPurchaseInvoice);
				$title = "<ul class='label-list'><li></li>";
				$title .= "<li style='text-align:right;font-weight:400;font-size:12px;color:$modelColor->bg_color_code' ><strong>" . $row['id'] . "</strong></li>";
				if (!empty($row['po_id'])) {
					$title .= "<li style='font-weight:400;font-size:12px;color:$reqModeColor' ><strong>" . $row['po_id'] . "</strong></li>";
				}
				if (!empty($row['materialreceived'])) {
					$title .= "<li style='font-weight:400;font-size:12px;' >MRV No : " . $row['materialreceived'] . "</li>";
				}
				if (!empty($row['vendor_details']['vendor_name'])) {
					//$title .= "<li style='font-weight:400;font-size:12px' >Supplier : " . $row['vendor_details']['vendor_name'] . "</li>";
				}
				if (!empty($req_date)) {
					$title .= "<li style='font-weight:400;font-size:12px' >Invoice Date : " . $req_date . "</li>";
				}
				if (!empty($payment_date)) {
					$title .= "<li style='font-weight:400;font-size:12px' >Payment Date : " . $payment_date . "</li>";
				}
				if (!empty($row['grand_total'])) {
					$title .= "<li style='font-weight:400;font-size:12px' >Amount : " . Yii::app()->numberFormatter->formatCurrency($row['grand_total'], "") . " " .$row->currencyname->currency_code."</li>";
				}
				$title .= "</ul>";
				
				$shared_to = [];
				$_temp_arr = explode(",", $row['vendor_id']);
				foreach ($_temp_arr as $each_user) {
					if (!empty($each_user)) {
						$shared_to[] = array(
							'id' => $each_user,
							'name' => $user_list[$each_user]
						);
					}
				}
				$is_approved = MasterFile::model()->findByPk($row['file_id'])->is_approved;
			
				$data[] = array(
					'workspace_created_date' => $created_date,
					'workspace_id' => $workspaceIdPurchaseInvoice,//$space_id,
					'quotes_id' => $modelQuotes->id,
					'title' => $title,
					'status' => $row['isActive'],
					'customer_id' => $row['crm_user_id'],
					'customer_name' => $row['vendor_details']['vendor_name'],
					'lead_id' => $row['id'],
					'file_id' => $row['file_id'],
					'id' => $row['id'],
					'bgcolor' => $modelColor->bg_color_code,
					'shared_to' => $shared_to,
					'request_date' => $req_date,
					'required_date' => $required_date,
					'is_approved' => $is_approved
				);
			
        }



		$model=new Purchasingdebitnote();
		$condition = 't.is_goods_returned="Y"';
		if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
		{
			$searchString = $_POST['search']['value'];
			$condition.=" AND (t.file_id LIKE '%".$searchString."%' OR purchasing_invoice_id LIKE '%".$searchString."%' OR t.id LIKE '%".$searchString."%' OR vendor_details.vendor_name LIKE '%".$searchString."%')";
		}
		$model=$model->with('vendor_details','file','purchaseinvoice')->findAll(array('condition'=>$condition));
		$reqModeColor = $modelColor->bg_color_code;
		foreach ($model as $row)
		{
                    if($row['debited_date'] !='0000-00-00'){
                        $debited_date = date("d/m/Y",strtotime($row['debited_date']));
                    }else{
                        $debited_date ='';
                    }
                    $rowData[]=array($row['file_id'],$row['purchasing_invoice_id'],$row['id'],$debited_date,$row->vendor_details->vendor_name,Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'],""),Yii::app()->numberFormatter->formatCurrency($row['debited_amount'],""),$row['reason'],$row->invoice->invoicetype->tax,$row['posted']);


					if (!empty($row['created_datetime'])) {
						$created_date = date("d/m/Y", strtotime($row['created_datetime']));
					} else {
						$created_date = '00/0/0000';
					}
					if (!empty($row['file_id'])) {
						$modelQuotes = Quotes::model()->find(array('condition' => 'file_id=' . $row['file_id']));
					}
					$modelColor = Workspace::model()->findByPk($workspaceIdPurchaseReturn);
					$title = "<ul class='label-list'><li></li>";
					$title .= "<li style='text-align:right;font-weight:400;font-size:12px;color:$modelColor->bg_color_code' ><strong>" . $row['id'] . "</strong></li>";
					if (!empty($row['purchasing_invoice_id'])) {
						$title .= "<li style='font-weight:400;font-size:12px;color:$reqModeColor' ><strong>" . $row['purchasing_invoice_id'] . "</strong></li>";
					}
					if (!empty($row['file_id'])) {
						$title .= "<li style='font-weight:400;font-size:12px' >File : " . $row['file_id'] . "</li>";
					}				
					if (!empty($debited_date)) {
						$title .= "<li style='font-weight:400;font-size:12px' >Debit Date : " . $debited_date . "</li>";
					}
					if (!empty($row['debit_note_no'])) {
						//$title .= "<li style='font-weight:400;font-size:12px' >Debit Note No : " . $row['debit_note_no'] . "</li>";
					}
					if (!empty($row->vendor_details->vendor_name)) {
						//$title .= "<li style='font-weight:400;font-size:12px' >Supplier : " . $row->vendor_details->vendor_name . "</li>";
					}
					if (!empty($row['total_tax_amount'])) {
						$title .= "<li style='font-weight:400;font-size:12px' >VAT : " . Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'],"") . "</li>";
					}
					if (!empty($row['debited_amount'])) {
						$title .= "<li style='font-weight:400;font-size:12px' >Returned Amount : " . Yii::app()->numberFormatter->formatCurrency($row['debited_amount'],"") . "</li>";
					}
					if (!empty($row['reason'])) {
						//$title .= "<li style='font-weight:400;font-size:12px' >Reason : " . $row['reason'] . "</li>";
					}
					$title .= "</ul>";
					
					$shared_to = [];
					$_temp_arr = explode(",", $row['vendor_id']);
					foreach ($_temp_arr as $each_user) {
						if (!empty($each_user)) {
							$shared_to[] = array(
								'id' => $each_user,
								'name' => $user_list[$each_user]
							);
						}
					}
					$is_approved = MasterFile::model()->findByPk($row['file_id'])->is_approved;
				
					$data[] = array(
						'workspace_created_date' => $created_date,
						'workspace_id' => $workspaceIdPurchaseReturn,//$space_id,
						'quotes_id' => $modelQuotes->id,
						'title' => $title,
						'status' => $row['isActive'],
						'customer_id' => $row['vendor_id'],
						'customer_name' => $row->vendor_details->vendor_name,
						'lead_id' => $row['id'],
						'file_id' => $row['file_id'],
						'id' => $row['id'],
						'bgcolor' => $modelColor->bg_color_code,
						'shared_to' => $shared_to,
						'request_date' => $req_date,
						'required_date' => $required_date,
						'is_approved' => $is_approved
					);
				
		}




        echo json_encode($data);

    }

	function getUser()
    {
        $model = User::getUserModels();
        $array = [];
        foreach ($model as $value) {
            $array[$value->id] = $value->getAvatar();
        }
        return $array;
    }
}