<?php

class ProjectworkspaceController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'create', 'save', 'deleteItem'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
      
        $this->render('index');
    }

    public function actionGetList() {

      
        $model = new ProjectWorkspace();

      
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'name',
            2 => 'color_code',
            3 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (name LIKE '%" . $searchString . "%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'workspace/projectworkspace/create&id=' . $row['id'] . '\',\'Project Workspaces\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteProjectWorkspaces(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';

            $rowData[] = array($m,
                $row['name'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new ProjectWorkspace();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new ProjectWorkspace();
        if (isset($_POST['ProjectWorkspace'])) {
            if ((int) @$_POST['ProjectWorkspace']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['ProjectWorkspace']['id'];
                $model = $model->findByPk($id);
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['ProjectWorkspace'];
            $model->bg_color_code = $_POST['ProjectWorkspace']['bg_color_code'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actiondeleteItem() {
        $jsonData['status'] = 'success';
        $item_id = (int) Yii::app()->request->getParam('id');
        ProjectWorkspace::model()->deleteByPk($item_id);
        echo json_encode(array('status' => 'success', 'id' => $item_id));
     
    }

}
