<?php
class ProjectSpaceController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'getlist', 'create', 'save',
                    'UpdateWorkspace', 'deleteItem', 'shareItem','prospectadd',
                    'deleteshareItem','SaveData', 'viewall','getProjecttype','getMainModuleFilter','getSubModuleFilter','removelineitem','GetSummary'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex() {
        $this->render('index');
    }
     public function actionCreate() {
        $model = new ProjectWorkspaceNote();
        $modelNote = array(new WorkspaceProjectModuleDetails());
        $id = (int) Yii::app()->request->getParam('id');
        $lead_id = (int) Yii::app()->request->getParam('lead_id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            if ($model->due_date != '0000-00-00') {
                $model->due_date = date('d/m/Y', strtotime($model->due_date));
            }
              if ($model->start_date != '0000-00-00') {
                $model->start_date = date('d/m/Y', strtotime($model->start_date));
            }
        $modelNote = WorkspaceProjectModuleDetails::model()->findAll(array('condition'=>'workspace_note_id='.$id));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('project_create', array('model' => $model,'modelnote'=>$modelNote,'id'=>$id), false, false);
    }
    public function actiongetlist() {
        $condition = " 1 = 1";
        $user_id = Yii::app()->user->id;
        // if ((Yii::app()->user->authorised_user != 1) && (Yii::app()->user->havePermissionOn['workspace_view_all'] != 1)) {
        //     //    $condition .= " AND FIND_IN_SET( {$user_id}, shared_to)";
        //     //$condition.=" AND created_by=".Yii::app()->user->id;
        //     $condition.=" AND (created_by=".Yii::app()->user->id." OR through_id=".Yii::app()->user->id.")";
        // }
        // if (isset($_REQUEST['through_id']) && !empty($_REQUEST['through_id'])) {
        //     $condition .= " AND through_id =" . $_REQUEST['through_id'];
        // }
        if (isset($_REQUEST['group_id']) && !empty($_REQUEST['group_id'])) {
            $condition .= " AND sales_group_id =" . $_REQUEST['group_id'];
        }
        if (isset($_REQUEST['from_date']) && !empty($_REQUEST['from_date'])) {
            $date = explode("/", $_REQUEST['from_date']);
            $from_date = $date[2] . "-" . $date[1] . '-' . $date[0];
            // $condition .= " and date(created_date_time) >= '{$from_date}'  ";
        }
        if (isset($_REQUEST['to_date']) && !empty($_REQUEST['to_date'])) {
            $date = explode("/", $_REQUEST['to_date']);
            $to_date = $date[2] . "-" . $date[1] . '-' . $date[0];
            // $condition .= " and date(created_date_time) <= '{$to_date}'  ";
        }
        $models = ProjectWorkspaceNote::model()->findAll(array(
            'condition' => $condition
        ));
        $user_list = $this->getUser();
        $data = array();
        foreach ($models as $value) {
            $shared_to = [];
            $_temp_arr = explode(",", $value->shared_to);
            foreach ($_temp_arr as $each_user) {
                if (!empty($each_user)) {
                    $shared_to[] = array(
                        'id' => $each_user,
                        'name' => $user_list[$each_user]
                    );
                }
            }
      //for percentage caluculation      
        $prj_per = 0;
        $avg =0;
        $submodule_default_percent1= 0;
        $submodule_current_percent1= 0;
        $module_default_percent = 0;
        $workspace_id = WorkspaceProjectModuleDetails::model()->find(array('condition'=>'workspace_note_id="'.$value->id.'"'));
        if(!empty($workspace_id)){
            $project_id = $workspace_id->project_id;
        $projectModel = MasWorkspaceProject::model()->findByPK($value);
        $modelModules    = MasProjectModule::model()->findAll(array('condition'=>'project_id="'.$project_id.'"'));
        foreach ($modelModules as $i => $each) { 
            $module_default_percent = $each->default_weightage;
            $modelSubmodule = WorkspaceProjectModuleDetails::model()->findAll(array('condition'=>'project_id="'.$project_id.'" AND main_module_id="'.$each->id.'"'));
            $submodule_default_percent1= 0; 
            $submodule_current_percent1= 0;
            foreach ($modelSubmodule as $i => $eachsub) 
            { 
                $submodule_default_percent1  += ($eachsub->weightage_percent/$eachsub->weightage_percent)*100;
                $submodule_current_percent1  += ($eachsub->current_weightage_percent /$eachsub->weightage_percent)*100;;
                
            }
                $main_module_complte = ($submodule_current_percent1/$submodule_default_percent1)*100; 
                $avg = ($main_module_complte*$module_default_percent)/100;
                $prj_per += $avg ;
        } 
    }    
//end
            $tit_name =substr($value->title,0,23);
            if(strlen($value->title)>23){
                $tit_name.='..';
            }
            $title = "<ul class='label-list'><li>" .$tit_name. "</li>";
            if (!empty($value->group)) {
                $title .= "<li style='font-weight:400'>" . substr($value->group->group_name,0,30) . "</li>";
            }
            $title .= "<li style='text-align:end'>" . number_format($prj_per, 2) . "%</li>";
           
            // -------indhu-04-08-2022-----------------
            if (!empty($value->due_date)) {
                // $date1 = $value->due_date;
                // $date2 =  date("Y-m-d");
                $mydate=strtotime($value->due_date);
                $curdate=strtotime(date("Y-m-d"));
                    if($curdate > $mydate)
                    {
                        $date1=date_create($value->due_date);
                    $date2=date_create(date("Y-m-d"));
                    $diff=date_diff($date2,$date1);
                        $difference = strtotime($curdate)-strtotime($mydate);
                        $diff_date =$diff->format("%R%a days");
                        //$diff_date ='<span class="status expired">Expired</span>';
                    }else{
                        $date1=date_create($value->due_date);
                    $date2=date_create(date("Y-m-d"));
                    $diff=date_diff($date2,$date1);
                        $difference = strtotime($curdate)-strtotime($mydate);
                        $diff_date =$diff->format("%R%a days");
                       // $diff_date ="Remaining: ".$difference/(24*60*60)." days";
                    }
                //echo "Difference is: ".$difference/(24*60*60)." days";
                $title .= "<li style='font-weight:400' >" . $diff_date. "</li>";              
            }
            //end
            // if (!empty($value->through)) {
            //     $title .= "<li style='font-weight:400' >" . $value->through->fullname . "</li>";
            // }
            $title .= "</ul>";
            $modelCustomer = Customer::model()->findByPk($value->customer_id);
            
            $data[] = array(
                'project_workspace_id' => $value->project_workspace_id,
                'title' => $title,
                'customer_id' => $value->customer_id,
                'customer_name' => $modelCustomer->customer_name,
               
                'status' => $value->status,
                'lead_id' => $value->lead_id,
                'file_id' => $models->file_id,
                'amount' => $value->amount,
                'id' => $value->id,
                // 'tooltip' => $value->getToolTip(),
                'shared_to' => $shared_to
            );
        }
        echo json_encode($data);
    }
    public function actionUpdateWorkspace() {
        $workspace_id = (int) Yii::app()->request->getParam('workspace_id');
        $previousWorkSpace_id = 0;
        if ($workspace_id > 0) {
            $item_id = (int) Yii::app()->request->getParam('item_id');
            $model = ProjectWorkspaceNote::model()->findByPk($item_id);
            $previousWorkSpace_id = $model->project_workspace_id;
            $model->project_workspace_id = $workspace_id;
            $model->save();
            echo json_encode(array('status' => 'success', 'prev' => $previousWorkSpace_id));
        }
    }
    public function actiondeleteItem() {
        $item_id = (int) Yii::app()->request->getParam('id');
        ProjectWorkspaceNote::model()->deleteByPk($item_id);
        echo json_encode(array('status' => 'success', 'id' => $item_id));
    }
    public function actionshareItem() {
        $item_id = (int) Yii::app()->request->getParam('id');
        $user_id = (int) Yii::app()->request->getParam('user_id');
        $model = ProjectWorkspaceNote::model()->findByPk($item_id);
        $user_list = $this->getUser();
        $_temp_arr = explode(",", $model->shared_to);
        $_temp_arr[] = $user_id;
        $_temp_arr = array_unique($_temp_arr);
        $model->shared_to = implode(",", $_temp_arr);
        $model->save();
        $_temp_arr = explode(",", $model->shared_to);
        foreach ($_temp_arr as $each_user) {
            if (!empty($each_user)) {
                $shared_to[] = array(
                    'id' => $each_user,
                    'name' => $user_list[$each_user]
                );
            }
        }
        $data = array(
            'workspace_id' => $model->workspace_id,
            'title' => $model->title,
            'lead_id' => $model->lead_id,
            'file_id' => $models->file_id,
            'id' => $model->id,
            'tooltip' => $model->getToolTip(),
            'shared_to' => $shared_to
        );
        echo json_encode(array('status' => 'success', 'item' => $data));
    }
    function getUser() {
        $model = User::getUserModels();
        $array = [];
        foreach ($model as $value) {
            $array[$value->id] = $value->getAvatar();
        }
        return $array;
    }
    public function actiondeleteshareItem() {
        $item_id = (int) Yii::app()->request->getParam('id');
        $user_id = (int) Yii::app()->request->getParam('user_id');
        $model = ProjectWorkspaceNote::model()->findByPk($item_id);
        $share_to = $model->shared_to;
        $share_to = str_replace($user_id, "", $share_to);
        $_temp_arr = explode(",", $share_to);
        $_temp_arr = array_unique($_temp_arr);
        $model->shared_to = implode(",", $_temp_arr);
        $model->save();
        echo json_encode(array('status' => 'success',));
    }
    public function actionViewall() {
        $ws_id = (int) Yii::app()->request->getParam('ws_id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('view_all', array('ws_id' => $ws_id), false, false);
    }
/* code updated by nisha 06-07-2022*/
      public function actionProspectadd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $status =  array();
           $drop = '';
           if($name != ''){
               $model = new Customer();
                $model->customer_name = $name;
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->lead_owner_id=Yii::app()->user->id;;
                $model->isProspect ='Y';
                $model->customer_phone_no =0;
                $model->customer_payment_term=0;
                $model->customer_currency_id=0;
                $model->customer_country=0;
               if($model->save()){
                    $status['status']= "success";
                    $field_name = 'title';
                    $data  = Customer::getCustomers();
                    $modelwork = new ProjectWorkspaceNote;
                   $modelwork->$field_name = $model->customer_name;
                  // $drop=CHtml::activedropDownList($modelwork,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Customer'));  
                  $drop = CHtml::activeTextField($modelwork, 'title', array('data-label' => 'Customer/Prospect', 'onKeyup' => 'js:autoCompleteCustomers(this.id,"lead");','data-search' => true));
                    $status['drop']= $drop;
                    $status['customer_id']= $model->id;
                    echo CJSON::encode($status); 
               }else{
                    $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
                       echo $error;
               }
           }
        }
    public function actiongetProjecttype() {
        $id = Yii::app()->request->getparam("project");
        $module_id = Yii::app()->request->getparam("module_id");
        if(empty($module_id)){
            $module_id = 1;
        }
        $condition = "1=1";
        if (!empty($id)) {
            $condition .= ' AND project_id="'.$id.'"';
        }
        //////////////////Code Edited By Lidiya on 03-10-2023//////////////////////
        // if (!empty($module_id )) {
        //     $condition .= " AND main_module_id = " . $module_id;
        // }
        if (!empty($id)) {
             $model_module= MasProjectModule::model()->findAll(array('condition'=> $condition));//MasProjectModuleDetails::model()->findAll(array('condition'=> $condition));
            if(empty($model_module)){
                 $model_module = array(new MasProjectModule());//array(new MasProjectModuleDetails());
            }
           // $model= WorkspaceProjectModuleDetails::model()->findAll(array('condition'=> $condition));
           // if(empty($model)){
                $model= array(new WorkspaceProjectModuleDetails());
             if(!empty($model_module)){   
                $k =0;
              foreach ($model_module as $i => $each){
                $model[$k]= new WorkspaceProjectModuleDetails();
                $model[$k]->project_id = $each->project_id;
                $model[$k]->main_module_id = '';//$each->main_module_id;
                $model[$k]->sub_module_id = $each->id;
                $model[$k]->questions = $each->module;//$each->module_details;
                $model[$k]->weightage_percent = $each->default_weightage;//$each->weightage_percent;
                $k++;
              }
              }
           // }
            //if(empty($model_sub)){
                $model_sub = new WorkspaceProjectModuleDetails();
           // }
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('workspace_module_details', array('model' => $model,'module' => $id,'model_sub'=>$model_sub));
        }else{
            throw new CHttpException(404, 'Page not found.');
        }
    }
    public function actiongetMainModuleFilter() {
        $project_id = $_POST['id'];
        $arr_modules = MasProjectModule::getmoduleList($project_id);
        $model_type= new WorkspaceProjectModuleDetails();
        $data['subloc'] = CHtml::activeDropDownList($model_type, "[0]main_module_id", $arr_modules, array('data-label' => 'Module','onChange' => 'getProjecttype(),getSubModules()'));
         echo CJSON::encode($data);
    }
    public function actiongetSubModuleFilter() {
        $project_id = $_POST['id'];
        $module_id = $_POST['module_id'];
        $arr_modules = array();
        $arr_modules = MasProjectModuleDetails::getSubmoduleList($project_id,$module_id);
        $model_type= new WorkspaceProjectModuleDetails();
        $data['subloc'] = CHtml::activeDropDownList($model_type, "[0]sub_module_id", $arr_modules, array('data-label' => 'Sub Module','onChange' => 'getProjecttype()'));
         echo CJSON::encode($data);
    }
        
public function actionSaveData() {
        $other=array();$groups = array();$analysis_ids=array();$type_ids=array();
       $model = new ProjectWorkspaceNote();
       $total =0;
       $model_analysis = array(new WorkspaceProjectModuleDetails());
        if (isset($_POST['ProjectWorkspaceNote'])) {
            if ($_POST['ProjectWorkspaceNote']['id'] > 0) {
                $id = (int) $_POST['ProjectWorkspaceNote']['id'];
                $model = $model->findByPk($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['ProjectWorkspaceNote'];
            $model->status = $_POST['ProjectWorkspaceNote']['status'];
          
            if (!empty($_POST['ProjectWorkspaceNote']['due_date'])) {
                $due_date_array = explode("/", $_POST['ProjectWorkspaceNote']['due_date']);
                $model->due_date = $due_date_array[2] . "-" . $due_date_array[1] . "-" . $due_date_array[0];
            }
            if (!empty($_POST['ProjectWorkspaceNote']['start_date'])) {
                $start_date_array = explode("/", $_POST['ProjectWorkspaceNote']['start_date']);
                $model->start_date = $start_date_array[2] . "-" . $start_date_array[1] . "-" . $start_date_array[0];
            }
            $valid=$model->validate();
            //Adding Analysis Data
            if (isset($_POST['WorkspaceProjectModuleDetails'])){
                $i=0; 
                foreach ($_POST['WorkspaceProjectModuleDetails'] as $m => $items) {
                        if($items['id']>0){
                            $model_analysis[$i] = WorkspaceProjectModuleDetails::model()->findByPK($items['id']); 
                            $model_analysis[$i]->updated_by= Yii::app()->user->id;
                            $model_analysis[$i]->updated_date_time = date('Y-m-d h:i:s');
                        }else{
                            $model_analysis[$i] = new WorkspaceProjectModuleDetails(); 
                            $model_analysis[$i]->created_by= Yii::app()->user->id;
                            $model_analysis[$i]->created_date_time = date('Y-m-d h:i:s');
                        }   
                        $model_analysis[$i]->project_id = $_POST['project'];
                        $model_analysis[$i]->main_module_id  = $_POST['WorkspaceProjectModuleDetails_0_main_module_id'];
                        $model_analysis[$i]->sub_module_id  = $items['sub_module_id'];
                        $model_analysis[$i]->questions = $items['questions'];
                        $model_analysis[$i]->weightage_percent = $items['weightage_percent'];
                        $model_analysis[$i]->current_weightage_percent = $items['current_weightage_percent'];
                        $total+=$items['weightage_percent'];
                        $valid=$model_analysis[$i]->validate() && $valid;
                        $i++;
                }
            }
            }
             if($total!=100){
                 $other[]='Sum of Weightage should be 100. Now its '.(floatval($total));
                 $valid=false;
             }
            //End Analysis Data
            if ($valid) {
                // if(!empty($analysis_ids)){
                //     WorkspaceProjectModuleDetails::model()->deleteAll('appraisal_id='.$model->id.' AND id NOT IN ('.  implode(',', $analysis_ids).')');
                // }
                $model->save();
                //Save Analysis
                if (!empty($model_analysis)) {
                    foreach ($model_analysis as $eachModel) {
                        $eachModel->workspace_note_id = $model->id;
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_analysis[0]->id!=''){
                   $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }else{
                    $error2[] ='Please add atleast one question';
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
   public function actionRemovelineItem(){
        $id = $_POST['id'];
        if($id>0){
            WorkspaceProjectModuleDetails::model()->deleteByPk($id);
           $status['status'] = 'success';
        }
        else{
           $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
//indhu 03_04_2022
public function actionGetSummary(){
    $ws_id = (int) Yii::app()->request->getParam('ws_id'); 
    $customer_id  = (int) Yii::app()->request->getParam('customer_id');
    $modelWorkSpace = ProjectWorkspaceNote::model()->findByPk($ws_id);
    $this->render('summary_details', array('ws_id' => $ws_id,'customer_id' => $customer_id,'model'=>$modelWorkSpace), false, false);
}
//end
}
    