<?php



class MasterprojectController extends Controller {



   

    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array('allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('Index', 'GetList', 'Create', 'Save', 'Edit','SaveWeightage','RemovelineItem','DeleteType'),

                'expression' => '$user->isMember()',

            ),

            array('deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function actionIndex() {

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('index');

    }



    public function actionGetList() {

        $model = new MasWorkspaceProject();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 'id',

            1 => 'module',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition = "  (project LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

             $div = '';

            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'workspace/masterproject/create&id=' . $row->id . '\',\'Project\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $div .= ' <button class="btn btn-primary btn-xs" onclick="DeleteType('.$row->id.')"><i class="fa fa-close"></i></button>';

           // $rowData[] = array($m, $row->module, $row->id);

            $rowData[] = array($m,

                $row->project,

                '<div class="btn-wrap text-center">' . $div . '</div>',

                $row->id,

            );

            $m++;

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }



    public function actionCreate() {

        $model = new MasWorkspaceProject();

        $id = (int)Yii::app()->request->getParam('id');

        if ($id>0) {

            $model= $model->findbyPK($id);

            if(empty($model)){

                $model = new MasWorkspaceProject();

            }

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model), false, true);

    }



 public function actionSave() {

        $model = new MasWorkspaceProject();

        if (isset($_POST['MasWorkspaceProject'])) {

            if ((int) @$_POST['MasWorkspaceProject']['id'] > 0) {

                $model->updated_by = Yii::app()->user->id;

                $model->updated_date_time = date('Y-m-d h:i:s');

                $id = (int) @$_POST['MasWorkspaceProject']['id'];

                $model = $model->findByPk($id);

            } else {

                $model->created_by = Yii::app()->user->id;

                $model->created_date_time = date('Y-m-d h:i:s');

                $model->updated_by = Yii::app()->user->id;

                $model->updated_date_time = date('Y-m-d h:i:s');

                $model->isActive = 'Y';

            }

            $model->attributes = $_POST['MasWorkspaceProject'];

            if ($model->save()) {

                $jsonData['status'] = 'success';

                $jsonData['id'] = $model->id;

                echo CJSON::encode($jsonData);

            } else {

                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')

                    echo $error;

            }

        }

    }





    public function actionEdit() {

        $model = MasProjectModule::model()->findAll();

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('edit_weightage', array('model' => $model), false, true);

    }

    public function actionSaveWeightage(){

        if (isset($_POST['MasProjectModule'])) {

            $total=0;

            foreach ($_POST['MasProjectModule'] as $i => $item) {

                if ($item['id'] > 0) {

                    $total+=$item['default_weightage'];

                    $model_projectmodule[$i] = MasProjectModule::model()->findByPK($item['id']);

                    $model_projectmodule[$i]->default_weightage = $item['default_weightage'];

                    $model_projectmodule[$i]->updated_by = Yii::app()->user->id;

                    $model_projectmodule[$i]->updated_date_time = date('Y-m-d H:i:s');

                }

            }

            if($total!=100){

                echo '["Weightage sum should be equal to 100"]';

            }else{

                foreach ($model_projectmodule as $i => $item) {

                    $item->save(false);

                } 

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);

            }

        }

    }

    public function actionRemovelineItem(){

        $id = $_POST['id'];

        if($id>0){

            MasProjectModule::model()->deleteByPk($id);

           $status['status'] = 'success';

        }

        else{

           $status['status'] = 'error';

        }

        echo CJSON::encode($status);

    }
    public function actionDeleteType(){

        $id = $_POST['id'];

        if($id>0){

            MasWorkspaceProject::model()->deleteByPk($id);

           $status['status'] = 'success';

        }

        else{

           $status['status'] = 'error';

        }

        echo CJSON::encode($status);

    }

    function nextkeyvalue(){

        $model_key = nextkeyvalue::model()->find(array('select' => 'max(key_value) as key_value'));

        $next_key_value=1;

        if($model_key->key_value>0){

            $next_key_value=$model_key->key_value+1;

        }

        return $next_key_value;

    }

}

