<?php



class MastermoduleController extends Controller {



   

    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array('allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('Index', 'GetList', 'Create', 'Save', 'Edit','SaveWeightage','RemovelineItem','getProjecttype','DeleteType'),

                'expression' => '$user->isMember()',

            ),

            array('deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function actionIndex() {

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('index');

    }



    public function actionGetList() {

        $model = new MasProjectModule();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 'module',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition = "  (module LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->with('project_detail')->findAll(array('condition' => $condition, 'limit' => $limit,'group'=>'project_id', 'offset' => $offset,'order' => 'project_id'));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

             $div = '';

            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'workspace/mastermodule/create&id=' . $row->project_id . '\',\'Module\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $div .= ' <button class="btn btn-primary btn-xs" onclick="DeleteType('.$row->id.')"><i class="fa fa-close"></i></button>';

           // $rowData[] = array($m, $row->module, $row->id);

            $rowData[] = array($m,

                $row->project_detail->project,

                '<div class="btn-wrap text-center">' . $div . '</div>',

                $row->id,

            );

            $m++;

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }



    public function actionCreate() {

        $model = array(new MasProjectModule());

        $id = (int)Yii::app()->request->getParam('id');

        if ($id>0) {

            $model = MasProjectModule::model()->findAll(array('condition'=>'project_id="'.$id.'"'));

            if(empty($model)){

                $model = array(new MasProjectModule());

            }

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model,'project_id'=>$id), false, true);

    }



    public function actionSave() {

        if (isset($_POST['MasProjectModule'])) {   

            $total=0;

            $other_error=array();

            $validate=true;

          //  $key_value=$this->nextkeyvalue();

            foreach ($_POST['MasProjectModule'] as $i => $item) {  

                if ($item['id'] > 0) {

                    $model[$i] = MasProjectModule::model()->findByPK($item['id']);

                    $model[$i]->updated_by = Yii::app()->user->id;

                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');

                }else{

                    $model[$i] = new MasProjectModule();

                    $model[$i]->created_by = Yii::app()->user->id;

                    $model[$i]->created_date_time = date('Y-m-d H:i:s');

                  //  $model[$i]->key_value = $key_value;

                }

                $model[$i]->project_id = $_POST['project'];

                $model[$i]->module = $item['module'];

                $model[$i]->default_weightage = $item['default_weightage'];

                $total+=$item['default_weightage'];

                $validate=$model[$i]->validate() && $validate;

            }

            if($total!=100){

                $validate=false;

                $other_error[]='Total Weightage must be equal to 100';

            }

            if($_POST['project']==''){

                $validate=false;

                $other_error[]='project cannot be blank';

            }

            if ($validate) {                

                if (!empty($model)) {



                    foreach ($model as $eachModel) {

                        $eachModel->save();

                    }

                }

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);

            } else {             

                $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error1, $other_error));

                if ($error != '[]')

                    echo $error;

            }

        }

        Yii::app()->end();

    }

    public function actiongetProjecttype() {

        $id = Yii::app()->request->getparam("project");

        if (!empty($id)) {

            $model= MasProjectModule::model()->findAll(array('condition'=>'project_id="'.$id.'"'));

            if(empty($model)){

                $model = array(new MasProjectModule());

            }

            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);

            $this->render('main_module_details', array('model' => $model,'module' => $id));

        }else{

            throw new CHttpException(404, 'Page not found.');

        }



    }





    public function actionRemovelineItem(){

        $id = $_POST['id'];

        if($id>0){

            MasProjectModule::model()->deleteByPk($id);

           $status['status'] = 'success';

        }

        else{

           $status['status'] = 'error';

        }

        echo CJSON::encode($status);

    }

    public function actionDeleteType(){

        $id = $_POST['id'];

        if($id>0){

            MasProjectModule::model()->deleteByPk($id);

           $status['status'] = 'success';

        }

        else{

           $status['status'] = 'error';

        }

        echo CJSON::encode($status);

    }
}

