<?php

class MasterController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'create', 'save', 'deleteItem','RemoveWorkspaceqtn','Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['workspace_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['workspace_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
}

    // public function actionGetList() {
    //     $model = new Workspace();
    //     $draw = $_POST['draw'];
    //     $offset = $_POST['start'];
    //     $limit = $_POST['length'];
    //     $columns = array(
    //         // datatable column index  => database column name
    //         0 => 'id',
    //         1 => 'name',
    //         2 => 'color_code',
    //         3 => 'sort_order',
    //         //4 => 'sort_order'
    //     );
    //     $filterColumn = $columns[$_POST['order'][0]['column']];
    //     $filterOrder = $_POST['order'][0]['dir'];
    //     $orderBy = $filterColumn . " " . $filterOrder;
    //     $condition = '1=1 ';
    //     if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
    //         $searchString = $_POST['search']['value'];
    //         $condition .= " and (name LIKE '%" . $searchString . "%' )";
    //     }
    //     $count = $model->count(array('condition' => $condition));
    //     $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
    //     $recordsTotal = $count;
    //     $recordsFiltered = $count;
    //     $data['draw'] = $draw;
    //     $data['recordsTotal'] = $recordsTotal;
    //     $data['recordsFiltered'] = $recordsFiltered;
    //     $rowData = array();
    //     $m = 1;
    //     $type_array = array(
    //                         'SA' => 'Sales',
    //                         'PR' => 'Purchase',
    //                         'PO' => 'Production',
    //                         'CF' => 'Contact',
    //                         'PL' => 'Pipeline',
    //                         'ST' => 'Inventory',
    //                         'FI' => 'Finance',
    //                         'IN' => 'Info',
    //                     );
    //     foreach ($model as $row) {
    //         // $div = '';
    //         // $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'workspace/master/create&id=' . $row['id'] . '\',\'Workspaces\',\'lg\')"><i class="fa fa-pencil"></i></button>';
    //         // $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteWorkspaces(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';

    //         $rowData[] = array($m,
    //             $row['name'],
    //             $type_array[$row->ai_type_id],
    //             $row['isDefault'],
    //             array('id' => $row['id'],'code'=>$row['name'], 'status' => $row->isActive));
    //         $m++;
    //     }
    //     $data['data'] = $rowData;
    //     echo json_encode($data);
    // }
        public function actionGetList() {
        $model = new Workspace();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];

        $columns = array(
            0 => 'id',
            1 => 'name',
            2 => 'color_code',
            3 => 'sort_order',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (name LIKE '%" . $searchString . "%')";
        }
        if (!empty($_POST['ai_type_id'])) {
            $condition .= " AND ai_type_id = '" . $_POST['ai_type_id'] . "'";
        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array(
            'condition' => $condition,
            'limit' => $limit,
            'offset' => $offset,
            // Don't sort in SQL since we're sorting in PHP
        ));

        // Create the type name mapping
        $type_array = array(
            'SA' => 'Sales',
            'PR' => 'Purchase',
            'PO' => 'Production',
            'CF' => 'Contact',
            'PL' => 'Pipeline',
            'ST' => 'Inventory',
            'FI' => 'Finance',
            'IN' => 'Info',
        );

        // Sort the $type_array by value
        uasort($type_array, function ($a, $b) {
            return strcmp($a, $b); // Ascending order
        });

        // Get sorted type keys (e.g., ['CF', 'FI', ...])
        $type_order = array_keys($type_array);

        // Sort the model array first by ai_type_id (as per type_order), then by sort_order
        usort($model, function ($a, $b) use ($type_order) {
            $typeA = array_search($a->ai_type_id, $type_order);
            $typeB = array_search($b->ai_type_id, $type_order);
            if ($typeA === $typeB) {
                return $a->sort_order <=> $b->sort_order;
            }
            return $typeA <=> $typeB;
        });

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $rowData[] = array(
                $m,
                $row['name'],
                $type_array[$row->ai_type_id], // use the mapped label
                $row['sort_order'],
                $row['isDefault'],
                array(
                    'id' => $row['id'],
                    'code' => $row['name'],
                    'status' => $row->isActive
                )
            );
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }


    public function actionCreate() {
        $model = new Workspace();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
// ----indhu-04-08-2022------------

$condition = 'isActive=  "Y"';
    $condition .= ' and workspace_id=' .$id;


            $modelWorkspaceQtns = WorkspaceQtns::model()->findAll(array('condition' => $condition));
            if (empty($modelWorkspaceQtns)) {
                $modelWorkspaceQtns = array(new WorkspaceQtns());
            }
//end
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'modelWorkspaceQtns' => $modelWorkspaceQtns), false, false);
    }

    public function actionSave() {
        $model = new Workspace();
        $validate = true;
        if (isset($_POST['Workspace'])) {
            if ((int) @$_POST['Workspace']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['Workspace']['id'];
                $model = $model->findByPk($id);
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }
            if($_POST['Workspace']['isDefault'] == "Y"){
                	Workspace::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            	}
            $model->isDefault = $_POST['Workspace']['isDefault'];
            
            $model->attributes = $_POST['Workspace'];
            $model->bg_color_code = $_POST['Workspace']['bg_color_code'];
            $validate = $model->validate();
// ------------------------

            $modelqtn = [];

            // if (is_array($_POST['WorkspaceQtns'])) {

               
            //     foreach ($_POST['WorkspaceQtns'] as $i => $item) {
            //       $modelqtn[$i] = new WorkspaceQtns();
            //         if (!empty($item['id'])) {
            //             $modelqtn[$i] = $modelqtn[$i]->findByPk($item['id']);
            //         }
            //         $modelqtn[$i]->workspace_id = 0;
            //         $modelqtn[$i]->details = $item['details'];
            //         $modelqtn[$i]->sort_order = $item['sort_order'];
            //         $validate = $validate && $modelqtn[$i]->validate();
            //     }
            // }

//

            if ($validate) {

                $model->save();

                // foreach ($modelqtn as $eachModel) {


                //     $eachModel->workspace_id = $model->id;

                //     $eachModel->save(false);
                // }

                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {

                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($modelUomDetails))
                    $error2 = json_decode(CActiveForm::validateTabular($modelqtn, '', false), true);
                else{
                    // $error2[] = "Please add atleast one Qtn";
                   if($error2!='' && (!empty($error1)))
                    {$error = CJSON::encode(array_merge_recursive($error1, $error2));}
                    else{
                    $error='[]';
                 }

                 }

                if ($error != '[]') {
                    echo $error;
                }



                
            }
        }
    }

    public function actiondeleteItem() {
        $jsonData['status'] = 'success';
        $item_id = (int) Yii::app()->request->getParam('id');
        Workspace::model()->deleteByPk($item_id);
        echo json_encode(array('status' => 'success', 'id' => $item_id));
    }

    public function actionRemoveWorkspaceqtn() {

        $id = $_POST['id'];
        if ($id > 0) {
           $model = new WorkspaceQtns();
             $model = $model->findByPk($id);
             $model->isActive = 'N';
            //WorkspaceQtns::model()->deleteByPk($id);
            $model->save();
            echo "success";

        } else {
            echo "fail";
        }


    }

public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new Workspace();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    

}
