<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
//created by Dikson R on 11/5/2022
?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_admin_projectwork_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            data.project_id = $("#project_id").val();
//            data.work_date = $("#work_date").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            columns: [
                {className: "nw"},
                {className: "nw sl col-max-2"},
                {className: "nw sl col-max-2"},
                {className: "nw sl col-max-3"},
                {className: "nw sl col-max-2"},
                 {className: "nw sl col-max-2"},
                {className: "nw sl col-max-4"},
                {className: "nw sl col-max-1"},
            ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('workshop/projectworktime/GetTasktimelist') ?>",
                type: "POST",
                cache: false,
            },
            order: [[ 3, "desc" ]],	
            serverSide: true,
            fixedColumns: true,
        });
//        $('#work_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.hide', function (e) {
//            reloadTable("#tbl_admin_projectwork_details");
//        })
    });

</script>
<section class="panel" >
    <header class="panel-heading clearfix panel-theame">
        <i class="material-icons"></i>Admin Project Time
        <div class="top_controls_select col-sm-8 pull-right"> 
            <div class="col-sm-1 pull-right">

                <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["project_work_time_admin_add"])) { ?>
                    <a class="ad-btn"  onclick="loadPopupModal('workshop/projecttimesheet/worksheet', 'Add  Project Work Time', 'xl')" title="Add">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php }
                ?>
            </div>
<!--            <div class="col-sm-2 pull-right">
                <?php // echo CHtml::textField('work_date', date('d/m/Y'), array('class' => 'form-control datepicker', 'data-label' => 'Date')); ?>
            </div>-->
            <div class="pull-right">
                <?php echo CHtml::dropdownlist('project_id', '', WsProject::getProject(), array('class' => 'form-control', 'onChange' => 'reloadTable("#tbl_admin_projectwork_details")', 'prompt' => '--Project--')); ?>
            </div>
        </div>
    </header>
    <div class="panel-body">
        <div class="document-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_admin_projectwork_details" style="font-size:12px;">
                <thead>
                    <tr>
                        <th>Sl. No</th> 
                        <th>Work Date</th>
                        <th>Project ID</th>
                        <th>Project</th>
                        <th>Employee</th>
                        <th>Task</th>
                        <th>Sub Task</th>
                        <th>Total Hrs</th>
                </thead>
            </table>
        </div>
    </div>
</section>