<?php

$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;

//Modified by Dikson R on 10/5/2022

?>

<script>

    $(document).ready(function () {

        var table_id = "#tbl_projectwork_details";

        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {

            data.display_type = $("#display_type").val();

            data.project_id = $("#project_id").val();

            data.employee_id = $("#employee_id").val();

            data.work_date = $("#work_date").val();



            return data;

        }).DataTable({

            scrollY: "645px",

            pageLength: 50,

            processing: true,

            columns: [

                {className: "nw"},

                {className: "nw sl col-max-2"},

                {className: "nw sl col-max-2"},

                {className: "nw sl col-max-5"},

                {className: "nw sl col-max-1"},

                {className: "nw sl col-max-1"},

                {className: "nw sl col-max-1"},

                {className: "nw sl col-max-1"},

                {className: "nw sl col-max-1"},

                {className: "nw sl col-max-1"},

                {className: "nw sl col-max-1"},

                {className: "nw sl col-max-1"},

            ],

            ajax: {

                url: "<?php echo Yii::app()->createUrl('workshop/projectworktime/Getlist') ?>",

                type: "POST",

                cache: false,

            },

            columnDefs: [

                {

                   "targets": [11],"visible": false,

                },

            ],

            order: [[ 4, "asc" ]],

            "rowCallback": function ( row, data ){ 

                if(data[10]=="E" ){

                    $("td", row).css("background-color", "#ffcccb");

                }

            },	

            serverSide: true,

            fixedColumns: true,

        });

        $('#work_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.hide', function (e) {

            reloadTable("#tbl_projectwork_details");

        })

    });



</script>

<section class="panel" >

    <header class="panel-heading clearfix panel-theame">

        <!-- <i class="material-icons"></i> -->
        Labour Project Time

        <!--<div class="top_controls_select col-sm-8 pull-right">--> 
        
            <div class="pull-right">

                <div class="col-md-4">
                <?php echo CHtml::textField('work_date', date('d/m/Y'), array('class' => 'col-sm-3 form-control_1 datepicker', 'data-label' => 'Date','style'=>'width:150px;')); ?>
                </div>
                <?php echo CHtml::dropdownlist('employee_id', '', Employee::getEmployeedetail($attendance_manager), array('class' => 'col-sm-3 form-control_1', 'onChange' => 'reloadTable("#tbl_projectwork_details")', 'prompt' => '--Employee--','style'=>'width:150px;')); ?>

                <?php echo CHtml::dropdownlist('project_id', '', WsProject::getProject(), array('class' => 'col-sm-3 form-control_1', 'onChange' => 'reloadTable("#tbl_projectwork_details")', 'prompt' => '--Project--','style'=>'width:150px;')); ?>

                <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["project_work_time_add_menu"])) { ?>

                     <a class="ad-btn" onclick="loadPopupModal('workshop/projecttimesheet/index', 'Add  Project Work Time', 'xl')" title="Add">
                     <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php }

                ?>


        </div>

    </header>

    <div class="panel-body">

        <div class="document-data-table">

            <table class="table table-hover table-bordered personal-task" id="tbl_projectwork_details" style="font-size:12px;">

                <thead>

                    <tr>

                        <th>Sl. No</th>

                        <th>Project</th>

                        <th>Company/Branch</th>

                        <th>Employee</th>

                        <th>Work Date</th>

                        <th>Start</th>

                        <th>End</th>

                        <th>Total Time</th>

                        <th>Work Hrs</th>

                        <th>Traveling Hrs</th>

                        <th>Idle Hrs</th>

                        <th></th>

                    </tr>

                </thead>

            </table>

        </div>

        <div class="color-indicator">

            <span style="display: inline-block;width:30px;height:30px;background:#ffffff; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Company Staff</span>

            <span style="display: inline-block;width:30px;height:30px;background:#ffcccb; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> External Staff</span>

        </div>

    </div>

</section>
