<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'labour_edit-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'company_name', array('data-label' => 'Company Name <span style="color:red">*</span>')); ?>
            </li>	
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'employee_name', array('data-label' => 'Employee Name <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'designation', array('data-label' => 'Designation <span style="color:red">*</span>')); ?>
            </li> 
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'emirated_id', array('data-label' => 'Emirates ID No')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="labour_edit_close" data-dismiss="modal">Close</button>
<?php
    $url = Yii::app()->createUrl('/workshop/externallabour/UpdateLabour');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                 t8.success("Details Saved Successfully!");
                 $("#labour_edit_close").click();
                reloadTable("#tbl_external_labour");
            } else { 
                $.each(data, function(key, val) {
                    t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $(".toast8-error").hide(); 
            $("#labour_edit-form .edit_labour-save-btn").prop("disabled", true);
            $("#labour_edit-form .edit_labour-save-btn").addClass("btn_loding").removeClass("btn-theme");
        }',
        'complete' => 'function(){
            $("#loader").hide();
            $("#labour_edit-form .edit_labour-save-btn").prop("disabled", false);
            $("#labour_edit-form .edit_labour-save-btn").addClass("btn-theme").removeClass("btn_loding");
        }'
), array('id' => 'mybtn' . rand(), 'class' => 'edit_labour-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>

