<div class="popup_inner_element">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'compressor-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
    ?>

    <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
        <li class="active"><a href="#compressor_tab1" data-toggle="tab">General</a></li>
        <li><a href="#compressor_tab2" data-toggle="tab">Additional Details</a></li>
        <li><a href="#compressor_tab3" data-toggle="tab">Stage Details</a></li>
        <li><a href="#compressor_tab4" data-toggle="tab">Time</a></li>
    </ul>

    <div class="tab-content">
        <div class="tab-pane active" id="compressor_tab1">
            <?php $this->renderPartial('general', array('model' => $model, 'form' => $form)); ?>                
        </div> 
    
        <div class="tab-pane" id="compressor_tab2">
            <?php $this->renderPartial('additional_details', array('model' => $model,'modelOtherDetails' => $modelOtherDetails, 'form' => $form)); ?>                
        </div> 
        <div class="tab-pane" id="compressor_tab3">
            <?php $this->renderPartial('stagedetails', array('model' => $model,'no_of_stages' => $no_of_stages ,'modelStageDetails' => $modelStageDetails, 'form' => $form)); ?>                
        </div> 
         
        <div class="tab-pane" id="compressor_tab4">
            <?php $this->renderPartial('time', array('model' => $model,'modelCompressorTime' => $modelCompressorTime, 'form' => $form)); ?>  
        </div>
        
    </div>

    <div class="modal-footer">

        <button type="button" class="btn btn-danger" id="compressor_close"  data-dismiss="modal">Close</button>

        <?php
        $url = Yii::app()->createUrl('workshop/compressor/Save');



        echo CHtml::ajaxSubmitButton('Save', $url, array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {  

                if(data.status=="success"){  
                    t8.success("compressor Saved!","Success");  
                    $("#compressor_close").click();
                    reloadTable("#tbl_compressor");
                    //location.href="index.php?r=workshop/compressor/index";

                } else { 
                    $("#loader").hide();
                    $("#compressor-form .compressor-save-btn").prop("disabled", false);
                    $("#compressor-form .compressor-save-btn").addClass("btn-theme").removeClass("btn_loding");
                    $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                    }); 
                } 
                            }',
            'beforeSend' => 'function(){
                $(".toast8-error").hide(); 
                $("#loader").show();
                $("#compressor-form .compressor-save-btn").prop("disabled", true);
                $("#compressor-form .compressor-save-btn").addClass("btn_loding").removeClass("btn-theme");
            }',
            'complete' => 'function(){
                $("#loader").hide();
            }'
                ), array('id' => 'save_convert' . rand(), 'class' => 'compressor-save-btn btn btn-theme'));
        ?>
    </div>  
    <?php $this->endWidget(); ?>

    <?php
    $cs = Yii::app()->getClientScript();
    $cs->registerScript("documentupload", "function documentupload(type_id){
    jQuery.ajax({
      'data' :{'type_id':type_id},
    //  'dataType' : 'json',
      'type':'post',
      'url': '" . Yii::app()->createUrl('workshop/compressor/documentupload') . "',
      'success': function(data) {
        $('#document_upload_2').show();   
        $('#document_upload_2').html(data);

  }
 });
}", CClientScript::POS_HEAD);


$cs = Yii::app()->getClientScript();
$cs->registerScript("addstages", " function addstages() {
        var noofstages;
        var noofstages=$('#CompressorHeader_no_of_stages').val();
       
        $('#no_of_stages').val(noofstages);
        $('#no_of_stages').addClass('filled');
        for(i = 1; i <= noofstages; i++) { 
           var stage_arr = [i];
           var noofstages=$('#CompressorHeader_no_of_stages').val();
        }
        return false;
    }", CClientScript::POS_HEAD);
    
    ?>
    
    

</div>