<?php

/**
 * This is the model class for table "{{ws_project_labour_time}}".
 *
 * The followings are the available columns in table '{{ws_project_labour_time}}':
 * @property integer $id
 * @property integer $project_id
 * @property integer $phase_id
 * @property integer $total_years
 * @property integer $total_months
 * @property integer $total_days
 * @property integer $total_hours
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class WsProjectLabourTime extends CActiveRecord
{
	 public $phasename;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_project_labour_time}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_id, phase_id, total_years, total_months, total_days, total_hours, created_by, created_date_time, updated_by, updated_date_time', 'required'),
			array('project_id, phase_id, total_years, total_months, total_days, total_hours, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_id, phase_id, total_years, total_months, total_days, total_hours, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'phase_details' => array(self::BELONGS_TO, 'WsProjectPhase','phase_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_id' => 'Project',
			'phase_id' => 'Phase',
			'total_years' => 'Total Years',
			'total_months' => 'Total Months',
			'total_days' => 'Total Days',
			'total_hours' => 'Total Hours',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('phase_id',$this->phase_id);
		$criteria->compare('total_years',$this->total_years);
		$criteria->compare('total_months',$this->total_months);
		$criteria->compare('total_days',$this->total_days);
		$criteria->compare('total_hours',$this->total_hours);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return WsProjectLabourTime the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
