<?php

/**
 * This is the model class for table "{{ws_project}}".
 *
 * The followings are the available columns in table '{{ws_project}}':
 * @property integer $id
 * @property integer $job_id
 * @property string $project_name
 * @property string $location
 * @property string $project_date
 * @property string $manager_name
 * @property string $notes
 * @property string $isActive
 * @property string $engineer_notes
 * @property string $project_manager_notes
 * @property integer $project_type
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class WsProject extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $customer_name;
	public function tableName()
	{
		return '{{ws_project}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_name, customer_id,location, project_date', 'required'),
			array('manager_name,created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('project_name, location', 'length', 'max'=>500),
                        array('project_name', 'unique'),
			array('manager_name', 'length', 'max'=>50),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('project_name, location,project_date, manager_name, notes, isActive, engineer_notes, project_manager_notes, project_type, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'customer_details' => array(self::BELONGS_TO, 'Customer','customer_id'),
                    'estimationDetails' => array(self::HAS_MANY, 'WsProjectEstimationDetails', 'project_id'),
                    'employeedetails' => array(self::BELONGS_TO, 'Employee','manager_name'), //added on 23/5/2022 by DIkson
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job Id',
			'customer_id' =>'Customer',
			'project_name' => 'Project Name',
			'location' => 'Location',
			'project_date' => 'Project Date',
			'manager_name' => 'Manager Name',
			'notes' => 'Notes',
			'isActive' => 'Is Active',
			'engineer_notes' => 'Engineer Notes',
			'project_manager_notes' => 'Project Manager Notes',
			'project_type' => 'Project Type',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('project_name',$this->project_name,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('project_date',$this->project_date,true);
		$criteria->compare('manager_name',$this->manager_name,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('engineer_notes',$this->engineer_notes,true);
		$criteria->compare('project_manager_notes',$this->project_manager_notes,true);
		$criteria->compare('project_type',$this->project_type);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return WsProject the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getAllProj() 
	{
        
        $condition = 'status =  "E" OR status =  "P" OR status =  "PJ"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'id'));
        return CHtml::listData($model, 'id', 'project_name');
    }
    //added by abin on 04-12-2023
     public function getprojectdetail() {
            return $this->id.'-'.$this->project_name;
        }
    
    //Created by DIkson on 27/4/2022
    public static function getProject(){
        $condition = 'status!="C"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'id'));
        return CHtml::listData($model, 'id', 'projectdetail');
    }
    
    public static function getProjects($id){
        $condition = 'status!="C" and id="'.$id.'"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'id'));
        return CHtml::listData($model, 'id', 'projectdetail');
    }

	public static function getProjectAll(){
        $condition = 'status!="C"';
        $condition = 'status!="H"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'id'));
        return CHtml::listData($model, 'id', 'projectDisplay');
    }
	public function getProjectDisplay()
	{
		return $this->project_name . ' - ' . $this->id;
	}
}
