<?php

/**
 * This is the model class for table "{{ws_master_task_sub_category}}".
 *
 * The followings are the available columns in table '{{ws_master_task_sub_category}}':
 * @property integer $id
 * @property integer $task_category_id
 * @property string $subcategory_name
 * @property string $is_active
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class WsMasterTaskSubCategory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_master_task_sub_category}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('task_category_id, subcategory_name, created_by, created_date_time, hourly_rate', 'required'),
			array('task_category_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('subcategory_name', 'length', 'max'=>255),
			array('subcategory_name', 'unique', 'message'=>'This subcategory name already exists.'),
			array('is_active', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, task_category_id, subcategory_name, hourly_rate, is_active, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'task_cat_details' => array(self::BELONGS_TO, 'WsMasterTaskCategory', 'task_category_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'task_category_id' => 'Task Category',
			'subcategory_name' => 'Subcategory Name',
			'hourly_rate'	=> 'Hourly rate',
			'is_active' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('task_category_id',$this->task_category_id);
		$criteria->compare('subcategory_name',$this->subcategory_name,true);
		$criteria->compare('hourly_rate',$this->hourly_rate,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return WsMasterTaskSubCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	
	public static function getsubtasklist($task_id=0){
            $condition = 'is_active="Y"';
           
            if($task_id>0){
                $condition.= ' AND task_category_id="'.$task_id.'"';
            }
           
            //echo $condition;exit;
            $model = self::model()->findAll(array('condition' => $condition));
            return CHtml::listData($model, 'id', 'subcategory_name');
        }
	
	
}
