<?php

/**
 * This is the model class for table "{{ws_master_material_submited_scheduled_details}}".
 *
 * The followings are the available columns in table '{{ws_master_material_submited_scheduled_details}}':
 * @property integer $id
 * @property string $alternate_id
 * @property integer $type_id
 * @property integer $project_id
 * @property integer $main_id 
 * @property string $drawing_no
 * @property string $title
 * @property string $location
 * @property string $reference
 * @property string $planned_submission_date
 * @property string $actual_submission_date
 * @property string $returned_date
 * @property string $status
 * @property string $note
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class WsMasterMaterialSubmitedScheduledDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_master_material_submited_scheduled_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type_id, project_id, drawing_no, title, location, reference, planned_submission_date, created_by , created_date_time', 'required'),
			array('type_id, project_id,main_id,main_id_status,created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('alternate_id, drawing_no, title, location, reference, note', 'length', 'max'=>255),
			array('status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, alternate_id,main_id,main_id_status, type_id, project_id, drawing_no, title, location, reference, planned_submission_date, actual_submission_date, returned_date, status, note, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(

			'type_det' => array(self::BELONGS_TO, 'WsMasterMaterialScheduledType', 'type_id'),

		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'alternate_id' => 'Alternate',
			'type_id' => 'Type',
			'project_id' => 'Project',
			'drawing_no' => 'Drawing No',
			'title' => 'Title',
			'location' => 'Location',
			'reference' => 'Reference',
			'planned_submission_date' => 'Planned Submission Date',
			'actual_submission_date' => 'Actual Submission Date',
			'returned_date' => 'Returned Date',
			'status' => 'Status',
			'note' => 'Note',
			'created_by' => 'Cretaed By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('alternate_id',$this->alternate_id,true);
		$criteria->compare('type_id',$this->type_id);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('drawing_no',$this->drawing_no,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('reference',$this->reference,true);
		$criteria->compare('planned_submission_date',$this->planned_submission_date,true);
		$criteria->compare('actual_submission_date',$this->actual_submission_date,true);
		$criteria->compare('returned_date',$this->returned_date,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('note',$this->note,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return WsMasterMaterialSubmitedScheduledDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
