<?php

/**
 * This is the model class for table "{{ws_admin_timesheet}}".
 *
 * The followings are the available columns in table '{{ws_admin_timesheet}}':
 * @property integer $id
 * @property integer $proj_id
 * @property integer $proj_details_id
 * @property integer $proj_status
 * @property integer $employee_id
 * @property string $checkin_time
 * @property string $checkout_time
 * @property string $checkout_remarks
 * @property string $status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class WsAdminTimesheet extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_admin_timesheet}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('proj_id,employee_id', 'required'),
			array('proj_id, proj_details_id, proj_status, employee_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, proj_id, proj_details_id, proj_status, employee_id, checkin_time, checkout_time, checkout_remarks, status, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'employee_details' => array(self::BELONGS_TO, 'Employee','employee_id'),
		    'proj_details' => array(self::BELONGS_TO, 'WsProject','proj_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'proj_id' => 'Proj',
			'proj_details_id' => 'Proj Details',
			'proj_status' => 'Proj Status',
			'employee_id' => 'Employee',
			'checkin_time' => 'Checkin Time',
			'checkout_time' => 'Checkout Time',
			'checkout_remarks' => 'Checkout Remarks',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('proj_id',$this->proj_id);
		$criteria->compare('proj_details_id',$this->proj_details_id);
		$criteria->compare('proj_status',$this->proj_status);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('checkin_time',$this->checkin_time,true);
		$criteria->compare('checkout_time',$this->checkout_time,true);
		$criteria->compare('checkout_remarks',$this->checkout_remarks,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return WsAdminTimesheet the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
