<?php

/**
 * This is the model class for table "{{ws_joborder_testresults}}".
 *
 * The followings are the available columns in table '{{ws_joborder_testresults}}':
 * @property integer $id
 * @property string $type
 * @property string $description
 * @property string $part_number
 * @property string $tested_limit
 * @property string $status
 * @property string $compressor_id
 * @property integer $tested_by
 * @property string $tested_date
 * @property integer $created_by
 * @property string $created_date_time
 */
class JoborderTestresults extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_joborder_testresults}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('stage_id,part_number', 'required'),
			array('stage_id,tested_by, created_by,compressor_id', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>25),
			array('description, part_number,status', 'length', 'max'=>255),
			array('tested_limit,allow_limit, status', 'length', 'max'=>30),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, type, description, part_number, tested_limit, status, tested_by, tested_date, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'compressor_details' => array(self::BELONGS_TO, 'CompressorHeader','compressor_id'),
		    'compressor_stages' => array(self::BELONGS_TO, 'MasterCompressorStages','stage_id'),  
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'type' => 'Type',
			'description' => 'Description',
			'part_number' => 'Part Number',
			'tested_limit' => 'Tested Limit',
			'status' => 'Status',
			'tested_by' => 'Tested By',
			'tested_date' => 'Tested Date',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('tested_limit',$this->tested_limit,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('tested_by',$this->tested_by);
		$criteria->compare('tested_date',$this->tested_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return JoborderTestresults the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
