<?php

/**
 * This is the model class for table "{{ws_joborder_details}}".
 *
 * The followings are the available columns in table '{{ws_joborder_details}}':
 * @property integer $id
 * @property integer $job_id
 * @property integer $compressor_id
 * @property integer $stage_id
 * @property integer $product_id
 * @property integer $part_number
 * @property integer $stage_no_id
 * @property integer $quantity
 * @property integer $created_by
 * @property string $created_date_time
 * @property string $serv_or_prod
 */
class JoborderDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	 public $type;
	 public $serv_or_prod;
	public $compressor_name; 
	public $stage_type;
	
	public function tableName()
	{
		return '{{ws_joborder_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		//NOTE: you should only define rules for those attributes that
		//will receive user inputs.
		return array(
			array('job_id, stage_no_id,compressor_id, stage_id, product_id, quantity, created_by', 'numerical', 'integerOnly'=>true),
			array('stage_no_id,part_number,stage_type_id', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, job_id, compressor_id, stage_no_id,stage_id, product_id, part_number, quantity, created_by, created_date_time,serv_or_prod', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'compressor_details' => array(self::BELONGS_TO, 'CompressorHeader','compressor_id'),
		    'compressor_stagedetails' => array(self::BELONGS_TO, 'CompressorStageDetails','stage_no_id'),
		    'compressor_stages' => array(self::BELONGS_TO, 'MasterCompressorStages','stage_type_id'),  
		    'product' => array(self::BELONGS_TO, 'Store','product_id'),  
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Joborder',
			'compressor_id' => 'Compressor',
			'stage_no_id' => 'Stage no id',
			'stage_id' => 'Stage',
			'product_id' => 'Product',
			'part_number' => 'Part Number',
			'quantity' => 'quantity',
			'serv_or_prod' => 'Setvice or Production',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('compressor_id',$this->compressor_id);
		$criteria->compare('stage_id',$this->stage_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('part_number',$this->part_number);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return JoborderDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
