<?php

/**
 * This is the model class for table "{{ws_joborder_billofmaterial_item}}".
 *
 * The followings are the available columns in table '{{ws_joborder_billofmaterial_item}}':
 * @property integer $id
 * @property integer $billofmaterial_id
 * @property integer $billofmaterial_item_id
 * @property integer $product_id
 * @property integer $stage_product_id
 * @property string $product_name
 * @property string $description
 * @property string $unit
 * @property string $quantity
 * @property string $std_or_nstd
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class JoborderBillofmaterialItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_joborder_billofmaterial_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('billofmaterial_id,job_id, billofmaterial_item_id, description, unit, quantity', 'required'),
			array('billofmaterial_id, ,billofmaterial_item_id, product_id,stage_product_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('product_name, description, unit', 'length', 'max'=>255),
			array('quantity', 'length', 'max'=>15),
			array('std_or_nstd', 'length', 'max'=>2),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, billofmaterial_id, billofmaterial_item_id, product_id, product_name, description, unit, quantity, std_or_nstd, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'billofmaterial_id' => 'Billofmaterial',
			'billofmaterial_item_id' => 'Billofmaterial Item',
			'product_id' => 'Product',
			'product_name' => 'Product Name',
			'description' => 'Description',
			'unit' => 'Unit',
			'quantity' => 'Quantity',
			'std_or_nstd' => 'Std Or Nstd',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('billofmaterial_id',$this->billofmaterial_id);
		$criteria->compare('billofmaterial_item_id',$this->billofmaterial_item_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('product_name',$this->product_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('unit',$this->unit,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('std_or_nstd',$this->std_or_nstd,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return JoborderBillofmaterialItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
