<?php

/**
 * This is the model class for table "crm_employee".
 *
 * The followings are the available columns in table 'crm_employee':
 * @property integer $id
 * @property integer $branch_or_sponsor_id
 * @property string $employee_code
 * @property string $user_name
 * @property string $password
 * @property string $first_name
 * @property string $middle_name
 * @property string $last_name
 * @property integer $designation
 * @property integer $department
 * @property integer $subledger_account_no
 * @property string $father_husband
 * @property string $anniversary_date
 * @property string $present_address
 * @property string $permanent_address
 * @property string $phone
 * @property string $mobile
 * @property string $email
 * @property string $email2
 * @property string $emergency_contact1
 * @property string $emergency_contact2
 * @property string $emergency_contact_mob1
 * @property string $emergency_contact_mob2
 * @property string $friend1_name
 * @property string $friend1_phone
 * @property string $friend1_email
 * @property string $friend2_name
 * @property string $friend2_phone
 * @property string $friend2_email
 * @property integer $gender
 * @property string $date_of_birth
 * @property string $date_join
 * @property string $date_leaving
 * @property string $employee_type
 * @property string $probation_days
 * @property string $probation_date
 * @property integer $reporting_manager
 * @property integer $nationality
 * @property integer $have_pension
 * @property string $marital_status
 * @property string $confirmation_date
 * @property integer $currency
 * @property integer $employee_overtime
 * @property string $employee_bankname
 * @property string $employee_accountno
 * @property string $employee_bankifsc
 * @property string $employee_wpscode
 * @property string $employee_iban_no
 * @property integer $employee_shift
 * @property integer $employee_exclude_biometric
 * @property integer $employee_biometric_code
 * @property integer $employee_wps_company
 * @property string $personal_file_no
 * @property string $salary_commission
 * @property string $overtime
 * @property integer $overtime_type
 * @property integer $leave_reason
 * @property integer $weekend_off1
 * @property integer $weekend_off2
 * @property string $profile_photo
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class Employee extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $employee_wps_company_name;
    public $shift_detail;
    public $old_branch;
    public $old_department;
    public $old_designation;
    public $effective_date;

    public function tableName() {
        return '{{hr_employee}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('branch_or_sponsor_id, employee_code, first_name, last_name, designation, department, employee_biometric_code,currency,date_join', 'required'),
            array('branch_or_sponsor_id, employee_category,designation, department, subledger_account_no, gender, reporting_manager, nationality, have_pension, currency, employee_overtime, employee_shift, employee_exclude_biometric, employee_biometric_code, employee_wps_company, overtime_type, leave_reason, weekend_off1, weekend_off2,marital_status,employee_bankname, created_by, updated_by,payment_type,attendance_manager,salary_calculation_method,designation_visa', 'numerical', 'integerOnly' => true),
            array('employee_code, user_name, password, first_name, middle_name, last_name, father_husband, present_address, permanent_address, friend1_name, friend2_name, employee_accountno, employee_bankifsc, employee_wpscode, employee_iban_no, profile_photo', 'length', 'max' => 500),
            array('phone, email, email2, friend1_phone, friend1_email, friend2_phone, friend2_email, employee_type, probation_days, personal_file_no', 'length', 'max' => 255),
            array('mobile,email,gender,employee_type', 'required', 'on' => 'update'),
            //array('user_name, password', 'required', 'on' => 'password_change'),
            array('email,email2','email'),
            array('phone,mobile,emergency_contact_mob1,emergency_contact_mob2', 'match' ,
                'pattern'=> '/^[0-9+-]+$/u',
                'message'=> '{attribute} contains only numbers and symbols.'
            ),
            array('user_name, password', 'validateuserpassword', 'on' => 'password_change'),
            array('date_join,mobile,email,personal_file_no,nationality,gender', 'required', 'on' => 'excelupload'),
            array('branch_or_sponsor_id', 'validatebranch', 'on' => 'excelupload'),
            array('department', 'validateDepartment', 'on' => 'excelupload'),
            array('designation', 'validateDesignation', 'on' => 'excelupload'),
            array('currency', 'validateCurrency', 'on' => 'excelupload'),
            array('gender', 'validateGender', 'on' => 'excelupload'),
            array('gender', 'validateNationality', 'on' => 'excelupload'),
            array('date_join', 'validateJoinDate', 'on' => 'excelupload'),
            array('mobile', 'length', 'max' => 25),
            array('emergency_contact1, emergency_contact2, emergency_contact_mob1, emergency_contact_mob2', 'length', 'max' => 30),
            array('salary_commission', 'length', 'max' => 5),
            array('overtime, isActive,is_lead_owner,travel_allowance,family_status,insurance,family_ticket,housing_facility,car_facility,post_salary,disciplinary_action', 'length', 'max' => 1),
            array('employee_code', 'filter', 'filter' => 'trim'),
            array('employee_biometric_code', 'filter', 'filter' => 'trim'),
            array('employee_code', 'unique', 'message' => 'Employee code already exist'),
            //array('employee_biometric_code', 'unique', 'message' => 'Biometric code already exist'),
            array('employee_biometric_code', 'validatebiometriccode'),
            array('user_name', 'unique', 'message' => 'Username {value} already exist'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, branch_or_sponsor_id, employee_code, user_name, password, first_name, middle_name, last_name, designation, department, subledger_account_no, father_husband, anniversary_date, present_address, permanent_address, phone, mobile, email, email2, emergency_contact1, emergency_contact2, emergency_contact_mob1, emergency_contact_mob2, friend1_name, friend1_phone, friend1_email, friend2_name, friend2_phone, friend2_email, gender, date_of_birth, date_join, date_leaving, employee_type, probation_days, probation_date, reporting_manager, nationality, have_pension, marital_status, confirmation_date, currency, employee_overtime, employee_bankname, employee_accountno, employee_bankifsc, employee_wpscode, employee_iban_no, employee_shift, employee_exclude_biometric, employee_biometric_code, employee_wps_company, personal_file_no, salary_commission, overtime, overtime_type, leave_reason, weekend_off1, weekend_off2, profile_photo, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function validateuserpassword() {

        if ($this->password == '') {
            $this->addError('password', 'Enter password for ' . $this->user_name);
            $this->rules();
        }
        return true;
    }
    public function validatebiometriccode() {

        if ($this->employee_biometric_code == '') {
            $this->addError('employee_biometric_code', 'Enter Biometric Code');
            return false;
        }else if ($this->employee_biometric_code!= '' && $this->branch_or_sponsor_id!='') {
            $condition='branch_or_sponsor_id="'.$this->branch_or_sponsor_id.'" and employee_biometric_code="'.$this->employee_biometric_code.'"';
            if($this->id!=''){
                $condition.=' AND id!="'.$this->id.'"';
            }
            $model = self::model()->find(array('condition'=>$condition));
            if($model->id>0){
                $this->addError('employee_biometric_code', 'Biometric ID already exist');
                return false;
            }else{
                return true;
            }
        }
        
    }
    public function validatebranch($attribute) {

        $branch = MasCompanyBranchSponsor::model()->findbyPk($this->branch_or_sponsor_id);
        if (empty($branch)) {
            $this->addError($attribute, 'Matching Branch not found');
            return false;
        } else {
            return true;
        }
    }

    public function validateDepartment($attribute) {

        $department = MasDepartment::model()->findbyPk($this->department);
        if (empty($department)) {
            $this->addError($attribute, 'Matching Department not found');
            return false;
        } else {
            return true;
        }
    }

    public function validateDesignation($attribute) {

        $designation = MasDesignation::model()->findbyPk($this->designation);
        if (empty($designation)) {
            $this->addError($attribute, 'Matching Designation not found');
            return false;
        } else {
            return true;
        }
    }

    public function validateNationality($attribute) {

        $country = MasCountry::model()->findbyPk($this->nationality);
        if (empty($country)) {
            $this->addError($attribute, 'Matching Country not found');
            return false;
        } else {
            return true;
        }
    }

    public function validateCurrency($attribute) {

        $currency = MasCurrency::model()->findbyPk($this->currency);
        if (empty($currency)) {
            $this->addError($attribute, 'Matching Currency not found');
            return false;
        } else {
            return true;
        }
    }

    public function validateJoinDate($attribute) {
        $date = $this->date_join;
        if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $date)) {
            return true;
        } else {
            $this->addError($attribute, 'Not in YYYY-mm-dd Format');
            return false;
        }
    }

    public function validateGender($attribute) {

        if ($this->gender == 1 || $this->gender == 2) {
            return true;
        } else {
            $this->addError($attribute, 'Gender not matching');
            return false;
        }
    }

    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'designationdetail' => array(self::BELONGS_TO, 'MasDesignation', 'designation'),
            'overtimetypedetail' => array(self::BELONGS_TO, 'MasOverTime', 'overtime_type'),
            'departmentdetail' => array(self::BELONGS_TO, 'MasDepartment', 'department'),
            'currencydetails' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
            'reportingmanager' => array(self::BELONGS_TO, 'Employee', 'reporting_manager'),
            'branch_sponsor' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch_or_sponsor_id'),
            'employeenationality' => array(self::BELONGS_TO, 'MasCountry', 'nationality'),
            'bankdetail' => array(self::BELONGS_TO, 'MasBank', 'employee_bankname'),
            'employeeshift' => array(self::HAS_MANY, 'EmployeeShift', 'employee_id'),
            'employeesalarydetail' => array(self::HAS_MANY, 'EmployeeSalary', 'employee_id'),
            'employeeshiftdetails' => array(self::BELONGS_TO, 'EmployeeShift', 'employee_shift'),
            'linemanager' => array(self::HAS_MANY, 'ReportingManager', 'employee_id'),
            'wpscompany' => array(self::BELONGS_TO, 'EmployeewpsCompany', 'employee_wps_company'),
            'mailnotification' => array(self::HAS_ONE, 'Mailsettings', 'employee_id'),
            'employeeeosdetails' => array(self::HAS_MANY, 'EmployeeEOS', 'employee_id'),
            'attendancemanager' => array(self::BELONGS_TO, 'Employee', 'attendance_manager'),
            'employeeticketdetails' => array(self::HAS_MANY, 'EmployeeTicketSetting', 'employee_id'),
            'contract' => array(self::BELONGS_TO, 'HrMasJobContract', 'employee_type'),
            'maswps' => array(self::BELONGS_TO, 'MasCompanyWpsDetails', 'employee_wps_company'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'branch_or_sponsor_id' => 'Branch Or Sponsor',
            'employee_code' => 'Employee Code',
            'user_name' => 'User Name',
            'password' => 'Password',
            'first_name' => 'First Name',
            'middle_name' => 'Middle Name',
            'last_name' => 'Last Name',
            'designation' => 'Designation',
            'department' => 'Department',
            'subledger_account_no' => 'Subledger Account No',
            'father_husband' => 'Father Husband',
            'anniversary_date' => 'Anniversary Date',
            'present_address' => 'UAE Address',
            'permanent_address' => 'Native Address',
            'phone' => 'Official Mobile',
            'mobile' => 'Personal Mobile',
            'email' => 'Office Email',
            'email2' => 'Personal Email',
            'emergency_contact1' => 'UAE Emergency Contact',
            'emergency_contact2' => 'Native Emergency Contact',
            'emergency_contact_mob1' => 'UAE Emergency Contact Mobile',
            'emergency_contact_mob2' => 'Native Emergency Contact Mobile',
            'friend1_name' => 'Friend1 Name',
            'friend1_phone' => 'Friend1 Phone',
            'friend1_email' => 'Friend1 Email',
            'friend2_name' => 'Friend2 Name',
            'friend2_phone' => 'Friend2 Phone',
            'friend2_email' => 'Friend2 Email',
            'gender' => 'Gender',
            'date_of_birth' => 'Date Of Birth',
            'date_join' => 'Date Join',
            'date_leaving' => 'Date Leaving',
            'employee_type' => 'Employee Type',
            'probation_days' => 'Probation Days',
            'probation_date' => 'Probation Date',
            'reporting_manager' => 'Reporting Manager',
            'nationality' => 'Nationality',
            'have_pension' => 'Have Pension',
            'marital_status' => 'Marital Status',
            'confirmation_date' => 'Confirmation Date',
            'currency' => 'Currency',
            'employee_overtime' => '1-Yes,2-No',
            'employee_bankname' => 'Employee Bankname',
            'employee_accountno' => 'Employee Accountno',
            'employee_bankifsc' => 'Employee Bankifsc',
            'employee_wpscode' => 'Employee Wpscode',
            'employee_iban_no' => 'Employee Iban No',
            'employee_shift' => 'Employee Shift',
            'employee_exclude_biometric' => '1-Yes,0-No',
            'employee_biometric_code' => 'Employee Biometric Code',
            'employee_wps_company' => 'Employee Wps Company',
            'personal_file_no' => 'Personal File No',
            'salary_commission' => 'Salary Commission',
            'overtime' => 'Overtime',
            'overtime_type' => 'Overtime Type',
            'leave_reason' => '1-Termination, 2- Resignation, 3- Absconding, 4- Stop Hire',
            'weekend_off1' => 'Weekend Off1',
            'weekend_off2' => 'Weekend Off2',
            'profile_photo' => 'Profile Photo',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('branch_or_sponsor_id', $this->branch_or_sponsor_id);
        $criteria->compare('employee_code', $this->employee_code, true);
        $criteria->compare('user_name', $this->user_name, true);
        $criteria->compare('password', $this->password, true);
        $criteria->compare('first_name', $this->first_name, true);
        $criteria->compare('middle_name', $this->middle_name, true);
        $criteria->compare('last_name', $this->last_name, true);
        $criteria->compare('designation', $this->designation);
        $criteria->compare('department', $this->department);
        $criteria->compare('subledger_account_no', $this->subledger_account_no);
        $criteria->compare('father_husband', $this->father_husband, true);
        $criteria->compare('anniversary_date', $this->anniversary_date, true);
        $criteria->compare('present_address', $this->present_address, true);
        $criteria->compare('permanent_address', $this->permanent_address, true);
        $criteria->compare('phone', $this->phone, true);
        $criteria->compare('mobile', $this->mobile, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('email2', $this->email2, true);
        $criteria->compare('emergency_contact1', $this->emergency_contact1, true);
        $criteria->compare('emergency_contact2', $this->emergency_contact2, true);
        $criteria->compare('emergency_contact_mob1', $this->emergency_contact_mob1, true);
        $criteria->compare('emergency_contact_mob2', $this->emergency_contact_mob2, true);
        $criteria->compare('friend1_name', $this->friend1_name, true);
        $criteria->compare('friend1_phone', $this->friend1_phone, true);
        $criteria->compare('friend1_email', $this->friend1_email, true);
        $criteria->compare('friend2_name', $this->friend2_name, true);
        $criteria->compare('friend2_phone', $this->friend2_phone, true);
        $criteria->compare('friend2_email', $this->friend2_email, true);
        $criteria->compare('gender', $this->gender);
        $criteria->compare('date_of_birth', $this->date_of_birth, true);
        $criteria->compare('date_join', $this->date_join, true);
        $criteria->compare('date_leaving', $this->date_leaving, true);
        $criteria->compare('employee_type', $this->employee_type, true);
        $criteria->compare('probation_days', $this->probation_days, true);
        $criteria->compare('probation_date', $this->probation_date, true);
        $criteria->compare('reporting_manager', $this->reporting_manager);
        $criteria->compare('nationality', $this->nationality);
        $criteria->compare('have_pension', $this->have_pension);
        $criteria->compare('marital_status', $this->marital_status, true);
        $criteria->compare('confirmation_date', $this->confirmation_date, true);
        $criteria->compare('currency', $this->currency);
        $criteria->compare('employee_overtime', $this->employee_overtime);
        $criteria->compare('employee_bankname', $this->employee_bankname, true);
        $criteria->compare('employee_accountno', $this->employee_accountno, true);
        $criteria->compare('employee_bankifsc', $this->employee_bankifsc, true);
        $criteria->compare('employee_wpscode', $this->employee_wpscode, true);
        $criteria->compare('employee_iban_no', $this->employee_iban_no, true);
        $criteria->compare('employee_shift', $this->employee_shift);
        $criteria->compare('employee_exclude_biometric', $this->employee_exclude_biometric);
        $criteria->compare('employee_biometric_code', $this->employee_biometric_code);
        $criteria->compare('employee_wps_company', $this->employee_wps_company);
        $criteria->compare('personal_file_no', $this->personal_file_no, true);
        $criteria->compare('salary_commission', $this->salary_commission, true);
        $criteria->compare('overtime', $this->overtime, true);
        $criteria->compare('overtime_type', $this->overtime_type);
        $criteria->compare('leave_reason', $this->leave_reason);
        $criteria->compare('weekend_off1', $this->weekend_off1);
        $criteria->compare('weekend_off2', $this->weekend_off2);
        $criteria->compare('profile_photo', $this->profile_photo, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);
        $criteria->compare('isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Employee the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getEmployeeWithDesignation($branch, $designation) {
        $condition = 'isActive="Y"';
        if ($branch > 0) {
            $condition.=' and branch_or_sponsor_id="' . $branch . '"';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        if ($designation > 0) {
            $condition.=' and designation="' . $designation . '"';
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'first_name'));
        return CHtml::listData($model, 'id', 'employeefullname');
    }

    public function getemployeefullname() {
        return (Yii::app()->controller->ciphertext($this->first_name, "d") . ' ' . Yii::app()->controller->ciphertext($this->middle_name, "d") . ' ' . Yii::app()->controller->ciphertext($this->last_name, "d"));
    }
    public function getemployeenamecode() {
        return (Yii::app()->controller->ciphertext($this->first_name, "d") . ' ' . Yii::app()->controller->ciphertext($this->middle_name, "d") . ' ' . Yii::app()->controller->ciphertext($this->last_name, "d")).' ( '.Yii::app()->controller->ciphertext($this->employee_code, "d").' )';
    }
    public function getemployeecode() {
        return Yii::app()->controller->ciphertext($this->employee_code, "d");
    }

    public static function getEmployee($branch_id = 0) {
        $condition = 'isActive="Y"';
        if ($branch_id > 0) {
            $condition.=' AND branch_or_sponsor_id="' . $branch_id . '"';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        $model = self::model()->findAll(array('condition' => $condition));
        $arr_employee = array();
        $employee_details = array();
        foreach ($model as $key => $value) {
            $arr_employee[$value->employeefullname] = $value->id;
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = $id;
            $employee_details[$m]['name'] = $k;
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }
    // drop down for employee in dashboardmatrixEmployee
    public static function getMatrixEmployees() {
        $condition = 'isActive="Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'de_first_name asc'));
        return CHtml::listData($model, 'id', 'employeefullname');
    }
    public static function getEmployeeforleavesettlement($branch_id = 0) {
        $condition = 't.isActive="Y" and  branch_sponsor.leave_settlement_provided="Y"';
        if ($branch_id > 0) {
            $condition.=' AND branch_or_sponsor_id="' . $branch_id . '"';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        $model = self::model()->with('branch_sponsor')->findAll(array('condition' => $condition));
        $arr_employee = array();
        $employee_details = array();
        foreach ($model as $key => $value) {
            $arr_employee[$value->employeenamecode] = $value->id;
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = $id;
            $employee_details[$m]['name'] = $k;
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }

    public static function EmployeeName($branch_id = 0) {
        $condition = 'isActive="Y"';
        if ($branch_id > 0) {
            $condition = ' AND branch_or_sponsor_id="' . $branch_id . '"';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        $model = self::model()->findAll(array('condition' => $condition));
        $arr_employee = array();
        foreach ($model as $key => $value) {
            $arr_employee[Yii::app()->controller->ciphertext($value->first_name, "d") . ' ' . Yii::app()->controller->ciphertext($value->last_name, "d")] = $value->id;
        }
        ksort($arr_employee);
        return $arr_employee;
    }

    public static function getMultipleBranchEmployee($branch_id) {
        $sql = "SELECT id, first_name,last_name FROM erp_hr_employee WHERE isActive!='B'";
        if ($branch_id != "") {
            $sql.= " AND branch_or_sponsor_id IN(" . $branch_id . ")";
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $sql.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        $model = Yii::app()->db->createCommand($sql)->queryAll();
        $arr_employee = array();
        $employee_details = array();
        foreach ($model as $value) {
            $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d")] = $value['id'];
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = $id;
            $employee_details[$m]['name'] = $k;
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }

    public static function getEosemployee($branch_id = 0) {
        $condition = 'isActive="Y"';
        if ($branch_id > 0) {
            $condition.=' AND branch_or_sponsor_id="' . $branch_id . '"';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        $SQL = " SELECT * FROM  `erp_hr_employee` E WHERE $condition && id 
                   NOT IN (SELECT  employee_id FROM  erp_hr_employee_eos WHERE status!=3)";
        $model = Yii::app()->db->createCommand($SQL)->queryAll();
        $arr_employee = array();
        $employee_details = array();

        foreach ($model as $key => $value) {
            $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d")] = $value['id'];
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = $id;
            $employee_details[$m]['name'] = $k;
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }

    public static function getEmployeebyfilter($branch_id = 0, $department = 0, $designation = 0) {
        $condition = 'isActive="Y"';
        if ($branch_id != '' && $branch_id != 'null') {
            $condition .= ' AND branch_or_sponsor_id IN (' . $branch_id . ')';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        if ($department != '' && $department != 'null') {
            $condition .= ' AND department IN (' . $department . ')';
        }
        if ($designation != '' && $designation != 'null') {
            $condition .= ' AND designation IN (' . $designation . ')';
        }
        $model = self::model()->findAll(array('condition' => $condition));
        $arr_employee = array();
        $employee_details = array();
        foreach ($model as $key => $value) {
            $arr_employee[Yii::app()->controller->ciphertext($value->first_name, "d") . ' ' . Yii::app()->controller->ciphertext($value->last_name, "d")] = $value->id;
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = $id;
            $employee_details[$m]['name'] = $k;
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }
    public static function gettktEmployee($branch_id = 0) {
        $condition = 't.isActive="Y" and branch_sponsor.ticket_provided="Y"';
        if ($branch_id > 0) {
            $condition.=' AND branch_or_sponsor_id="' . $branch_id . '"';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        $model = self::model()->with('branch_sponsor')->findAll(array('condition' => $condition));
        $arr_employee = array();
        $employee_details = array();
        foreach ($model as $key => $value) {
            $arr_employee[Yii::app()->controller->ciphertext($value->first_name, "d") . ' ' . Yii::app()->controller->ciphertext($value->last_name, "d")] = $value->id;
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = $id;
            $employee_details[$m]['name'] = $k;
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }
    public static function getemployeeforreset($branch_id = 0) {
        $condition = 'isActive="Y"';
        if ($branch_id > 0) {
            $condition.=' AND branch_or_sponsor_id="' . $branch_id . '"';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        $SQL ="SELECT * FROM  `erp_hr_employee`  WHERE $condition  && id NOT IN (SELECT  employee_id FROM  erp_hr_initial_password_reset) LIMIT 20";                               
        $model = Yii::app()->db->createCommand($SQL)->queryAll(); 
        $arr_employee = array();
        $employee_details = array();
        foreach ($model as $key => $value) {
            $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d")] = $value['id'];
        }
        ksort($arr_employee);
        $m = 0;
        foreach ($arr_employee as $k => $id) {
            $employee_details[$m]['id'] = $id;
            $employee_details[$m]['name'] = $k;
            $m++;
        }
        return CHtml::listData($employee_details, 'id', 'name');
    }
    public static function getemployeenamesfromidarray($str_ids) {
        
        $emp_name =array(); 
        if($str_ids!=''){
            $arr_emps = explode(',',$str_ids);
            foreach($arr_emps as $i=>$each){
                $mod =self::model()->findByPk($each);
                $emp_name[]=$mod->employeefullname; 
                
            }
        }
        return implode(',',$emp_name);
    }
    public static function getemployeesList($employee_id)
	{
		$condition = 'isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'first_name'));
		return CHtml::listData($model, 'id', 'employeefullname');
	}
	public static function getallemployeesList()
	{
		$condition = 'isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'first_name'));
		return CHtml::listData($model, 'id', 'employeefullname');
	}
        public static function getEmployeedetail($attendance_manager = 0) {
            $condition = 'isActive!="B"';
            if($attendance_manager>0){
                $condition.= ' AND attendance_manager!="'.$attendance_manager.'"';
            }
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
            $model = self::model()->findAll(array('condition' => $condition));
            $arr_employee = array();
            $employee_details = array();
            foreach ($model as $key => $value) {
                $arr_employee[$value->employeefullname] = $value->id;
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
            return CHtml::listData($employee_details, 'id', 'name');
        }
        public static function getProjectManagers() {
           
            $condition = 't.isActive!="B" AND designationdetail.designation_name LIKE "%Project%"';
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
            $model = self::model()->with('designationdetail')->findAll(array('condition' => $condition));
            $arr_employee = array();
            $employee_details = array();
            foreach ($model as $key => $value) {
                $arr_employee[$value->employeefullname] = $value->id;
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
            return CHtml::listData($employee_details, 'id', 'name');
        }
}
