<?php

/**
 * This is the model class for table "{{ws_compressor_stage_details}}".
 *
 * The followings are the available columns in table '{{ws_compressor_stage_details}}':
 * @property integer $id
 * @property integer $compressor_id
 * @property integer $stage_type_id
 * @property integer $stage_no
 * @property integer $quantity
 * @property string $type
 * @property string $part_no
 * @property string $old_part_no
 * @property string $cus_part_no
 * @property string $oem_part_no
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class CompressorStageDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_compressor_stage_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('compressor_id', 'required'),
			array('compressor_id,stage_no, quantity, created_by, product_id, updated_by', 'numerical', 'integerOnly'=>true),
			array('type, part_no, old_part_no, cus_part_no, oem_part_no', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, compressor_id, stage_type_id, stage_no, quantity, type, part_no, old_part_no, cus_part_no, oem_part_no, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'store_details' => array(self::BELONGS_TO, 'Store','part_no'),
		    'compressor_details' => array(self::BELONGS_TO, 'CompressorHeader','compressor_id'),
		    'compressor_stages' => array(self::BELONGS_TO, 'MasterCompressorStages','stage_type_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'compressor_id' => 'Compressor',
			'stage_type_id' => 'Stage Type',
			'stage_no' => 'Stage No',
			'quantity' => 'Quantity',
			'type' => 'Type',
			'part_no' => 'Part No',
			'old_part_no' => 'Old Part No',
			'cus_part_no' => 'Cus Part No',
			'oem_part_no' => 'Oem Part No',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('compressor_id',$this->compressor_id);
		$criteria->compare('stage_type_id',$this->stage_type_id);
		$criteria->compare('stage_no',$this->stage_no);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('part_no',$this->part_no,true);
		$criteria->compare('old_part_no',$this->old_part_no,true);
		$criteria->compare('cus_part_no',$this->cus_part_no,true);
		$criteria->compare('oem_part_no',$this->oem_part_no,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CompressorStageDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
