<?php

/**
 * This is the model class for table "{{ws_compressor_header}}".
 *
 * The followings are the available columns in table '{{ws_compressor_header}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $compressor_name
 * @property string $make
 * @property string $model
 * @property string $manufacture_year
 * @property string $serial_no
 * @property string $capacity
 * @property integer $no_of_stages
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class CompressorHeader extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_compressor_header}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, compressor_name, make,created_by, created_date_time', 'required'),
			array('customer_id, no_of_stages, created_by, updated_by','numerical', 'integerOnly'=>true),
			array('compressor_name, make, model, serial_no', 'length', 'max'=>255),
			array('manufacture_year', 'length', 'max'=>4),
			array('capacity', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, compressor_name, make, model, manufacture_year, serial_no, capacity, no_of_stages, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'customer_det' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'compressor_name' => 'Compressor Name',
			'make' => 'Make',
			'model' => 'Model',
			'manufacture_year' => 'Manufacture Year',
			'serial_no' => 'Serial No',
			'capacity' => 'Capacity',
			'no_of_stages' => 'No Of Stages',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('compressor_name',$this->compressor_name,true);
		$criteria->compare('make',$this->make,true);
		$criteria->compare('model',$this->model,true);
		$criteria->compare('manufacture_year',$this->manufacture_year,true);
		$criteria->compare('serial_no',$this->serial_no,true);
		$criteria->compare('capacity',$this->capacity,true);
		$criteria->compare('no_of_stages',$this->no_of_stages);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CompressorHeader the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
