<?php

class TaskcategoryController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','Save','deleteCategory','Blocktaskcategory','UnBlocktaskcategory','Disable'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
       public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['projects_mas_task_category_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['projects_mas_task_category_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
        }
	
        public function actionGetList()
        {
                $model = new WsMasterTaskCategory();
                $draw   = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                   1 => 'category_name',
                   2 => 't.id',
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                    $searchString = $_POST['search']['value'];
                    $condition .= " AND category_name LIKE '%" . $searchString . "%'";
                }

                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'category_name ASC'));
                
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 foreach ($model as $row)
                {
                    $div = '';
                   
                   
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["projects_mas_task_category_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'workshop/taskcategory/create&id='.$row['id'].'\',\'Edit Category\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                    }
                   // $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteTaskCategory('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>';
               
                   if(isset(Yii::app()->user->havePermissionOn['projects_mas_task_category_disable']) ||  Yii::app()->user->authorised_user == 1)
                   {
   
                     if ($row->is_active == "Y") 
                     {
                       $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disabletaskcategory(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                     }
                     if ($row->is_active == 'N') 
                     {
                           $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enabletaskcategory(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                     }            
                   
                   }
                   
                   $rowData[]=array($m,
                    $row['category_name'],
                    $row['isDefault'],
                    array('id' => $row['id'],'code'=>$row['category_name'], 'status' => $row->is_active));               
                    $m++;
                    
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }


        public function actionCreate()
        {
            $model = new WsMasterTaskCategory();         
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);               
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model' => $model), false);
        }
       
  
        public function actionSave()
        {
            $model  = new WsMasterTaskCategory();     
            if (isset($_POST['WsMasterTaskCategory']))
            {
    		if (!empty($_POST['WsMasterTaskCategory']['id']))
                { 
                        $id= (int) @$_POST['WsMasterTaskCategory']['id'];
                        $model=$model->findByPk($id); 
                        $model->updated_by = Yii::app()->user->id; 
                        $model->updated_date_time = date('Y-m-d h:i:s');                  
                }else{
                        $model->created_by = Yii::app()->user->id; 
                        $model->created_date_time = date('Y-m-d h:i:s');
                }
                if($_POST['WsMasterTaskCategory']['isDefault'] == "Y"){
                	WsMasterTaskCategory::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            	}
                $model->isDefault = $_POST['WsMasterTaskCategory']['isDefault'];
                $model->attributes=$_POST['WsMasterTaskCategory'];
                
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['category_form'];
                        $jsonData['id'] = $model->id;
                       
	                echo CJSON::encode($jsonData);
                }
                else
                {
				       $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        
        public function actionDeleteCategory(){
            $id = $_POST['id'];
            $status = Yii::app()->request->getparam('status');
            $model  = new WsMasterTaskCategory();  
            $model = $model->findByPk($id);
            $model->is_active = ($status == "Y" ) ? "N" : "Y";
            $model->save();
            echo json_encode(array("status" => "success"));
        
        }


        public function actionBlocktaskcategory() {
            $id = $_POST['id'];
            if ($id > 0) {
                WsMasterTaskCategory::model()->updateByPK($id, array('is_active' => "N"));
                 // inserting to audit log
                 $model=new WsMasterTaskCategory();
                 $upt = $model->findByPk($id); // audit log changes
                 AuditLog::saveAuditLogs(
                     'TASKCATEGORY',
                     Yii::app()->user->id,
                     'BLOCKED',
                     " with category name: - {$upt->category_name}  "
                 );
                // end audit log
                $status['status'] = 'success';
            } else {
                $status['status'] = 'error';
            }
            echo CJSON::encode($status);
        }
    
        public function actionUnBlocktaskcategory() {
            $id = $_POST['id'];
            if ($id > 0) {
                WsMasterTaskCategory::model()->updateByPK($id, array('is_active' => "Y"));
                 // inserting to audit log
                 $model=new WsMasterTaskCategory();
                 $upt = $model->findByPk($id); // audit log changes
                 AuditLog::saveAuditLogs(
                     'TASKCATEGORY',
                     Yii::app()->user->id,
                     'UNBLOCKED',
                     " with category name: - {$upt->category_name}  "
                 );
                // end audit log
                $status['status'] = 'success';
            } else {
                $status['status'] = 'error';
            }
            echo CJSON::encode($status);
        }
        public function actionDisable() {
            $id = Yii::app()->request->getparam('id');
            $status = Yii::app()->request->getparam('status');
            $model = new WsMasterTaskCategory();
            $model = $model->findByPk($id);
            $model->is_active = ($status == "Y" ) ? "N" : "Y";
            $model->save();
            echo json_encode(array("status" => "success"));
        }
    }