<?php

class ProjectexternalcompanyController extends Controller {
//code added by rahul on 21-6-22//
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'DeleteExternalCompany','Blockprojectexternalcompany','UnBlockprojectexternalcompany'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {
        $model = new ProjectExternalCompany();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'company_name',
            2 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and company_name LIKE '%" . $searchString . "%'";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
          
               $div = '';
                if(isset(Yii::app()->user->havePermissionOn['projects_mas_external_company_edit']) ||  Yii::app()->user->authorised_user == 1)
                {
                    $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'workshop/projectexternalcompany/create&id=' . $row['id'] . '\',\'Edit Project External Company\',\'lg\')"><i class="fa fa-pencil"></i></button> ';

                }
                if(isset(Yii::app()->user->havePermissionOn['projects_mas_external_company_disable']) ||  Yii::app()->user->authorised_user == 1)
                {

                  if ($row->isActive == "Y") 
                  {
                    $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableprojectexternalcompany(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                  }
                  if ($row->isActive == 'N') 
                  {
                        $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableprojectexternalcompany(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                  }            
                
                }
           
            $rowData[] = array($m,
                $row['company_name'],
                '<div class="btn-wrap">' . $div . '</div>',
                $row['isActive'],
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new ProjectExternalCompany();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false);
    }

    public function actionSave() {
        $model = new ProjectExternalCompany();
        if (isset($_POST['ProjectExternalCompany'])) {
            if (!empty($_POST['ProjectExternalCompany']['id'])) {
                $id = (int) @$_POST['ProjectExternalCompany']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }

            $model->attributes = $_POST['ProjectExternalCompany'];

            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['category_form'];
                $jsonData['id'] = $model->id;

                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteExternalCompany() {
        $id = $_POST['id'];
        $status = Yii::app()->request->getparam('status');
        $model = new ProjectExternalCompany();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

 
    public function actionBlockprojectexternalcompany() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProjectExternalCompany::model()->updateByPK($id, array('isActive' => "N"));
             // inserting to audit log
             $model=new ProjectExternalCompany();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'PROJECTEXTERNALCOMPANY',
                 Yii::app()->user->id,
                 'BLOCKED',
                 " with company name: - {$upt->company_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockprojectexternalcompany() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProjectExternalCompany::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
             $model=new ProjectExternalCompany();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'PROJECTEXTERNALCOMPANY',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with company name: - {$upt->company_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

}